/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cache;

import com.agfa.hap.pacs.impaxee.awt.IIntColorImageHolder;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IPersistentCache;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;

public class RGBBufferedImageHolder
extends BufferedImageHolder
implements IIntColorImageHolder {
    private static final IPersistentCache cache = DataCacheProviderFactory.getPersistentCache();
    public final int[] data;

    public RGBBufferedImageHolder(int n, int n2) {
        super(n, n2, 1);
        this.data = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    }

    public RGBBufferedImageHolder(BufferedImage bufferedImage) {
        super(bufferedImage);
        this.data = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    }

    public RGBBufferedImageHolder(int n, int n2, int[] nArray) {
        this(n, n2);
        System.arraycopy(nArray, 0, this.data, 0, this.data.length);
    }

    public RGBBufferedImageHolder(int n, int n2, CacheID cacheID) {
        this(n, n2);
        try {
            int[] nArray = cache.referencePersistentInts(cacheID);
            System.arraycopy(nArray, 0, this.data, 0, this.data.length);
        }
        finally {
            cache.releaseReference(cacheID);
        }
    }

    private RGBBufferedImageHolder(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2, int n3, int n4) {
        super(rGBBufferedImageHolder, n, n2, n3, n4);
        this.data = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    }

    @Override
    public RGBBufferedImageHolder getSubImage(int n, int n2, int n3, int n4) {
        return new RGBBufferedImageHolder(this, n, n2, n3, n4);
    }

    public int[] getImageArray() {
        return this.data;
    }

    private void clear(int n) {
        Arrays.fill(this.data, n);
    }

    public void clear() {
        this.clear(0);
    }

    public boolean isGrayscale() {
        return false;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }
}

