/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.data.fetcher;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.progress.IActivityIndicator;
import com.agfa.pacs.base.swing.progress.IProgressIndicator;
import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.base.swing.util.ProgressUtil;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.listtext.swingx.util.SwingWorker;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IObjectListener;
import com.tiani.jvision.util.TwoDArrayIterator;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class AbstractLosslessImageFetcher {
    private static final ALogger LOGGER = ALogger.getLogger(AbstractLosslessImageFetcher.class);
    private static final long LOAD_TIMEOUT = Config.impaxee.jvision.LOADING.SeriesLoadTimeout.get();
    protected final VisDisplay2 display;
    protected final IDisplaySet displaySet;

    public AbstractLosslessImageFetcher(VisDisplay2 visDisplay2, IDisplaySet iDisplaySet) {
        this.display = visDisplay2;
        this.displaySet = iDisplaySet;
    }

    protected void startLosslessImageDownload() {
        if (this.queryLosslessImageDownload()) {
            new LossyImageDownloader().start();
        } else {
            this.abortLosslessImageDownload();
        }
    }

    protected boolean queryLosslessImageDownload() {
        String string = Messages.getString("AbstractLosslessImageFetcher.DownloadLosslessImages.Title");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLossyImageWarningMessage());
        stringBuilder.append("\n\n");
        stringBuilder.append(Messages.getString("AbstractLosslessImageFetcher.DownloadLosslessImages.Query"));
        return Message.yesNo(string, stringBuilder.toString()) == 0;
    }

    protected abstract void abortLosslessImageDownload();

    protected abstract void executeAction();

    protected abstract String getLossyImageWarningMessage();

    protected abstract String getLosslessImageDownloadErrorMessage();

    private class LossyImageDownloader
    extends SwingWorker
    implements IObjectListener {
        private final CountDownLatch latch;
        private IProgressIndicator progress;

        LossyImageDownloader() {
            Set<IImageObjectData> set = this.collectImages();
            this.latch = new CountDownLatch(set.size());
            try {
                CursorUtil.setWaitCursor((Component)AbstractLosslessImageFetcher.this.display);
                this.progress = ProgressUtil.createProgressIndicator((Component)AbstractLosslessImageFetcher.this.display, (IComponentFactory)ComponentFactory.instance, (int)1, (boolean)false, (IActivityIndicator.DisplayMode)IActivityIndicator.DisplayMode.DIALOG, (ActionListener[])new ActionListener[0]);
                this.progress.setText(Messages.getString("AbstractLosslessImageFetcher.DownloadLosslessImages.Progress"));
                this.progress.setTotalProgressAmount((long)set.size());
                this.progress.show();
            }
            catch (Exception exception) {
                LOGGER.warn("Creating progress indicator failed.", (Throwable)exception);
            }
            for (IImageObjectData iImageObjectData : set) {
                iImageObjectData.requestDownloadOfLosslessImage((byte)1);
                iImageObjectData.addListener(this);
            }
        }

        private Set<IImageObjectData> collectImages() {
            IFrameObjectData[][] iFrameObjectDataArray = AbstractLosslessImageFetcher.this.displaySet.getFrames();
            HashSet<IImageObjectData> hashSet = new HashSet<IImageObjectData>(AbstractLosslessImageFetcher.this.displaySet.getTotalFrameCount());
            for (IFrameObjectData iFrameObjectData : new TwoDArrayIterator<IFrameObjectData>(iFrameObjectDataArray)) {
                hashSet.add(iFrameObjectData.getMainFrame());
            }
            return hashSet;
        }

        @Override
        public void lossyObjectFinished(IObjectData iObjectData) {
        }

        @Override
        public void objectFinished(IObjectData iObjectData) {
            if (this.progress != null) {
                this.progress.advanceProgress();
            }
            this.latch.countDown();
        }

        public Object construct() {
            try {
                return this.latch.await(LOAD_TIMEOUT, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn("Waiting for download of lossless images interrupted.", (Throwable)interruptedException);
                return !AbstractLosslessImageFetcher.this.displaySet.isBeingLossyPrefetched();
            }
        }

        public void finished() {
            CursorUtil.resetWaitCursor((Component)AbstractLosslessImageFetcher.this.display);
            if (this.progress != null) {
                this.progress.close();
                this.progress = null;
            }
            if (Boolean.TRUE.equals(this.get())) {
                AbstractLosslessImageFetcher.this.executeAction();
            } else {
                LOGGER.debug("Download of lessless images still ongoing, aborting action ...");
                String string = Messages.getString("AbstractLosslessImageFetcher.DownloadLosslessImages.Error.Title");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(Messages.getString("AbstractLosslessImageFetcher.DownloadLosslessImages.Error.Message"));
                stringBuilder.append('\n');
                stringBuilder.append(AbstractLosslessImageFetcher.this.getLosslessImageDownloadErrorMessage());
                Message.error(string, (Object)stringBuilder.toString());
                AbstractLosslessImageFetcher.this.abortLosslessImageDownload();
            }
        }
    }
}

