/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.data.fetcher;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.impaxee.data.fetcher.DisplaySetFetchable;
import com.agfa.pacs.impaxee.data.fetcher.FrameDownloadLatch;
import com.agfa.pacs.impaxee.data.fetcher.IFetchableCollection;
import com.agfa.pacs.impaxee.data.fetcher.IFrameDownloadLatch;
import com.agfa.pacs.impaxee.data.fetcher.IImageDownloadLatch;
import com.agfa.pacs.impaxee.data.fetcher.IImageDownloadListener;
import com.agfa.pacs.impaxee.data.fetcher.ImageDownloadLatch;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.tiani.base.data.IFrameObjectData;

public class FetcherUtils {
    private static final boolean isCDViewer = Product.isCDViewer();

    public static boolean isLossyPrefetchData(IPixelDataFrame<?> iPixelDataFrame) {
        if (isCDViewer) {
            return false;
        }
        if (iPixelDataFrame.getImagePixel() == null) {
            return false;
        }
        CacheID cacheID = iPixelDataFrame.getEncodedDataCacheID();
        if (cacheID == null) {
            return false;
        }
        return cacheID.getGroup().contains("LOSSY");
    }

    public static IFrameDownloadLatch createDownloadLatch(IFrameObjectData iFrameObjectData, String string) {
        FrameDownloadLatch frameDownloadLatch = new FrameDownloadLatch(string);
        iFrameObjectData.addListener(frameDownloadLatch);
        return frameDownloadLatch;
    }

    public static IImageDownloadLatch prioritizeDownload(IDisplaySet iDisplaySet, IImageDownloadListener ... iImageDownloadListenerArray) {
        return new ImageDownloadLatch(new DisplaySetFetchable(iDisplaySet), iImageDownloadListenerArray);
    }

    public static IImageDownloadLatch prioritizeDownload(IFetchableCollection iFetchableCollection, IImageDownloadListener ... iImageDownloadListenerArray) {
        return new ImageDownloadLatch(iFetchableCollection, iImageDownloadListenerArray);
    }
}

