/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.data.fetcher;

import com.agfa.pacs.impaxee.data.fetcher.IFrameDownloadLatch;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameListener;
import com.tiani.base.data.IFrameObjectData;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class FrameDownloadLatch
implements IFrameDownloadLatch,
IFrameListener {
    private static final ALogger LOGGER = ALogger.getLogger(FrameDownloadLatch.class);
    private final String name;
    private final CountDownLatch latch = new CountDownLatch(1);

    FrameDownloadLatch(String string) {
        this.name = string;
    }

    @Override
    public boolean frameAvailable(IFrameObjectData iFrameObjectData, String string) {
        this.latch.countDown();
        return false;
    }

    @Override
    public void notifyHasError(String string) {
        LOGGER.error("{}: Loading frame failed ({})", (Object)this.name, (Object)string);
        this.latch.countDown();
    }

    @Override
    public void await() {
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn("{}: Waiting for loaded frame interrupted", (Object)this.name, (Object)interruptedException);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void await(long l) {
        try {
            if (!this.latch.await(l, TimeUnit.SECONDS)) {
                LOGGER.warn("{}: Waiting for loaded frame timed out", (Object)this.name);
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn("{}: Waiting for loaded frame interrupted", (Object)this.name, (Object)interruptedException);
            Thread.currentThread().interrupt();
        }
    }
}

