/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.data.fetcher;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.fetcher.IFetchableCollection;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.data.fetcher.IImageDownloadLatch;
import com.agfa.pacs.impaxee.data.fetcher.IImageDownloadListener;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IObjectListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ImageDownloadLatch
implements IImageDownloadLatch,
IObjectListener {
    private static final ALogger LOGGER = ALogger.getLogger(ImageDownloadLatch.class);
    private static final IFetcher DATA_FETCHER = DataManager.getInstance().getFetcher();
    private static final long MAXIMUM_DOWNLOAD_TIMEOUT = Config.impaxee.jvision.LOADING.SeriesLoadTimeout.get();
    private final CountDownLatch latch;
    private final IImageDownloadListener[] listeners;

    ImageDownloadLatch(IFetchableCollection iFetchableCollection, IImageDownloadListener ... iImageDownloadListenerArray) {
        Collection<IImageObjectData> collection = this.getImageObjects(iFetchableCollection.getFrames());
        this.latch = new CountDownLatch(collection.size());
        this.listeners = iImageDownloadListenerArray;
        DATA_FETCHER.changeToHigherPriorityIfExists(iFetchableCollection.getLoadables(), (byte)1);
        for (IImageObjectData iImageObjectData : collection) {
            iImageObjectData.requestDownloadOfLosslessImage((byte)1);
            iImageObjectData.addListener(this);
        }
    }

    private Collection<IImageObjectData> getImageObjects(Iterable<IFrameObjectData> iterable) {
        HashSet<IImageObjectData> hashSet = new HashSet<IImageObjectData>();
        for (IFrameObjectData iFrameObjectData : iterable) {
            hashSet.add(iFrameObjectData.getMainFrame());
        }
        return hashSet;
    }

    @Override
    public boolean await(long l) {
        block3: {
            if (!this.latch.await(Math.min(MAXIMUM_DOWNLOAD_TIMEOUT, l), TimeUnit.SECONDS)) break block3;
            return true;
        }
        try {
            LOGGER.warn("Downloading images timed out with {} missing images.", (Object)this.latch.getCount());
        }
        catch (InterruptedException interruptedException) {
            LOGGER.error("Waiting for image download interrupted", (Throwable)interruptedException);
        }
        return false;
    }

    @Override
    public void lossyObjectFinished(IObjectData iObjectData) {
    }

    @Override
    public void objectFinished(IObjectData iObjectData) {
        this.latch.countDown();
        if (this.latch.getCount() <= 0L) {
            IImageDownloadListener[] iImageDownloadListenerArray = this.listeners;
            int n = this.listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IImageDownloadListener iImageDownloadListener = iImageDownloadListenerArray[n2];
                iImageDownloadListener.onDownloadComplete();
                ++n2;
            }
        }
    }
}

