/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.data.manager;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.PatientMergeUtilities;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.fetcher.DataHandlerProviderFactory;
import com.agfa.pacs.impaxee.data.fetcher.IFetchable;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.data.fetcher.IPerform;
import com.agfa.pacs.impaxee.data.fetcher.IStore;
import com.agfa.pacs.impaxee.data.manager.HangingEvaluation;
import com.agfa.pacs.impaxee.data.manager.IDataManagerListener;
import com.agfa.pacs.impaxee.data.manager.IDisplaySetListener;
import com.agfa.pacs.impaxee.frameofreference.FrameOfReferenceManager;
import com.agfa.pacs.impaxee.hanging.HangingRuntimeManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IMultiplePatientHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.ISinglePatientHanging;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.PatientComparator;
import com.agfa.pacs.impaxee.hanging.impl.PatientRepresentationFactory;
import com.agfa.pacs.impaxee.hanging.impl.SimpleStudyContainer;
import com.agfa.pacs.impaxee.hanging.model.RelativeInteger;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.runtime.DefaultHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingDefinitionRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.impaxee.save.gui.UnsavedDataManager;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSet;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.agfa.pacs.tools.IDisposable;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.base.data.RawDataContainerTokenCreator;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.toptoolbar.PatientInfoAction;
import com.tiani.jvision.util.Index;
import com.tiani.jvision.util.TwoDArrayIterator;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import javax.swing.JFrame;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class DataManager {
    private static final ALogger log = ALogger.getLogger(DataManager.class);
    public static final int MAXIMAL_NUMBER_OF_PATIENTS_IN_MEMORY = 2;
    private static volatile boolean RETRIEVE_LOSSY = false;
    public static final boolean NEW_STUDIES_GET_ACTIVATED = Config.impaxee.jvision.HANGMAN.NewLoadedStudiesWillBeSelected.get();
    private static final boolean MERGE_BASED_ON_OTHER_PATIENT_ID_SEQ = Config.impaxee.jvision.mergeBasedOnOtherPatientIDSequence.get();
    private static final DataManager instance = new DataManager();
    private static IDicomCache dicomCache = DicomCacheFactory.getInstance().getDicomCache();
    private IFetcher fetcher = DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getFetcher();
    private Map<String, IPatientRepresentation> patientMap;
    private final List<IPatientData> patients = new ArrayList<IPatientData>();
    private Set<IDataManagerListener> listeners;
    private List<IDisplaySetListener> displaySetListeners;
    private Map<String, String> temporaryMergedPatients = new HashMap<String, String>();
    private boolean prefLoadKeyImages;
    private volatile boolean isBeingCleared;

    public static DataManager getInstance() {
        return instance;
    }

    private DataManager() {
        this.patientMap = new Hashtable<String, IPatientRepresentation>();
        this.listeners = new CopyOnWriteArraySet<IDataManagerListener>();
        this.displaySetListeners = new ArrayList<IDisplaySetListener>();
    }

    public static void setLossyPrefetchingEnabled(boolean bl) {
        RETRIEVE_LOSSY = bl;
    }

    public static boolean isLossyPrefetchingEnabled() {
        return RETRIEVE_LOSSY;
    }

    public List<String> getNotLoadedSOPInstanceUIDs(List<String> list, IPatientRepresentation iPatientRepresentation) {
        if (iPatientRepresentation == null) {
            return list;
        }
        for (ISeriesData iSeriesData : iPatientRepresentation.getPatientData().getSeries()) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iSeriesData.getObjectsByUID(iterator.next()) == null) continue;
                iterator.remove();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFrameObjectData[] getFrameObjectData(String string, IPatientRepresentation iPatientRepresentation) {
        List<IPatientRepresentation> list;
        assert (string != null) : "No valid sopInstanceUID provided!";
        if (iPatientRepresentation == null) {
            List<IPatientData> object = this.patients;
            synchronized (object) {
                list = this.getPatientRepresentations();
            }
        } else {
            list = Collections.singletonList(iPatientRepresentation);
        }
        for (IPatientRepresentation iPatientRepresentation2 : list) {
            List<ISeriesData> list2 = iPatientRepresentation2.getPatientData().getSeries();
            for (ISeriesData iSeriesData : list2) {
                IImageObjectData iImageObjectData = iSeriesData.getObjectsByUID(string);
                if (iImageObjectData == null) continue;
                return iImageObjectData.frames();
            }
        }
        return null;
    }

    public long getRequiredMemory(int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = n;
        long l = 0L;
        long l2 = 0L;
        if (!Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get() && !Product.isReducedVersion()) {
            for (IPatientRepresentation iPatientRepresentation : this.patientMap.values()) {
                n2 += iPatientRepresentation.getNumberOfStudieContainers();
                n3 += iPatientRepresentation.getNumberOfInstances();
                if (iPatientRepresentation.getNumberOfInstances() <= n4) continue;
                n4 = iPatientRepresentation.getNumberOfInstances();
            }
            l = (long)n2 * Config.impaxee.jvision.memory.StudySize.get();
            l2 = this.patients.size() > 2 ? Config.impaxee.jvision.memory.ObjectSize.get() : Config.impaxee.jvision.memory.ObjectSizeNotInCache.get();
        }
        l += (long)(n3 -= n4) * l2;
        if (log.isDebugEnabled() && (l += (long)n4 * Config.impaxee.jvision.memory.ObjectSizeOfLoadedPatient.get()) != 0L) {
            log.debug("Currently in IA:" + n2 + " studies," + n4 + " largest Patient," + n3 + " instances in " + this.patients.size() + " patients. Together:" + l / 0x100000L + "MB");
        }
        return l;
    }

    public IHanging addHangingProtocol(HangingProtocol hangingProtocol, IStudyContainer iStudyContainer) {
        IPatientRepresentation iPatientRepresentation = iStudyContainer.getPatientRepresentation();
        IHanging iHanging = iPatientRepresentation.applyHangingProtocol(hangingProtocol, iStudyContainer);
        this.notifyPatientRepresentationModified(iPatientRepresentation);
        return iHanging;
    }

    private IPatientRepresentation findSamePatient(IPatientData iPatientData) {
        IPatientRepresentation iPatientRepresentation = this.patientMap.get(iPatientData.getKey());
        if (iPatientRepresentation == null) {
            IPatientData iPatientData2 = this.getSimilarPatient(iPatientData.getQueryObject().getAttributes(), this.patients);
            if (iPatientData2 == null) {
                iPatientData2 = this.getMergedPatient(iPatientData.getKey());
            }
            if (iPatientData2 != null) {
                PatientMergeUtilities.markPatientMerged((IPatientInfo)((IPatientInfo)iPatientData2.getQueryObject()), (IPatientInfo)((IPatientInfo)iPatientData.getQueryObject()));
                Config.impaxee.jvision.MAPPING.UseAnonymousMode.set(false);
                this.updatePatientInfo();
                return this.patientMap.get(iPatientData2.getKey());
            }
            return null;
        }
        return iPatientRepresentation;
    }

    public Pair<IPatientRepresentation, SplitAndSortChangeSet> addPatient(IPatientRepresentation iPatientRepresentation, List<ISeriesData> list) {
        if (this.isBeingCleared) {
            return null;
        }
        String string = iPatientRepresentation.getPatientKey();
        IPatientRepresentation iPatientRepresentation2 = this.findSamePatient(iPatientRepresentation.getPatientData());
        boolean bl = false;
        if (iPatientRepresentation2 == null) {
            if (!this.checkRemoveOtherPatients(iPatientRepresentation.getPatientKey())) {
                return null;
            }
            AbstractPAction.notifyNonPActionPerformed("ADD_PATIENT");
            this.patientMap.put(string, iPatientRepresentation);
            this.patients.add(iPatientRepresentation.getPatientData());
            if (this.patients.size() == 2) {
                iPatientRepresentation.setLoadPriority((byte)6);
            }
            iPatientRepresentation2 = iPatientRepresentation;
            bl = true;
        } else {
            for (IObjectInfo object : iPatientRepresentation.getPatientData().getAdditionalObjects()) {
                iPatientRepresentation2.getPatientData().addAdditionalObjects(object);
            }
            for (IStudyData iStudyData : iPatientRepresentation.getPatientData().getStudies()) {
                IStudyData iStudyData2 = iPatientRepresentation2.getPatientData().getStudy(iStudyData.getKey());
                if (iStudyData2 == null) {
                    iPatientRepresentation2.getPatientData().addStudy(iStudyData, true);
                    iStudyData2 = iStudyData;
                    bl = true;
                } else {
                    for (ISeriesData iSeriesData : iStudyData.getSeries()) {
                        ISeriesData iSeriesData2 = iStudyData2.getSeries(iSeriesData.getKey());
                        if (iSeriesData2 == null) {
                            iStudyData2.addSeries(iSeriesData);
                            bl = true;
                            continue;
                        }
                        if (iSeriesData2.getObjectCount() != iSeriesData.getObjectCount() || DataManager.isFromXDS(iSeriesData)) {
                            for (IImageObjectData iImageObjectData : iSeriesData.getObjects()) {
                                iSeriesData2.addObject(iImageObjectData);
                            }
                            bl = true;
                            continue;
                        }
                        log.warn("Series already there{}", (Object)iSeriesData.getKey());
                    }
                }
                if (!bl) continue;
                iPatientRepresentation2.getPatientData().touchStudy(iStudyData2);
            }
        }
        if (bl) {
            SplitAndSortChangeSet splitAndSortChangeSet = this.updatePatient(iPatientRepresentation2, list);
            if (iPatientRepresentation2 == iPatientRepresentation) {
                this.notifyPatientAdded(iPatientRepresentation2);
            }
            return Pair.of((Object)iPatientRepresentation2, (Object)splitAndSortChangeSet);
        }
        return Pair.of((Object)iPatientRepresentation2, (Object)new SplitAndSortChangeSet(iPatientRepresentation2.getDecompositionRuntime(), SplitAndSortChangeType.DATA_LOAD, Collections.emptyList()));
    }

    private static boolean isFromXDS(ISeriesData iSeriesData) {
        IDataInfoSource iDataInfoSource = iSeriesData.getQueryObject().getSource();
        return iDataInfoSource instanceof IDataInfoNode && "XDS".equals(((IDataInfoNode)iDataInfoSource).getType());
    }

    private SplitAndSortChangeSet updatePatient(IPatientRepresentation iPatientRepresentation, Collection<ISeriesData> collection) {
        Lock lock = iPatientRepresentation.getPatientModificationLock();
        lock.lock();
        try {
            iPatientRepresentation.updateObjectCount();
            SplitAndSortChangeSet splitAndSortChangeSet = iPatientRepresentation.getDecompositionRuntime().addSeries(collection);
            this.applySplitAndSortChange(splitAndSortChangeSet);
            SplitAndSortChangeSet splitAndSortChangeSet2 = splitAndSortChangeSet;
            return splitAndSortChangeSet2;
        }
        finally {
            lock.unlock();
        }
    }

    public IDisplaySet addSeriesToDisplay(Collection<ISeriesData> collection, Object object) {
        if (collection.isEmpty()) {
            return null;
        }
        IStudyData iStudyData = collection.iterator().next().getParent();
        IPatientData iPatientData = iStudyData.getParent();
        iPatientData.touchStudy(iStudyData);
        IPatientRepresentation iPatientRepresentation = this.findSamePatient(iPatientData);
        boolean bl = false;
        if (iPatientRepresentation == null) {
            iPatientRepresentation = PatientRepresentationFactory.getInstance().newPatientRepresentation(iPatientData);
            this.patientMap.put(iPatientData.getKey(), iPatientRepresentation);
            this.patients.add(iPatientData);
            bl = true;
        }
        SplitAndSortChangeSet splitAndSortChangeSet = this.updatePatient(iPatientRepresentation, collection);
        List<IDisplaySet> list = splitAndSortChangeSet.getDisplaySetsAdded();
        IHanging iHanging = iPatientRepresentation.getActiveHanging();
        if (iHanging != null) {
            if (!list.isEmpty()) {
                this.notifyDisplaySetAdded(iPatientRepresentation, list, SplitAndSortChangeType.DATA_LOAD);
            }
            DataSelectionManager.getInstance().setCurrentPatient(iPatientRepresentation);
        } else {
            SimpleStudyContainer simpleStudyContainer = new SimpleStudyContainer(iStudyData);
            iPatientRepresentation.addStudyContainer(simpleStudyContainer);
            DefaultHangingProtocolRuntime defaultHangingProtocolRuntime = new DefaultHangingProtocolRuntime(simpleStudyContainer, iPatientRepresentation.getDecompositionRuntime());
            iPatientRepresentation.addHanging(defaultHangingProtocolRuntime);
            DataSelectionManager.getInstance().setActiveHanging(iPatientRepresentation, defaultHangingProtocolRuntime, true, true);
            DataSelectionManager.getInstance().setCurrentPatient(iPatientRepresentation);
        }
        if (object != null && object instanceof VisDisplay2 && !list.isEmpty()) {
            ((VisDisplay2)object).initVisDisplay(list.get(0), null, true, ActivationMode.MANUAL);
        }
        if (bl) {
            this.notifyPatientAdded(iPatientRepresentation);
        }
        return list.get(0);
    }

    public IHanging refreshHangings(IPatientRepresentation iPatientRepresentation, boolean bl, boolean bl2) {
        IHanging iHanging;
        if (!iPatientRepresentation.hasUncheckedStudyContainers() || iPatientRepresentation.hasRunningHPEvaluation()) {
            IHanging iHanging2 = bl2 ? null : iPatientRepresentation.getActiveHanging();
            return iHanging2;
        }
        HangingEvaluation hangingEvaluation = null;
        if (bl2) {
            hangingEvaluation = HangingRuntimeManager.getInstance().triggerFirstHPEvaluation(iPatientRepresentation);
        }
        if (hangingEvaluation == null) {
            if (bl2) {
                boolean bl3;
                iHanging = this.createDefaultHangingState(iPatientRepresentation.getStudyContainers().get(0));
                iPatientRepresentation.addHanging(iHanging);
                boolean bl4 = bl3 = iPatientRepresentation.getActiveHanging() != null;
                if (!bl3) {
                    DataSelectionManager.getInstance().setActiveHanging(iPatientRepresentation, iHanging, true, false);
                }
            } else {
                iHanging = iPatientRepresentation.getActiveHanging();
            }
        } else {
            iHanging = iPatientRepresentation.applyHangingProtocol(hangingEvaluation.hp, hangingEvaluation.container);
            DataSelectionManager.getInstance().setActiveHanging(iPatientRepresentation, iHanging, true, false);
        }
        if (bl) {
            this.notifyPatientRepresentationModified(iPatientRepresentation);
        }
        HangingRuntimeManager.getInstance().triggerFurtherHPEvaluation(iPatientRepresentation, hangingEvaluation);
        return iHanging;
    }

    private boolean checkRemoveOtherPatients(String string) {
        if (Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get() && string != null) {
            for (IPatientRepresentation iPatientRepresentation : this.getPatientRepresentations()) {
                if (string.equals(iPatientRepresentation.getPatientKey()) || this.removePatientInt(iPatientRepresentation, true, false)) continue;
                return false;
            }
        }
        return true;
    }

    public IPatientData getPatient(String string) {
        IPatientRepresentation iPatientRepresentation = this.patientMap.get(string);
        if (iPatientRepresentation != null) {
            return iPatientRepresentation.getPatientData();
        }
        return null;
    }

    private String getSimpleID(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (!attributes.containsValue(0x100021)) {
            return null;
        }
        return String.valueOf(attributes.getString(0x100020)) + "\u00a7" + attributes.getString(0x100021);
    }

    public IPatientData getSimilarPatient(Attributes attributes, Collection<IPatientData> collection) {
        String string;
        if (!MERGE_BASED_ON_OTHER_PATIENT_ID_SEQ) {
            return null;
        }
        Sequence sequence = attributes.getSequence(0x101002);
        HashSet<String> hashSet = new HashSet<String>();
        if (sequence != null && !sequence.isEmpty()) {
            int n = 0;
            while (n < sequence.size()) {
                string = (Attributes)sequence.get(n);
                String string2 = this.getSimpleID((Attributes)string);
                if (string2 != null) {
                    hashSet.add(string2);
                }
                ++n;
            }
        }
        if ((string = this.getSimpleID(attributes)) != null) {
            hashSet.add(string);
        }
        for (IPatientRepresentation iPatientRepresentation : this.patientMap.values()) {
            if (!this.samePatient(iPatientRepresentation.getPatientData(), hashSet)) continue;
            return iPatientRepresentation.getPatientData();
        }
        if (collection != null) {
            for (IPatientData iPatientData : collection) {
                if (!this.samePatient(iPatientData, hashSet)) continue;
                return iPatientData;
            }
        }
        return null;
    }

    private boolean samePatient(IPatientData iPatientData, Set<String> set) {
        String string = this.getSimpleID(iPatientData.getDicomObject());
        if (string != null && set.contains(string)) {
            return true;
        }
        Sequence sequence = iPatientData.getDicomObject().getSequence(0x101002);
        if (sequence != null && !sequence.isEmpty()) {
            int n = 0;
            while (n < sequence.size()) {
                Attributes attributes = (Attributes)sequence.get(n);
                String string2 = this.getSimpleID(attributes);
                if (string2 != null && set.contains(string2)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPatientData getMergedPatient(String string) {
        if (this.temporaryMergedPatients.isEmpty()) {
            return null;
        }
        Map<String, String> map = this.temporaryMergedPatients;
        synchronized (map) {
            String string2;
            block5: {
                string2 = this.temporaryMergedPatients.get(string);
                if (string2 != null) break block5;
                return null;
            }
            return this.getPatient(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markTemporaryMerged(String string, List<String> list) {
        Map<String, String> map = this.temporaryMergedPatients;
        synchronized (map) {
            for (String string2 : list) {
                this.temporaryMergedPatients.put(string2, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTemporaryMergeActiveForPatient(String string) {
        Map<String, String> map = this.temporaryMergedPatients;
        synchronized (map) {
            return this.temporaryMergedPatients.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPatientMergedTo(String string, String string2) {
        Map<String, String> map = this.temporaryMergedPatients;
        synchronized (map) {
            return CompareUtils.equals((Object)this.temporaryMergedPatients.get(string2), (Object)string);
        }
    }

    public boolean isStudyMerged(IStudyData iStudyData) {
        if (iStudyData != null) {
            String string;
            String string2 = iStudyData.getQueryObject().getTreeParent().getKey();
            return !string2.equals(string = iStudyData.getParent().getKey());
        }
        return false;
    }

    public void updatePatientInfo() {
        VisData visData = VisData.getLastModified();
        if (visData != null) {
            VisData.patientInfoUpdate(visData.getParent().getDisplaySet());
        }
    }

    public List<IPatientData> getPatientDatas() {
        return new ArrayList<IPatientData>(this.patients);
    }

    public int getPatientCount() {
        return this.patients.size();
    }

    public int getPatientPosition(IPatientRepresentation iPatientRepresentation) {
        if (iPatientRepresentation == null) {
            return -1;
        }
        return this.patients.indexOf(iPatientRepresentation.getPatientData());
    }

    public IPatientRepresentation getPatientOnPosition(int n) {
        if (n < 0 || n >= this.patients.size()) {
            return null;
        }
        return this.patientMap.get(this.patients.get(n).getKey());
    }

    public List<IPatientRepresentation> getPatientRepresentations() {
        return new ArrayList<IPatientRepresentation>(this.patientMap.values());
    }

    public IPatientRepresentation getPatientRepresentation(String string) {
        return this.patientMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPatientRepresentation getPatientRepresentation(Attributes attributes) {
        String string = PatientKeyUtils.generatePatientKey((Attributes)attributes);
        List<IPatientRepresentation> list = this.getPatientRepresentations();
        List<IPatientData> list2 = this.patients;
        synchronized (list2) {
            for (IPatientRepresentation iPatientRepresentation : list) {
                if (!PatientKeyUtils.patientKeysEquals((String)string, (String)iPatientRepresentation.getPatientKey())) continue;
                return iPatientRepresentation;
            }
        }
        return null;
    }

    public IPatientRepresentation getPatientRepresentationWeakMatch(Attributes attributes) {
        try {
            String string = attributes.getString(0x100010);
            String string2 = attributes.getString(0x100030);
            List<IPatientRepresentation> list = this.getPatientRepresentations();
            for (IPatientRepresentation iPatientRepresentation : list) {
                Attributes attributes2 = iPatientRepresentation.getPatientData().getDicomObject();
                if (!string.equals(attributes2.getString(0x100010)) || string2 != null && !string2.equals(attributes2.getString(0x100030))) continue;
                return iPatientRepresentation;
            }
        }
        catch (Exception exception) {
            log.error(null, (Throwable)exception);
        }
        return null;
    }

    public ISeriesData getSerie(String string) {
        ISeriesData iSeriesData = null;
        for (IPatientData iPatientData : this.getPatientDatas()) {
            iSeriesData = iPatientData.getSerie(string);
            if (iSeriesData == null) continue;
            return iSeriesData;
        }
        return null;
    }

    public IDataObject removePatient(String string, boolean bl, boolean bl2) {
        IPatientRepresentation iPatientRepresentation = this.getPatientRepresentation(string);
        if (iPatientRepresentation != null) {
            this.removePatientInt(iPatientRepresentation, bl, bl2);
            return iPatientRepresentation.getPatientData();
        }
        return null;
    }

    public boolean triggerPatientRemoval(String string, boolean bl, boolean bl2) {
        IPatientRepresentation iPatientRepresentation = this.getPatientRepresentation(string);
        if (iPatientRepresentation != null) {
            return this.removePatientInt(iPatientRepresentation, bl, bl2);
        }
        return true;
    }

    private boolean removePatientInt(IPatientRepresentation iPatientRepresentation, boolean bl, boolean bl2) {
        assert (iPatientRepresentation != null) : "cannot remove null patient";
        if (bl) {
            try {
                if (!new UnsavedDataManager().manageSave((JFrame)JVision2.getMainFrame(), Collections.singleton(iPatientRepresentation), null)) {
                    return false;
                }
            }
            catch (Exception exception) {
                log.error(null, (Throwable)exception);
                return false;
            }
        }
        if (this.patientMap.containsKey(iPatientRepresentation.getPatientData().getKey())) {
            if (bl) {
                this.notifyPatientWillBeRemoved(iPatientRepresentation);
            }
            this.patientMap.remove(iPatientRepresentation.getPatientData().getKey());
            this.patients.remove(iPatientRepresentation.getPatientData());
            this.cleanMergedMap(iPatientRepresentation.getPatientData().getKey());
            if (bl) {
                this.clearPatientDataContext(iPatientRepresentation);
                this.notifyPatientRemoved(iPatientRepresentation, bl2);
            }
            iPatientRepresentation.cleanUp();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanMergedMap(String string) {
        if (this.temporaryMergedPatients.isEmpty()) {
            return;
        }
        Map<String, String> map = this.temporaryMergedPatients;
        synchronized (map) {
            Iterator<Map.Entry<String, String>> iterator = this.temporaryMergedPatients.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getValue().equals(string)) continue;
                iterator.remove();
            }
        }
    }

    public void removeHangingState(IHanging iHanging) {
        Collection<IPatientRepresentation> collection;
        boolean bl = true;
        if (iHanging instanceof ISinglePatientHanging) {
            IPatientRepresentation iPatientRepresentation = ((ISinglePatientHanging)iHanging).getPatient();
            bl = this.removeHangingStateFromPatient(iPatientRepresentation, iHanging);
        } else if (iHanging instanceof IMultiplePatientHanging && (collection = ((IMultiplePatientHanging)iHanging).getPatients()) != null) {
            for (IPatientRepresentation iPatientRepresentation : collection) {
                bl &= this.removeHangingStateFromPatient(iPatientRepresentation, iHanging);
            }
        }
        if (bl) {
            this.notifyHangingStateRemoved(iHanging);
        }
    }

    private boolean removeHangingStateFromPatient(IPatientRepresentation iPatientRepresentation, IHanging iHanging) {
        if (iPatientRepresentation.removeHanging(iHanging.getIdentifier()) != null) {
            if (iPatientRepresentation.countHangings() <= 0) {
                iPatientRepresentation.addHanging(this.createDefaultHangingState(iHanging.getStudyContainer()));
            }
            return true;
        }
        return false;
    }

    public IStudyData getStudyByStudyInstanceUID(String string) {
        for (IPatientData iPatientData : this.getPatientDatas()) {
            for (IStudyData iStudyData : iPatientData.getStudies()) {
                if (!iStudyData.getStudyInstanceUID().equals(string)) continue;
                return iStudyData;
            }
        }
        return null;
    }

    public synchronized IStudyData createStudy(IStudyInfo iStudyInfo, IPatientData iPatientData, int n, Class<? extends IStudyData> clazz) {
        IStudyData iStudyData = iPatientData.getStudy(iStudyInfo.getKey());
        try {
            if (iStudyData == null) {
                Constructor<? extends IStudyData> constructor = clazz.getConstructor(IStudyInfo.class, Integer.TYPE);
                iStudyData = constructor.newInstance(iStudyInfo, n);
                iStudyData.setParent(iPatientData);
                iPatientData.addStudy(iStudyData, false);
            }
        }
        catch (Exception exception) {
            log.error("Could not create a new study", (Throwable)exception);
        }
        return iStudyData;
    }

    public IStudyData getStudy(String string) {
        IStudyData iStudyData = null;
        for (IPatientData iPatientData : this.getPatientDatas()) {
            iStudyData = iPatientData.getStudy(string);
            if (iStudyData == null) continue;
            return iStudyData;
        }
        return null;
    }

    public List<IStudyData> getAllStudies() {
        ArrayList<IStudyData> arrayList = new ArrayList<IStudyData>();
        ArrayList<IPatientData> arrayList2 = new ArrayList<IPatientData>(this.patients);
        for (IPatientData iPatientData : arrayList2) {
            arrayList.addAll(iPatientData.getStudies());
        }
        return arrayList;
    }

    public void clearAllData() {
        try {
            this.isBeingCleared = true;
            this.removeAllPatients(false, false);
        }
        finally {
            this.isBeingCleared = false;
        }
    }

    public void removeAllPatients(boolean bl, boolean bl2) {
        if (bl && !new UnsavedDataManager().manageSave((JFrame)JVision2.getMainFrame(), null, null)) {
            return;
        }
        for (IPatientRepresentation iPatientRepresentation : this.getPatientRepresentations()) {
            this.removePatient(iPatientRepresentation, bl2);
        }
    }

    public void removeAllButCurrentPatient() {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        HashSet<IPatientRepresentation> hashSet = new HashSet<IPatientRepresentation>();
        for (IPatientRepresentation iPatientRepresentation2 : this.getPatientRepresentations()) {
            if (iPatientRepresentation == iPatientRepresentation2) continue;
            hashSet.add(iPatientRepresentation2);
        }
        if (!new UnsavedDataManager().manageSave((JFrame)JVision2.getMainFrame(), hashSet, null)) {
            return;
        }
        for (IPatientRepresentation iPatientRepresentation2 : hashSet) {
            this.removePatient(iPatientRepresentation2, false);
        }
    }

    private void removePatient(IPatientRepresentation iPatientRepresentation, boolean bl) {
        this.notifyPatientWillBeRemoved(iPatientRepresentation);
        this.removePatientInt(iPatientRepresentation, false, bl);
        this.clearPatientDataContext(iPatientRepresentation);
        this.notifyPatientRemoved(iPatientRepresentation, bl);
        iPatientRepresentation.cleanUp();
    }

    public void setPreferablyLoadKeyImagesEnabled(boolean bl) {
        this.prefLoadKeyImages = bl;
    }

    public boolean isPreferablyLoadKeyImagesEnabled() {
        return this.prefLoadKeyImages;
    }

    public void sortPatients() {
        PatientComparator patientComparator = PatientComparator.INSTANCE;
        Collections.sort(this.patients, patientComparator);
        this.notifyPatientsSorted(patientComparator);
    }

    public void studyAdded(IStudyData iStudyData) {
        this.notifyStudyAdded(iStudyData);
    }

    public void studyRemoved(IPatientData iPatientData, IStudyData iStudyData, boolean bl) {
        dicomCache.unregisterStudyUsage(iStudyData.getKey(), (IDisposable)iStudyData);
        this.notifyStudyRemoved(iPatientData, iStudyData, bl);
    }

    public void removeDisplaySet(IDisplaySet[] iDisplaySetArray, SplitAndSortChangeType splitAndSortChangeType, boolean bl, boolean bl2) {
        Object object;
        if (iDisplaySetArray == null || iDisplaySetArray.length == 0) {
            return;
        }
        ISplitAndSortRuntime iSplitAndSortRuntime = iDisplaySetArray[0].getSplitAndSortRuntime();
        IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iDisplaySetArray2[n2];
            iSplitAndSortRuntime.removeDisplaySet((IDisplaySet)object, splitAndSortChangeType);
            ++n2;
        }
        this.notifyDisplaySetRemoved(Arrays.asList(iDisplaySetArray), splitAndSortChangeType, false);
        if (bl) {
            iDisplaySetArray2 = iDisplaySetArray;
            n = iDisplaySetArray.length;
            n2 = 0;
            while (n2 < n) {
                object = iDisplaySetArray2[n2];
                object.cancelRetrieve();
                ++n2;
            }
            if (iSplitAndSortRuntime.getDisplaySetCount() == 0) {
                this.removePatient(iSplitAndSortRuntime.getPatientRepresentation(), bl2);
            } else {
                object = new HashSet();
                IDisplaySet[] iDisplaySetArray3 = iSplitAndSortRuntime.getDisplaySets();
                int n3 = iDisplaySetArray3.length;
                n = 0;
                while (n < n3) {
                    IDisplaySet iDisplaySet = iDisplaySetArray3[n];
                    object.add(iDisplaySet.getOneObject().getMainFrame().getParent().getParent().getKey());
                    ++n;
                }
                ArrayList<IStudyData> arrayList = new ArrayList<IStudyData>();
                for (IStudyData iStudyData : iSplitAndSortRuntime.getPatientRepresentation().getPatientData().getStudies()) {
                    if (object.contains(iStudyData.getKey())) continue;
                    arrayList.add(iStudyData);
                }
                if (!arrayList.isEmpty()) {
                    this.removeStudies(arrayList, bl2);
                }
            }
        }
    }

    public void addListener(IDataManagerListener iDataManagerListener) {
        this.listeners.add(iDataManagerListener);
    }

    public void addDisplaySetListener(IDisplaySetListener iDisplaySetListener) {
        this.displaySetListeners.add(iDisplaySetListener);
    }

    public void removeListener(IDataManagerListener iDataManagerListener) {
        this.listeners.remove(iDataManagerListener);
    }

    public IFetcher getFetcher() {
        return this.fetcher;
    }

    public IStore getDataStore() {
        return DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getStore();
    }

    public IPerform getDataPerform(String string) {
        return DataHandlerProviderFactory.getInstance().getDataHandlerProvider().getDataPerform(string);
    }

    public void applySplitAndSortChange(final SplitAndSortChangeSet splitAndSortChangeSet) {
        if (splitAndSortChangeSet != null) {
            EventUtil.invoke((Runnable)new Runnable(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    void var6_11;
                    PatientInfoAction patientInfoAction = (PatientInfoAction)PActionRegistry.getAction("PATIENT_INFO");
                    if (patientInfoAction != null) {
                        patientInfoAction.setUpdateEnabled(false);
                    }
                    IFrameObjectData iFrameObjectData = null;
                    IDisplaySet iDisplaySet = null;
                    IDisplaySet iDisplaySet2 = null;
                    if (VisData.getLastModified() != null) {
                        iFrameObjectData = VisData.getLastModified().getFrameData();
                        iDisplaySet = VisData.getLastModified().getParent().getDisplaySet();
                    }
                    DataManager.this.notifyDisplaySetRemoved(splitAndSortChangeSet.getDisplaySetsRemoved(), splitAndSortChangeSet.getType(), false);
                    IPatientRepresentation iPatientRepresentation = splitAndSortChangeSet.getSplitAndSortRuntime().getPatientRepresentation();
                    for (Map.Entry<IDisplaySet, IDisplaySet> object : splitAndSortChangeSet.getDisplaySetsChanged().entrySet()) {
                        if (object.getKey() == iDisplaySet) {
                            iDisplaySet2 = object.getValue();
                        }
                        DataManager.this.replaceDisplaySet(iPatientRepresentation, splitAndSortChangeSet.getType(), object.getKey(), object.getValue());
                    }
                    DataManager.this.notifyDisplaySetAdded(iPatientRepresentation, splitAndSortChangeSet.getDisplaySetsAdded(), splitAndSortChangeSet.getType());
                    if (iFrameObjectData != null && iDisplaySet2 != null) {
                        block1: for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
                            if (visDisplay2.getData().getDisplaySet() != iDisplaySet2) continue;
                            for (VisData visData : visDisplay2.getData().getVis()) {
                                if (!iFrameObjectData.equals(visData.getFrameData())) continue;
                                visData.makeTheLastModified();
                                break block1;
                            }
                        }
                    }
                    boolean bl = false;
                    while (var6_11 < iPatientRepresentation.countHangings()) {
                        if (iPatientRepresentation.getHanging((int)var6_11) instanceof HangingProtocolRuntime) {
                            HangingDefinitionRuntime hangingDefinitionRuntime = ((HangingProtocolRuntime)iPatientRepresentation.getHanging((int)var6_11)).getHangingDefinition();
                            int n = 0;
                            while (n < hangingDefinitionRuntime.getSnapshotCount()) {
                                hangingDefinitionRuntime.getSnapshot(n).setHangingApplied(false);
                                ++n;
                            }
                        }
                        ++var6_11;
                    }
                    if (patientInfoAction != null) {
                        patientInfoAction.setUpdateEnabled(true);
                        if (iPatientRepresentation.getDecompositionRuntime().getDisplaySetCount() == 0) {
                            patientInfoAction.setCurrentData(null);
                        }
                    }
                }
            });
        }
    }

    private IHanging createDefaultHangingState(IStudyContainer iStudyContainer) {
        return new DefaultHangingProtocolRuntime(iStudyContainer, iStudyContainer.getPatientRepresentation().getDecompositionRuntime());
    }

    private void replaceDisplaySet(IPatientRepresentation iPatientRepresentation, SplitAndSortChangeType splitAndSortChangeType, IDisplaySet iDisplaySet, IDisplaySet iDisplaySet2) {
        if (iDisplaySet != null) {
            iDisplaySet.cancelRetrieve();
            Collection<VisDisplay2> collection = this.findVisDisplays(iDisplaySet);
            if (collection != null && !collection.isEmpty()) {
                for (VisDisplay2 visDisplay2 : collection) {
                    Index index2;
                    IFrameObjectData iFrameObjectData = null;
                    int n = visDisplay2.getNavigPos();
                    if (n >= 0 && n < visDisplay2.getVisCount()) {
                        iFrameObjectData = visDisplay2.getVis(n).getFrameData();
                    }
                    this.notifyDisplaySetRemoved(Collections.singletonList(iDisplaySet), splitAndSortChangeType, true);
                    if (iDisplaySet2 == null) continue;
                    this.notifyDisplaySetAdded(iPatientRepresentation, Collections.singletonList(iDisplaySet2), splitAndSortChangeType);
                    n = 0;
                    int n2 = 0;
                    if (iFrameObjectData != null && (index2 = TwoDArrayIterator.indexOf(iDisplaySet2.getFrames(), iFrameObjectData)) != null) {
                        n = index2.getIndex(iDisplaySet2.isPrimaryNavigationInSpace());
                        n2 = index2.getIndex(!iDisplaySet2.isPrimaryNavigationInSpace());
                    }
                    visDisplay2.initVisDisplay(iDisplaySet2, n, RelativeInteger.fromFront(n2), null, false, ActivationMode.DEFAULT, null);
                }
            } else {
                this.notifyDisplaySetRemoved(Collections.singletonList(iDisplaySet), splitAndSortChangeType, false);
                if (iDisplaySet2 != null) {
                    this.notifyDisplaySetAdded(iPatientRepresentation, Collections.singletonList(iDisplaySet2), splitAndSortChangeType);
                }
            }
        }
    }

    private Collection<VisDisplay2> findVisDisplays(IDisplaySet iDisplaySet) {
        ArrayList<VisDisplay2> arrayList = null;
        for (VisScreen2 visScreen2 : JVision2.getMainFrame().getScreens()) {
            for (VisDisplay2 visDisplay2 : visScreen2.getDisplays()) {
                IDisplaySet iDisplaySet2 = visDisplay2.getData().getDisplaySet();
                if (iDisplaySet2 == null || iDisplaySet2.getID() != iDisplaySet.getID()) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<VisDisplay2>();
                }
                arrayList.add(visDisplay2);
            }
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    private void notifyPatientAdded(IPatientRepresentation iPatientRepresentation) {
        this.executeInEventThread(() -> this.listeners.forEach(iDataManagerListener -> iDataManagerListener.patientAdded(iPatientRepresentation)));
    }

    public void notifyPatientRepresentationModified(IPatientRepresentation iPatientRepresentation) {
        this.executeInEventThread(() -> this.listeners.forEach(iDataManagerListener -> iDataManagerListener.patientRepresentationModified(iPatientRepresentation)));
    }

    private void clearPatientDataContext(IPatientRepresentation iPatientRepresentation) {
        if (this.patients.isEmpty()) {
            this.fetcher.resetState();
            RawDataContainerTokenCreator.getInstance().clear();
            log.info("Clearing loading queue");
        }
        FrameOfReferenceManager.clearAllFrames();
        FrameOfReferenceManager.removeFramesOfPatient(iPatientRepresentation.getPatientKey());
    }

    private void notifyPatientWillBeRemoved(IPatientRepresentation iPatientRepresentation) {
        this.executeInEventThread(() -> this.listeners.forEach(iDataManagerListener -> iDataManagerListener.patientWillBeRemoved(iPatientRepresentation)));
    }

    private void notifyPatientRemoved(IPatientRepresentation iPatientRepresentation, boolean bl) {
        this.executeInEventThread(() -> this.listeners.forEach(iDataManagerListener -> iDataManagerListener.patientRemoved(iPatientRepresentation, bl)));
    }

    private void notifyPatientsSorted(Comparator<IPatientData> comparator) {
        this.executeInEventThread(() -> this.listeners.forEach(iDataManagerListener -> iDataManagerListener.patientsSorted(comparator)));
    }

    private void notifyHangingStateRemoved(IHanging iHanging) {
        this.executeInEventThread(() -> this.listeners.forEach(iDataManagerListener -> iDataManagerListener.hangingStateRemoved(iHanging)));
    }

    private void notifyDisplaySetRemoved(final List<IDisplaySet> list, final SplitAndSortChangeType splitAndSortChangeType, final boolean bl) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (IDisplaySet object2 : list) {
            object2.cancelRetrieve();
            object2.getStudy().setStudyIncomplete();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object object2;
                IDisplaySet[] iDisplaySetArray = list.toArray(new IDisplaySet[list.size()]);
                for (Object object2 : DataManager.this.displaySetListeners) {
                    if (bl && VisDisplay2.isClearDisplaySetListener((IDisplaySetListener)object2)) continue;
                    object2.displaySetsRemoved(iDisplaySetArray, splitAndSortChangeType);
                }
                object2 = DataSelectionManager.getInstance().getCurrentPatient();
                if (object2 != null) {
                    int n = 0;
                    while (n < object2.countHangings()) {
                        object2.getHanging(n).displaySetsRemoved(iDisplaySetArray, splitAndSortChangeType);
                        ++n;
                    }
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    public void notifyRepaintDisplaySets() {
        try {
            EventUtil.invoke(() -> this.displaySetListeners.forEach(IDisplaySetListener::repaintDisplaySets));
        }
        catch (Exception exception) {
            log.error("Repainting display sets failed", (Throwable)exception);
        }
    }

    private void notifyDisplaySetAdded(final IPatientRepresentation iPatientRepresentation, final List<IDisplaySet> list, final SplitAndSortChangeType splitAndSortChangeType) {
        Object object;
        if (list == null || list.isEmpty()) {
            return;
        }
        if (iPatientRepresentation.equals(DataSelectionManager.getInstance().getCurrentPatient())) {
            object = new ArrayList(256);
            for (IDisplaySet iDisplaySet : list) {
                object.addAll(iDisplaySet.getLoadable());
            }
            if (!object.isEmpty()) {
                this.fetcher.appendData((List<? extends IFetchable>)object, (byte)5);
            }
        }
        object = new Runnable(){

            @Override
            public void run() {
                int n = 0;
                while (n < iPatientRepresentation.countHangings()) {
                    iPatientRepresentation.getHanging(n).displaySetAdded(iPatientRepresentation, list, splitAndSortChangeType);
                    ++n;
                }
                for (IDisplaySetListener iDisplaySetListener : DataManager.this.displaySetListeners) {
                    iDisplaySetListener.displaySetAdded(iPatientRepresentation, list, splitAndSortChangeType);
                }
            }
        };
        this.executeInEventThread((Runnable)object);
    }

    private void notifyStudyAdded(IStudyData iStudyData) {
        this.executeInEventThread(() -> this.displaySetListeners.forEach(iDisplaySetListener -> iDisplaySetListener.studyAdded(iStudyData)));
    }

    private void notifyStudyRemoved(final IPatientData iPatientData, final IStudyData iStudyData, final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object object2;
                for (Object object2 : DataManager.this.displaySetListeners) {
                    object2.studyRemoved(iStudyData, bl);
                }
                object2 = (IPatientRepresentation)DataManager.this.patientMap.get(iPatientData.getKey());
                if (object2 != null) {
                    int n = 0;
                    while (n < object2.countHangings()) {
                        object2.getHanging(n).studyRemoved(iStudyData, bl);
                        ++n;
                    }
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    private void executeInEventThread(Runnable runnable) {
        try {
            EventUtil.invokeSynchronous((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }

    private void removeStudies(List<IStudyData> list, boolean bl) {
        ArrayList<IDataObject> arrayList = new ArrayList<IDataObject>();
        HashMap<String, IPatientRepresentation> hashMap = new HashMap<String, IPatientRepresentation>();
        hashMap.putAll(this.patientMap);
        if (list != null) {
            for (IStudyData iStudyData : list) {
                arrayList.add(iStudyData.getParent().removeStudy(iStudyData, bl));
            }
        }
        HashSet<IPatientRepresentation> hashSet = new HashSet<IPatientRepresentation>();
        for (Object e : arrayList) {
            Object object;
            if (e == null) continue;
            if (e instanceof IPatientData) {
                object = (IPatientRepresentation)hashMap.get(((IPatientData)e).getKey());
                this.clearPatientDataContext((IPatientRepresentation)object);
                this.notifyPatientRemoved((IPatientRepresentation)object, bl);
                continue;
            }
            if (!(e instanceof IStudyData)) continue;
            object = ((IStudyData)e).getParent().getKey();
            IPatientRepresentation iPatientRepresentation = (IPatientRepresentation)hashMap.get(object);
            hashSet.add(iPatientRepresentation);
        }
        for (IPatientRepresentation iPatientRepresentation : hashSet) {
            if (iPatientRepresentation.getPatientData().getStudies().isEmpty()) {
                this.clearPatientDataContext(iPatientRepresentation);
                this.notifyPatientRemoved(iPatientRepresentation, bl);
                continue;
            }
            iPatientRepresentation.updateObjectCount();
            this.notifyPatientRepresentationModified(iPatientRepresentation);
            iPatientRepresentation.updateStudyContainers();
        }
    }
}

