/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.demographics.model;

import com.agfa.pacs.impaxee.demographics.model.IDemographicsDefinitonChangeListener;
import com.agfa.pacs.impaxee.demographics.model.IDemographicsFontListener;
import com.agfa.pacs.impaxee.utils.FontUtils;
import com.tiani.config.mappingfonts.model.Font;
import com.tiani.config.mappingfonts.model.enums.FontStyle;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractDemographicsElement {
    private Font levelFont;
    private Font parentFont;
    private Font mergedFont;
    private List<IDemographicsFontListener> demographicsFontListeners = new ArrayList<IDemographicsFontListener>();
    private List<IDemographicsDefinitonChangeListener> demographicsDefinitonChangeListeners = new ArrayList<IDemographicsDefinitonChangeListener>();
    private final boolean isQuadMapping;

    protected AbstractDemographicsElement(Font font, Font font2, boolean bl) {
        this.levelFont = font;
        this.parentFont = font2;
        this.mergedFont = FontUtils.mergeFonts(font, font2);
        this.isQuadMapping = bl;
    }

    public void setFontSize(Integer n) {
        Integer n2 = this.mergedFont.getSize();
        if (n2 == null && n != null || n2 != null && !n2.equals(n)) {
            this.mergedFont.setSize(n);
            this.getLevelFont().setSize(n);
            this.informListenersFontChanged();
            this.informListenersContentChanged();
        }
    }

    public void setFontColor(String string) {
        String string2 = this.mergedFont.getColor();
        if (string2 == null && string != null || string2 != null && !string2.equalsIgnoreCase(string)) {
            this.mergedFont.setColor(string);
            this.getLevelFont().setColor(string);
            this.informListenersFontChanged();
            this.informListenersContentChanged();
        }
    }

    public void setFontStyle(FontStyle fontStyle) {
        FontStyle fontStyle2 = this.mergedFont.getStyle();
        if (fontStyle2 == null && fontStyle != null || fontStyle2 != null && fontStyle2.getType() != fontStyle.getType()) {
            this.mergedFont.setStyle(fontStyle);
            this.getLevelFont().setStyle(fontStyle);
            this.informListenersFontChanged();
            this.informListenersContentChanged();
        }
    }

    public void setFontName(String string) {
        String string2 = this.mergedFont.getName();
        if (string2 == null && string != null || string2 != null && !string2.equalsIgnoreCase(string)) {
            this.mergedFont.setName(string);
            this.getLevelFont().setName(string);
            this.informListenersFontChanged();
            this.informListenersContentChanged();
        }
    }

    public final void registerMappingFontListener(IDemographicsFontListener iDemographicsFontListener) {
        if (!this.demographicsFontListeners.contains(iDemographicsFontListener)) {
            this.demographicsFontListeners.add(iDemographicsFontListener);
        }
    }

    private void informListenersFontChanged() {
        for (IDemographicsFontListener iDemographicsFontListener : this.demographicsFontListeners) {
            iDemographicsFontListener.fontChanged(this);
        }
    }

    protected void informListenersContentChanged() {
        for (IDemographicsDefinitonChangeListener iDemographicsDefinitonChangeListener : this.demographicsDefinitonChangeListeners) {
            iDemographicsDefinitonChangeListener.mappingDefinitionChanged(this);
        }
    }

    protected void remergeFonts() {
        FontUtils.mergeFonts(this.levelFont, this.parentFont, this.mergedFont);
        this.informListenersFontChanged();
    }

    public Integer getFontSize() {
        return this.mergedFont.getSize();
    }

    public String getFontColor() {
        return this.mergedFont.getColor();
    }

    public FontStyle getFontStyle() {
        return this.mergedFont.getStyle();
    }

    public String getFontName() {
        return this.mergedFont.getName();
    }

    protected Font getMergedFont() {
        return this.mergedFont;
    }

    private Font getLevelFont() {
        if (this.levelFont == null) {
            this.levelFont = this.createLevelFont();
        }
        return this.levelFont;
    }

    protected abstract Font createLevelFont();

    public boolean isQuadMapping() {
        return this.isQuadMapping;
    }

    public void registerDemographicsDefinitonChangeListener(IDemographicsDefinitonChangeListener iDemographicsDefinitonChangeListener) {
        if (!this.demographicsDefinitonChangeListeners.contains(iDemographicsDefinitonChangeListener)) {
            this.demographicsDefinitonChangeListeners.add(iDemographicsDefinitonChangeListener);
        }
    }

    public void removeMappingFontListener(IDemographicsFontListener iDemographicsFontListener) {
        if (iDemographicsFontListener != null) {
            this.demographicsFontListeners.remove(iDemographicsFontListener);
        }
    }

    public void removeDemographicsDefinitonChangeListener(IDemographicsDefinitonChangeListener iDemographicsDefinitonChangeListener) {
        if (iDemographicsDefinitonChangeListener != null) {
            this.demographicsDefinitonChangeListeners.remove(iDemographicsDefinitonChangeListener);
        }
    }
}

