/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.descriptors;

import com.agfa.pacs.impaxee.hanging.attributes.ConfiguredAttributeFilter;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.impaxee.model.xml.shared.AbstractHighlightedXMLElement;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.ComparatorUtils;

public class Descriptor
extends AbstractHighlightedXMLElement {
    public static final Comparator<Descriptor> COMPARATOR;
    private Long id;
    private Boolean isManufacturer;
    private List<Condition> conditions = new ArrayList<Condition>();

    static {
        Collator collator = Collator.getInstance();
        collator.setStrength(0);
        COMPARATOR = ComparatorUtils.nullLowComparator((descriptor, descriptor2) -> collator.compare(descriptor.name, descriptor2.name));
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public Boolean getIsManufacturer() {
        return this.isManufacturer;
    }

    public void setIsManufacturer(Boolean bl) {
        this.isManufacturer = bl;
    }

    public Condition getCondition(int n) {
        if (n >= 0 && n < this.conditions.size()) {
            return this.conditions.get(n);
        }
        return null;
    }

    public void addCondition(Condition condition) {
        if (condition != null) {
            this.conditions.add(condition);
        }
    }

    public boolean removeCondition(Condition condition) {
        return this.conditions.remove((Object)condition);
    }

    public List<Condition> conditions() {
        return this.conditions;
    }

    public void replaceConditions(List<Condition> list) {
        this.conditions = list;
    }

    public Condition[] conditionsAsArray() {
        return this.conditions.toArray(new Condition[this.conditions.size()]);
    }

    public Descriptor clone() {
        Descriptor descriptor = new Descriptor();
        descriptor.initWith(this);
        return descriptor;
    }

    public void initWith(Descriptor descriptor) {
        this.id = descriptor.id;
        this.isManufacturer = descriptor.isManufacturer;
        this.name = descriptor.name;
        for (Condition condition : descriptor.conditions) {
            this.addCondition(condition);
        }
    }

    public boolean hasSameConditions(Descriptor descriptor) {
        boolean bl = true;
        if (this.conditions().size() != descriptor.conditions().size()) {
            bl = false;
        } else {
            for (Condition condition : this.conditions()) {
                boolean bl2 = false;
                for (Condition condition2 : descriptor.conditions()) {
                    if (!condition2.getTag().equals(condition.getTag()) || condition2.getOperator() != condition.getOperator() || !condition2.getValue().equals(condition.getValue())) continue;
                    bl2 = true;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean containsOnlyCFindOrPrivateTags() {
        for (Condition condition : this.conditions) {
            Integer n = condition.getTag();
            if (n != null && (ConfiguredAttributeFilter.getInstance().containsTag(n) || TagDictionary.getInstance().isPrivatTag(n))) continue;
            return false;
        }
        return true;
    }

    public int conditionCount() {
        return this.conditions.size();
    }
}

