/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.descriptors;

import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.descriptors.DescriptorRegistry;
import com.agfa.pacs.impaxee.descriptors.IDescriptorIDReference;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.AbstractIntermediateXMLElement;
import java.util.ArrayList;
import java.util.List;

public class DescriptorsImportExport
extends AbstractIntermediateXMLElement {
    private static final ALogger log = ALogger.getLogger(DescriptorsImportExport.class);
    protected List<Descriptor> descriptors = new ArrayList<Descriptor>();

    public void addDescriptor(Descriptor descriptor) {
        if (this.descriptors != null) {
            this.descriptors.add(descriptor);
        }
    }

    public Descriptor getDescriptor(int n) {
        if (n >= 0 && n < this.descriptors.size()) {
            return this.descriptors.get(n);
        }
        return null;
    }

    public List<Descriptor> descriptorsAsList() {
        return this.descriptors;
    }

    protected void exportDescriptors(List<? extends IDescriptorIDReference> list) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (IDescriptorIDReference object : list) {
            try {
                arrayList.addAll(object.referencedDescriptorIDs());
            }
            catch (Exception exception) {
                log.error("Error converting hanging protocol to XML", (Throwable)exception);
            }
        }
        for (Long l : arrayList) {
            Descriptor descriptor = DescriptorRegistry.getInstance().getDescriptorWithID(l);
            if (this.descriptors.contains(descriptor)) continue;
            this.descriptors.add(descriptor);
        }
    }
}

