/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.descriptors.gui;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.descriptors.gui.ChooseDicomTagPanel;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTag;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTagUtil;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.logging.ALogger;
import com.tiani.util.expressions.ConditionUtil;
import com.tiani.util.expressions.OperatorEnum;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.MaskFormatter;

public class ConditionPanel
extends JPanel
implements ActionListener,
KeyListener {
    private static final Integer STUDY_DESCRIPTION_TAG = 528432;
    private static final Integer SERIES_DESCRIPTION_TAG = 528446;
    private static final Integer MODALITY_TAG = 524384;
    private static final ALogger log = ALogger.getLogger(ConditionPanel.class);
    private final Icon iconWarningNumber;
    private JComboBox selectionComboBox;
    private JComboBox comparisonOperatorComboBox;
    private JTextField comparisonValueTextField;
    private JFormattedTextField dicomGroupTextField;
    private JFormattedTextField dicomElementTextField;
    private JButton chooseDicomTagButton;
    private JLabel currentDicomTagDisplayJLabel;
    private String[] conditionSelections;
    private String placeholder = "0";
    private Condition condition;
    private boolean restrictTags = false;
    private IComponentFactory componentFactory;
    private List<ChangeListener> changeListeners = null;

    private ConditionPanel(IComponentFactory iComponentFactory, boolean bl, Condition condition) {
        this.restrictTags = bl;
        this.componentFactory = iComponentFactory;
        PIconFactory pIconFactory = new PIconFactory(iComponentFactory, 16);
        this.iconWarningNumber = pIconFactory.loadIcon(ConditionPanel.class, "/icons/hangingGUI/warning_number.svg");
        this.initComponents();
        this.installLayout();
        this.setCondition(condition);
    }

    public ConditionPanel(IComponentFactory iComponentFactory, boolean bl) {
        this(iComponentFactory, bl, null);
    }

    public ConditionPanel(Condition condition, IComponentFactory iComponentFactory) {
        this(iComponentFactory, true, condition);
    }

    private void initComponents() {
        this.conditionSelections = new String[]{Messages.getString("ConditionPanel.StudyDescription"), Messages.getString("ConditionPanel.SeriesDescription"), Messages.getString("ConditionPanel.Modality"), Messages.getString("ConditionPanel.GenericDICOMAttribute")};
        this.selectionComboBox = this.componentFactory.createComboBox((Object[])this.conditionSelections);
        this.dicomGroupTextField = this.componentFactory.createFormattedTextField((JFormattedTextField.AbstractFormatter)this.createFormatter("HHHH"));
        this.dicomElementTextField = this.componentFactory.createFormattedTextField((JFormattedTextField.AbstractFormatter)this.createFormatter("HHHH"));
        this.currentDicomTagDisplayJLabel = this.componentFactory.createLabel(" ");
        this.comparisonOperatorComboBox = this.componentFactory.createComboBox();
        for (OperatorEnum operatorEnum : OperatorEnum.getCommonOperators()) {
            this.comparisonOperatorComboBox.addItem(operatorEnum);
        }
        for (OperatorEnum operatorEnum : OperatorEnum.getConditionalHangingOperators()) {
            this.comparisonOperatorComboBox.addItem(operatorEnum);
        }
        this.comparisonValueTextField = this.componentFactory.createTextField(Integer.valueOf(15));
        this.chooseDicomTagButton = this.componentFactory.createButton(Messages.getString("ConditionPanel.ChooseDicomTag"));
        this.dicomGroupTextField.setEnabled(false);
        this.dicomElementTextField.setEnabled(false);
        this.chooseDicomTagButton.setEnabled(false);
        this.chooseDicomTagButton.addActionListener(this);
        this.enableListeners(true);
        this.updateDicomTagDisplayJLabel();
    }

    private void installLayout() {
        TitledBorder titledBorder = this.componentFactory.createTitledBorder(Messages.getString("ConditionPanel.Condition"));
        this.setBorder(titledBorder);
        JPanel jPanel = SwingUtilities2.createPanel((Boolean)false, null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.add((Component)this.selectionComboBox, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.dicomGroupTextField, new GridBagConstraints(0, 1, 1, 1, 0.3, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.dicomElementTextField, new GridBagConstraints(1, 1, 1, 1, 0.3, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.chooseDicomTagButton, new GridBagConstraints(2, 1, 0, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.currentDicomTagDisplayJLabel, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.setLayout(gridBagLayout2);
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.4, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.comparisonOperatorComboBox, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.2, 13, 2, new Insets(5, 35, 5, 35), 0, 0));
        this.add((Component)this.comparisonValueTextField, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.2, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void dicomTagChoosingEnabled(boolean bl) {
        this.chooseDicomTagButton.setEnabled(bl);
        this.currentDicomTagDisplayJLabel.setEnabled(bl);
    }

    private void enableListeners(boolean bl) {
        if (bl) {
            this.selectionComboBox.addActionListener(this);
            this.comparisonOperatorComboBox.addActionListener(this);
            this.dicomGroupTextField.addKeyListener(this);
            this.dicomElementTextField.addKeyListener(this);
            this.comparisonValueTextField.addKeyListener(this);
        } else {
            this.selectionComboBox.removeActionListener(this);
            this.comparisonOperatorComboBox.removeActionListener(this);
            this.dicomGroupTextField.removeKeyListener(this);
            this.dicomElementTextField.removeKeyListener(this);
            this.comparisonValueTextField.removeKeyListener(this);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.selectionComboBox.setEnabled(bl);
        this.comparisonOperatorComboBox.setEnabled(bl);
        if (bl) {
            if (((String)this.selectionComboBox.getSelectedItem()).equals(Messages.getString("ConditionPanel.GenericDICOMAttribute"))) {
                this.dicomTagChoosingEnabled(true);
            } else {
                this.dicomTagChoosingEnabled(false);
            }
            if (((OperatorEnum)((Object)this.comparisonOperatorComboBox.getSelectedItem())).isUnary()) {
                this.comparisonValueTextField.setEnabled(false);
            } else {
                this.comparisonValueTextField.setEnabled(true);
            }
        } else {
            this.dicomTagChoosingEnabled(false);
            this.comparisonValueTextField.setEnabled(false);
        }
    }

    protected MaskFormatter createFormatter(String string) {
        MaskFormatter maskFormatter = null;
        try {
            maskFormatter = new MaskFormatter(string);
            maskFormatter.setPlaceholderCharacter(this.placeholder.charAt(0));
        }
        catch (ParseException parseException) {
            log.error("formatter is bad: " + parseException.getMessage());
            return null;
        }
        return maskFormatter;
    }

    private void updateDicomTagDisplayJLabel() {
        if (this.condition != null) {
            String string = this.dicomGroupTextField.getText();
            Integer n = DicomTagUtil.combineDicomComponentsToInteger((String)this.dicomElementTextField.getText(), (String)this.dicomGroupTextField.getText());
            if (ConditionUtil.requiresNumberValue(n)) {
                this.currentDicomTagDisplayJLabel.setIcon(this.iconWarningNumber);
                this.currentDicomTagDisplayJLabel.setToolTipText(Messages.getString("ConditionPanel.TagRequiresNumberValues"));
            } else {
                this.currentDicomTagDisplayJLabel.setIcon(null);
                this.currentDicomTagDisplayJLabel.setToolTipText(null);
            }
            if (Integer.valueOf(string, 16) % 2 == 0) {
                String string2 = TagDictionary.getInstance().descriptionForTag(n.intValue());
                if (string2 != null) {
                    this.currentDicomTagDisplayJLabel.setText(string2);
                } else {
                    this.currentDicomTagDisplayJLabel.setText(Messages.getString("ConditionPanel.UnknownTag"));
                }
            } else {
                String string3 = TagDictionary.getInstance().getPrivateTagDictionary().descriptionForTag(n.intValue());
                if (string3 != null) {
                    this.currentDicomTagDisplayJLabel.setText(string3);
                } else {
                    this.currentDicomTagDisplayJLabel.setText(Messages.getString("ConditionPanel.UnknownPrivateTag"));
                }
            }
        } else {
            this.currentDicomTagDisplayJLabel.setIcon(null);
            this.currentDicomTagDisplayJLabel.setToolTipText(null);
            this.currentDicomTagDisplayJLabel.setText("");
        }
    }

    private void updateComparisonValueTextField() {
        Condition condition = this.getCondition();
        this.comparisonValueTextField.setToolTipText(OperatorEnum.getValueFormatHint(condition.getTag(), condition.getOperator()));
    }

    private void setDicomTag(Integer n) {
        this.dicomGroupTextField.setText(DicomTagUtil.getDicomGroupAsHex((Integer)n));
        this.dicomElementTextField.setText(DicomTagUtil.getDicomElementAsHex((Integer)n));
    }

    public void setCondition(Condition condition) {
        Integer n;
        this.enableListeners(false);
        this.condition = condition;
        if (this.condition != null && (n = condition.getTag()) != null) {
            this.selectionComboBox.setEnabled(true);
            this.comparisonOperatorComboBox.setEnabled(true);
            if (n.equals(MODALITY_TAG)) {
                this.selectionComboBox.setSelectedItem(Messages.getString("ConditionPanel.Modality"));
                this.setDicomTag(MODALITY_TAG);
                this.dicomTagChoosingEnabled(false);
            } else if (n.equals(SERIES_DESCRIPTION_TAG)) {
                this.selectionComboBox.setSelectedItem(Messages.getString("ConditionPanel.SeriesDescription"));
                this.setDicomTag(SERIES_DESCRIPTION_TAG);
                this.dicomTagChoosingEnabled(false);
            } else if (n.equals(STUDY_DESCRIPTION_TAG)) {
                this.selectionComboBox.setSelectedItem(Messages.getString("ConditionPanel.StudyDescription"));
                this.setDicomTag(STUDY_DESCRIPTION_TAG);
                this.dicomTagChoosingEnabled(false);
            } else {
                this.selectionComboBox.setSelectedItem(Messages.getString("ConditionPanel.GenericDICOMAttribute"));
                this.dicomTagChoosingEnabled(true);
            }
            if (!this.dicomElementTextField.getText().equals(DicomTagUtil.getDicomElementAsHex((Integer)condition.getTag())) || !this.dicomGroupTextField.getText().equals(DicomTagUtil.getDicomGroupAsHex((Integer)condition.getTag()))) {
                this.dicomElementTextField.setText(DicomTagUtil.getDicomElementAsHex((Integer)condition.getTag()));
                this.dicomGroupTextField.setText(DicomTagUtil.getDicomGroupAsHex((Integer)condition.getTag()));
            }
            this.updateDicomTagDisplayJLabel();
            OperatorEnum operatorEnum = condition.getOperator();
            this.comparisonOperatorComboBox.setSelectedItem((Object)operatorEnum);
            this.comparisonValueTextField.setToolTipText(OperatorEnum.getValueFormatHint(this.condition.getTag(), this.condition.getOperator()));
            if (((OperatorEnum)((Object)this.comparisonOperatorComboBox.getSelectedItem())).isUnary()) {
                this.comparisonValueTextField.setEnabled(false);
            } else {
                this.comparisonValueTextField.setEnabled(true);
                if (!this.comparisonValueTextField.getText().equals(condition.getValue())) {
                    this.comparisonValueTextField.setText(condition.getValue());
                }
            }
        } else {
            this.comparisonOperatorComboBox.setSelectedItem(null);
            this.comparisonValueTextField.setText("");
            this.comparisonValueTextField.setToolTipText(null);
            this.selectionComboBox.setSelectedItem(null);
            this.updateDicomTagDisplayJLabel();
        }
        this.enableListeners(true);
    }

    public Condition getCondition() {
        if (this.condition == null) {
            return null;
        }
        String string = (String)this.selectionComboBox.getSelectedItem();
        if (string.equals(Messages.getString("ConditionPanel.Modality"))) {
            this.condition.setTag(MODALITY_TAG);
        } else if (string.equals(Messages.getString("ConditionPanel.SeriesDescription"))) {
            this.condition.setTag(SERIES_DESCRIPTION_TAG);
        } else if (string.equals(Messages.getString("ConditionPanel.StudyDescription"))) {
            this.condition.setTag(STUDY_DESCRIPTION_TAG);
        } else if (string.equals(Messages.getString("ConditionPanel.GenericDICOMAttribute"))) {
            Integer n = DicomTagUtil.combineDicomComponentsToInteger((String)this.dicomElementTextField.getText(), (String)this.dicomGroupTextField.getText());
            this.condition.setTag(n);
        }
        this.condition.setOperator((OperatorEnum)((Object)this.comparisonOperatorComboBox.getSelectedItem()));
        if (((OperatorEnum)((Object)this.comparisonOperatorComboBox.getSelectedItem())).isUnary()) {
            this.condition.setValue("");
        } else {
            this.condition.setValue(this.comparisonValueTextField.getText());
        }
        return this.condition;
    }

    public void triggerGrabbingOfFocusByTextField() {
        this.comparisonValueTextField.selectAll();
        this.comparisonValueTextField.requestFocusInWindow();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.selectionComboBox) {
            String string = (String)this.selectionComboBox.getSelectedItem();
            if (string.equals(Messages.getString("ConditionPanel.GenericDICOMAttribute"))) {
                this.dicomTagChoosingEnabled(true);
            } else {
                this.enableListeners(false);
                if (string.equals(Messages.getString("ConditionPanel.Modality"))) {
                    this.setDicomTag(MODALITY_TAG);
                } else if (string.equals(Messages.getString("ConditionPanel.SeriesDescription"))) {
                    this.setDicomTag(SERIES_DESCRIPTION_TAG);
                } else if (string.equals(Messages.getString("ConditionPanel.StudyDescription"))) {
                    this.setDicomTag(STUDY_DESCRIPTION_TAG);
                }
                this.triggerGrabbingOfFocusByTextField();
                this.enableListeners(true);
                this.dicomTagChoosingEnabled(false);
                this.stateChanged();
            }
            this.updateComparisonValueTextField();
            this.updateDicomTagDisplayJLabel();
        } else if (actionEvent.getSource() == this.chooseDicomTagButton) {
            DicomTag dicomTag;
            ChooseDicomTagPanel chooseDicomTagPanel = new ChooseDicomTagPanel(this.componentFactory, this.restrictTags);
            int n = this.componentFactory.showOKCancelDialog(Messages.getString("ConditionPanel.ChooseDicomTag"), (JComponent)chooseDicomTagPanel, (Component)this, true);
            if (n == 0 && (dicomTag = chooseDicomTagPanel.getDicomTag()) != null) {
                this.enableListeners(false);
                this.setDicomTag(dicomTag.getNumber());
                this.enableListeners(true);
                this.updateComparisonValueTextField();
                this.updateDicomTagDisplayJLabel();
                this.stateChanged();
            }
        } else if (actionEvent.getSource() == this.comparisonOperatorComboBox) {
            if (((OperatorEnum)((Object)this.comparisonOperatorComboBox.getSelectedItem())).isUnary()) {
                this.comparisonValueTextField.setEnabled(false);
            } else {
                this.comparisonValueTextField.setEnabled(true);
            }
            this.updateComparisonValueTextField();
            this.triggerGrabbingOfFocusByTextField();
            this.stateChanged();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 37 && keyEvent.getKeyCode() != 38 && keyEvent.getKeyCode() != 39 && keyEvent.getKeyCode() != 40 && keyEvent.getKeyCode() != 18 && keyEvent.getKeyCode() != 65406 && keyEvent.getKeyCode() != 20 && keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 16) {
            this.updateDicomTagDisplayJLabel();
            this.stateChanged();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private void stateChanged() {
        if (this.changeListeners == null) {
            return;
        }
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new Vector<ChangeListener>();
        }
        if (this.changeListeners.indexOf(changeListener) < 0) {
            this.changeListeners.add(changeListener);
        }
    }
}

