/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.frameofreference;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.frameofreference.IFrameOfReference;
import com.agfa.pacs.impaxee.frameofreference.IWorldToWorldTransform;
import com.agfa.pacs.impaxee.frameofreference.IWorldToWorldTransformListener;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.overlay.Localizer;
import com.tiani.jvision.overlay.localizer.LocalizerManager;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplayData;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

class FrameOfReference
implements IFrameOfReference {
    private static final ALogger LOGGER = ALogger.getLogger(FrameOfReference.class);
    private static final Object DUMMY = new Object();
    private static final PAction LOCALIZER_MR_DISPLAY = PActionRegistry.getAction("LOCALIZER_CALCULATION");
    private final String frameOfReference;
    private final String patientKey;
    private ConcurrentHashMap<String, ImgView2> mrViews = new ConcurrentHashMap(256, 0.75f, 4);
    private ConcurrentHashMap<String, Object> mrLocalizer = new ConcurrentHashMap(256, 0.75f, 4);
    private final Map<String, IWorldToWorldTransform> worldToWorldTransforms = new ConcurrentHashMap<String, IWorldToWorldTransform>(4, 0.75f, 4);
    private final Map<String, List<IWorldToWorldTransformListener>> listeners = new ConcurrentHashMap<String, List<IWorldToWorldTransformListener>>(4, 0.75f, 4);

    FrameOfReference(String string, String string2) {
        this.frameOfReference = string;
        this.patientKey = string2;
    }

    @Override
    public String getFrameOfReferenceUID() {
        return this.frameOfReference;
    }

    @Override
    public void clearDisplay(VisDisplayData visDisplayData) {
        for (VisData visData : visDisplayData.getVis()) {
            if (visData.getImageInformation() == null) continue;
            String string = visData.getImageInformation().getKey();
            this.mrViews.remove(string);
        }
        LocalizerManager.clearDisplay(visDisplayData.getVisDisplay());
    }

    @Override
    public void clear() {
        this.mrLocalizer.clear();
        this.mrViews.clear();
    }

    @Override
    public boolean isActiveLocalizer(String string) {
        return this.mrLocalizer.containsKey(string);
    }

    @Override
    public void registerMRView(ImgView2 imgView2, String string) {
        this.mrViews.put(string, imgView2);
    }

    @Override
    public void searchMRLocalizer(IImageInformation iImageInformation) {
        Sequence sequence = iImageInformation.getDataset().getSequence(528704);
        if (sequence != null) {
            int n = 0;
            while (n < sequence.size()) {
                Attributes attributes = (Attributes)sequence.get(n);
                String string = attributes.getString(528725);
                if (attributes.containsValue(528736)) {
                    String string2;
                    StringBuilder stringBuilder;
                    int n2 = attributes.getInt(528736, 0) - 1;
                    if (n2 == 0) {
                        stringBuilder = new StringBuilder(string).append('_');
                        stringBuilder.append(0);
                        string2 = stringBuilder.toString();
                        if (!this.mrLocalizer.containsKey(string2)) {
                            this.checkLocalizer(string2);
                        }
                    }
                    stringBuilder = new StringBuilder(string).append('_');
                    stringBuilder.append(n2);
                    string2 = stringBuilder.toString();
                    if (!this.mrLocalizer.containsKey(string2)) {
                        this.checkLocalizer(string2);
                    }
                } else if (!this.mrLocalizer.containsKey(string)) {
                    this.checkLocalizer(string);
                }
                ++n;
            }
        }
    }

    private void checkLocalizer(String string) {
        ImgView2 imgView2 = this.mrViews.get(string);
        if (imgView2 != null) {
            try {
                if (!imgView2.isLocalizerEnabled()) {
                    for (VisData visData : imgView2.getDisplay().getVis()) {
                        this.mrLocalizer.put(visData.getImageInformation().getKey(), DUMMY);
                        if (!LOCALIZER_MR_DISPLAY.isSelected()) continue;
                        ((ImgView2)visData.getView()).setLocalizer(Localizer.LocalizerState.ForceOn);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error on localizer", (Throwable)exception);
            }
        }
    }

    @Override
    public String getPatientKey() {
        return this.patientKey;
    }

    void addWorldToWorldTransform(IWorldToWorldTransform iWorldToWorldTransform) {
        if (this.frameOfReference.equals(iWorldToWorldTransform.getSourceFrameOfReferenceUID())) {
            this.worldToWorldTransforms.put(iWorldToWorldTransform.getDestinationFrameOfReferenceUID(), iWorldToWorldTransform);
            this.notifyListeners(iWorldToWorldTransform, IWorldToWorldTransformListener::worldToWorldTransformAdded);
        } else {
            LOGGER.warn("Frame of reference UID mismatch (expected: '" + this.frameOfReference + "'; was: '" + iWorldToWorldTransform.getSourceFrameOfReferenceUID() + "').");
        }
    }

    boolean removeWorldToWorldTransform(IWorldToWorldTransform iWorldToWorldTransform) {
        IWorldToWorldTransform iWorldToWorldTransform2 = this.worldToWorldTransforms.remove(iWorldToWorldTransform.getDestinationFrameOfReferenceUID());
        if (iWorldToWorldTransform2 != null) {
            if (iWorldToWorldTransform.equals(iWorldToWorldTransform2)) {
                this.notifyListeners(iWorldToWorldTransform2, IWorldToWorldTransformListener::worldToWorldTransformRemoved);
            } else {
                LOGGER.warn("World-to-world transform mismatch (expected: '" + iWorldToWorldTransform2 + "'; was: '" + iWorldToWorldTransform + "').");
                this.addWorldToWorldTransform(iWorldToWorldTransform2);
                iWorldToWorldTransform2 = null;
            }
        }
        return iWorldToWorldTransform2 != null;
    }

    private void notifyListeners(IWorldToWorldTransform iWorldToWorldTransform, BiConsumer<IWorldToWorldTransformListener, IWorldToWorldTransform> biConsumer) {
        for (IWorldToWorldTransformListener iWorldToWorldTransformListener : this.listeners.getOrDefault(iWorldToWorldTransform.getDestinationFrameOfReferenceUID(), Collections.emptyList())) {
            biConsumer.accept(iWorldToWorldTransformListener, iWorldToWorldTransform);
        }
    }

    @Override
    public IWorldToWorldTransform getWorldToWorldTransform(String string) {
        if (string == null) {
            return null;
        }
        return this.worldToWorldTransforms.get(string);
    }

    @Override
    public void addWorldToWorldTransformListener(String string2, IWorldToWorldTransformListener iWorldToWorldTransformListener) {
        if (string2 != null) {
            this.listeners.computeIfAbsent(string2, string -> new CopyOnWriteArrayList()).add(iWorldToWorldTransformListener);
        }
    }

    @Override
    public void removeWorldToWorldTransformListener(String string, IWorldToWorldTransformListener iWorldToWorldTransformListener) {
        List<IWorldToWorldTransformListener> list = this.listeners.get(string);
        if (list != null) {
            list.remove(iWorldToWorldTransformListener);
        }
    }

    @Override
    public Iterable<String> getFrameOfReferenceUIDsWithWorldToWorldTransform() {
        return this.worldToWorldTransforms.keySet();
    }
}

