/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.RawDataContainerTokenCreator;
import com.tiani.base.data.RawDataContainerTokenData;
import com.tiani.base.data.TokenData;
import com.tiani.base.data.TokenListener;
import com.tiani.base.data.TokenOwner;
import com.tiani.jvision.main.DisplaySetEvaluable;
import com.tiani.jvision.overlay.demographics.Mapping;
import com.tiani.jvision.patinfo.DisplaySetLabel;
import com.tiani.jvision.patinfo.SeqLabelMapping;
import com.tiani.util.expressions.IEvaluationContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DisplaySetLabelUtils {
    private static final ALogger LOGGER = ALogger.getLogger(DisplaySetLabelUtils.class);

    private DisplaySetLabelUtils() {
    }

    public static String getLabel(IDisplaySet iDisplaySet) {
        return DisplaySetLabelUtils.getLabel(new DisplaySetEvaluable(iDisplaySet));
    }

    public static String getLabel(IEvaluationContext iEvaluationContext) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        DisplaySetLabelUtils.appendLabel(stringBuilder, iEvaluationContext, "<br>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public static String getLabel(IEvaluationContext iEvaluationContext, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        DisplaySetLabelUtils.appendLabel(stringBuilder, iEvaluationContext, string);
        return stringBuilder.toString();
    }

    private static void appendLabel(StringBuilder stringBuilder, IEvaluationContext iEvaluationContext, String string) {
        SeqLabelMapping seqLabelMapping = new SeqLabelMapping(iEvaluationContext);
        seqLabelMapping.updateContent(true, true);
        boolean bl = true;
        for (String string2 : seqLabelMapping.getMappingRowsAsStrings()) {
            if (!StringUtils.isNotEmpty((CharSequence)string2)) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2);
        }
    }

    public static Color getMappingColor(IEvaluationContext iEvaluationContext) {
        Color color = Mapping.getMappingColor(iEvaluationContext);
        if (color == null) {
            color = DisplaySetLabelUtils.getDefaultMappingColor();
        }
        return color;
    }

    static Color getDefaultMappingColor() {
        return new Color((int)Config.impaxee.jvision.MAPPING.MappingColor.get());
    }

    public static JComponent getIcon(IDisplaySet iDisplaySet, DisplaySetIconFlag ... displaySetIconFlagArray) {
        return DisplaySetLabelUtils.getIcon(iDisplaySet, DisplaySetLabel.tokenSize, null, displaySetIconFlagArray);
    }

    public static JComponent getIcon(IDisplaySet iDisplaySet, int n, Supplier<String> supplier, DisplaySetIconFlag ... displaySetIconFlagArray) {
        IFrameObjectData[] iFrameObjectDataArray = iDisplaySet.getObjects();
        IFrameObjectData iFrameObjectData = Config.impaxee.jvision.SEQLABEL.UseFirstImagesForTokens.get() ? iFrameObjectDataArray[0] : iFrameObjectDataArray[iFrameObjectDataArray.length / 2];
        return new ImagePanel(iFrameObjectData, iDisplaySet.getTotalFrameCount(), iDisplaySet.isDisplayedInImageArea(), Mapping.getMappingColor(new DisplaySetEvaluable(iDisplaySet)), n, supplier, displaySetIconFlagArray);
    }

    public static JComponent getIcon(TokenOwner tokenOwner, Integer n, DisplaySetIconFlag ... displaySetIconFlagArray) {
        return new ImagePanel(tokenOwner, n, false, null, DisplaySetLabel.tokenSize, null, displaySetIconFlagArray);
    }

    public static enum DisplaySetIconFlag {
        LAST_MODIFIED,
        FRAME_COUNT_SHOWN;

    }

    private static class ImagePanel
    extends JPanel
    implements TokenListener {
        BufferedImage image;
        private final boolean isLastModified;
        private final boolean isDisplayedInImageArea;
        private final Integer frameCount;
        private static final String FOUR_DIGITS = "0000";
        private static final int PADDING = GUI.getScaledDiagnosticInt((int)4);
        private final Color foregroundColor;
        private int tokenSize;
        private final Supplier<String> description;

        public ImagePanel(TokenOwner tokenOwner, Integer n, boolean bl, Color color, int n2, Supplier<String> supplier, DisplaySetIconFlag ... displaySetIconFlagArray) {
            this.isLastModified = ArrayUtils.contains((Object[])displaySetIconFlagArray, (Object)((Object)DisplaySetIconFlag.LAST_MODIFIED));
            this.frameCount = ArrayUtils.contains((Object[])displaySetIconFlagArray, (Object)((Object)DisplaySetIconFlag.FRAME_COUNT_SHOWN)) ? n : null;
            this.isDisplayedInImageArea = bl;
            this.foregroundColor = color == null ? DisplaySetLabelUtils.getDefaultMappingColor() : color;
            this.tokenSize = n2;
            this.description = supplier;
            TokenData tokenData = tokenOwner.getTokenData();
            this.createImage(tokenData);
            if (!tokenData.isFinalToken() && tokenOwner instanceof IFrameObjectData) {
                ((IFrameObjectData)tokenOwner).setRawDataContainerToken();
                tokenData = tokenOwner.getTokenData();
                if (tokenData instanceof RawDataContainerTokenData) {
                    RawDataContainerTokenCreator.getInstance().addTokenData((RawDataContainerTokenData)tokenData);
                }
            }
            this.paintToken(tokenData, this);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            String string;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawImage((Image)this.image, 0, 0, this);
            if (this.isLastModified) {
                DisplaySetLabel.paintLastModBorder(graphics2D, new Rectangle(this.image.getWidth(), this.image.getHeight()), 0);
            }
            Color color = graphics2D.getColor();
            Font font = graphics2D.getFont();
            graphics2D.setFont(font.deriveFont((float)GUI.getScaledDiagnosticInt((int)12)));
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(FOUR_DIGITS, graphics2D);
            int n = (int)rectangle2D.getHeight() + PADDING;
            int n2 = (int)rectangle2D.getWidth() + PADDING * 2;
            if (this.frameCount != null && this.frameCount > 0) {
                string = this.frameCount.toString();
                Rectangle2D rectangle2D2 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
                int n3 = (int)rectangle2D2.getWidth();
                int n4 = (int)rectangle2D2.getHeight();
                int n5 = n2 - n3;
                if (n5 < 2) {
                    n5 = 4;
                }
                if (n5 % 2 != 0) {
                    ++n5;
                }
                graphics2D.setColor(new Color(0, 0, 0, 120));
                graphics2D.fillRect(2, 2, n2, n);
                graphics2D.setColor(this.foregroundColor);
                graphics2D.drawRect(2, 2, n2, n);
                if (this.isDisplayedInImageArea) {
                    graphics2D.drawRect(4, 4, n2 - 4, n - 4);
                }
                int n6 = n5 / 2;
                graphics2D.drawString(string, 2 + n6, 2 + n4 + PADDING - graphics2D.getFontMetrics().getDescent() - GUI.getScaledDiagnosticInt((int)1));
            }
            if (this.description != null && (string = this.description.get()) != null) {
                rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
                n = (int)rectangle2D.getHeight();
                n2 = (int)rectangle2D.getWidth() + PADDING;
                graphics2D.setColor(new Color(0, 0, 0, 150));
                int n7 = this.image.getHeight() - 3;
                graphics2D.fillRect(0, n7 - n + PADDING, n2, n7);
                graphics2D.setColor(this.foregroundColor);
                graphics2D.drawString(string, 2, n7);
            }
            graphics2D.setFont(font);
            graphics2D.setColor(color);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }

        @Override
        public void tokenChanged(TokenData tokenData) {
            this.createImage(tokenData);
            this.repaint();
        }

        private void createImage(TokenData tokenData) {
            this.image = new BufferedImage(this.tokenSize, this.tokenSize, 1);
            this.paintToken(tokenData, null);
        }

        private void paintToken(TokenData tokenData, TokenListener tokenListener) {
            Graphics2D graphics2D = this.image.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            try {
                tokenData.paintToken(graphics2D, 0, 0, this.image.getWidth(), this.image.getHeight(), tokenListener);
            }
            catch (Exception exception) {
                LOGGER.error("Paiting display set icon failed", (Throwable)exception);
            }
            graphics2D.dispose();
        }

        @Override
        public JToolTip createToolTip() {
            JToolTip jToolTip = super.createToolTip();
            jToolTip.setFont(jToolTip.getFont().deriveFont((float)(GUI.getScaleDiagnosticFactor() * (double)jToolTip.getFont().getSize())));
            return jToolTip;
        }
    }
}

