/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFormattedTextField;

public class JDoubleField
extends JFormattedTextField
implements KeyListener {
    private final boolean isSigned;
    private final char decimalSeparator;
    private final Collection<CommitEditListener> listeners;

    public JDoubleField(Double d) {
        this(d, 0);
    }

    public JDoubleField(Double d, int n) {
        this(d, true, n);
    }

    public JDoubleField(Double d, boolean bl, int n) {
        this(JDoubleField.createDecimalFormat(), d, bl, n);
    }

    public JDoubleField(DecimalFormat decimalFormat, Double d, boolean bl, int n) {
        super(decimalFormat);
        this.setValue(d);
        this.setColumns(n);
        this.setHorizontalAlignment(11);
        this.addKeyListener(this);
        this.isSigned = bl;
        this.decimalSeparator = decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
        this.listeners = new ArrayList<CommitEditListener>(1);
    }

    private static DecimalFormat createDecimalFormat() {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(2);
        return decimalFormat;
    }

    public void addCommitEditListener(CommitEditListener commitEditListener) {
        this.listeners.add(commitEditListener);
    }

    @Override
    public Double getValue() {
        Object object = super.getValue();
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return null;
    }

    @Override
    public final void setValue(Object object) {
        throw new UnsupportedOperationException("Only double values are allowed.");
    }

    public final void setValue(Number number) {
        super.setValue(number);
    }

    @Override
    public void commitEdit() throws ParseException {
        super.commitEdit();
        for (CommitEditListener commitEditListener : this.listeners) {
            commitEditListener.notifyCommitEdit();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!this.isAllowedChar(c) || this.isDecimalSeparator(c) && this.containsDecimalSeparator() || this.isCaretAtStart() && this.containsSign() || !this.isCaretAtStart() && JDoubleField.isSign(c)) {
            keyEvent.consume();
        }
    }

    private boolean isAllowedChar(char c) {
        return Character.isDigit(c) || c == '\b' || c == '\u007f' || this.isSigned && JDoubleField.isSign(c) || this.isDecimalSeparator(c);
    }

    private static boolean isSign(char c) {
        return c == '-';
    }

    private boolean isDecimalSeparator(char c) {
        return c == this.decimalSeparator;
    }

    private boolean isCaretAtStart() {
        return this.getCaretPosition() == 0;
    }

    private boolean containsDecimalSeparator() {
        return this.containsChar(this.decimalSeparator);
    }

    private boolean containsSign() {
        return this.containsChar('-');
    }

    private boolean containsChar(char c) {
        return this.getText().indexOf(c) != -1;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public static interface CommitEditListener {
        public void notifyCommitEdit();
    }
}

