/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui.chart;

import com.agfa.pacs.impaxee.gui.chart.IAxisData;

abstract class AbstractAxisData
implements IAxisData {
    private String unit;
    private double minDataValue = Double.MAX_VALUE;
    private double maxDataValue = Double.MIN_VALUE;
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;
    private double slope;
    private int intercept;

    AbstractAxisData() {
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public void setUnit(String string) {
        this.unit = string;
    }

    @Override
    public double getMinimum() {
        return this.min;
    }

    @Override
    public double getMaximum() {
        return this.max;
    }

    @Override
    public void setMinimum(double d) {
        if (d <= this.minDataValue) {
            this.min = d;
        }
    }

    @Override
    public void setMaximum(double d) {
        if (d >= this.maxDataValue) {
            this.max = d;
        }
    }

    @Override
    public void registerDataValue(double d) {
        if (d < this.minDataValue) {
            this.minDataValue = d;
            if (this.min > this.minDataValue) {
                this.min = this.minDataValue;
            }
        }
        if (d > this.maxDataValue) {
            this.maxDataValue = d;
            if (this.max < this.maxDataValue) {
                this.max = this.maxDataValue;
            }
        }
    }

    @Override
    public void setPixelRange(int n, int n2) {
        this.slope = (double)(n2 - n) / (this.max - this.min);
        this.intercept = n;
    }

    @Override
    public int convertToPixelSpace(double d) {
        return (int)((double)this.intercept + this.slope * (d - this.min) + 0.5);
    }

    static double roundToOneDecimal(double d) {
        return (double)((int)(d * 10.0 + 0.5)) / 10.0;
    }
}

