/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui.chart;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.chart.AutoLabelAxisData;
import com.agfa.pacs.impaxee.gui.chart.ChartLineData;
import com.agfa.pacs.impaxee.gui.chart.IAxisData;
import com.agfa.pacs.impaxee.gui.chart.IDataPoint;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class Chart {
    private final List<ChartLineData> data = new ArrayList<ChartLineData>(4);
    private final IAxisData xAxis;
    private final IAxisData yAxis;
    private boolean isInconsistent;
    private double scalingFactor = 1.0;
    private IDataPoint minimum;
    private IDataPoint maximum;

    public Chart(int n, int n2) {
        this((IAxisData)new AutoLabelAxisData(n), n2);
    }

    public Chart(IAxisData iAxisData, int n) {
        this(iAxisData, new AutoLabelAxisData(n));
    }

    public Chart(IAxisData iAxisData, IAxisData iAxisData2) {
        this.xAxis = iAxisData;
        this.yAxis = iAxisData2;
    }

    public void setInconsistent() {
        this.isInconsistent = true;
    }

    public void setScalingFactor(double d) {
        this.scalingFactor = d;
    }

    public IAxisData getXAxis() {
        return this.xAxis;
    }

    public IAxisData getYAxis() {
        return this.yAxis;
    }

    public void addChartLine(Color color, boolean bl, IDataPoint ... iDataPointArray) {
        if (iDataPointArray == null || iDataPointArray.length == 0) {
            throw new IllegalArgumentException("No data values given.");
        }
        if (iDataPointArray.length == 1) {
            throw new IllegalArgumentException("Only a single data point given.");
        }
        this.data.add(new ChartLineData(color, bl, iDataPointArray));
        IDataPoint[] iDataPointArray2 = iDataPointArray;
        int n = iDataPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataPoint iDataPoint = iDataPointArray2[n2];
            this.xAxis.registerDataValue(iDataPoint.getX());
            this.yAxis.registerDataValue(iDataPoint.getY());
            ++n2;
        }
    }

    public void setExtremumValues(IDataPoint iDataPoint, IDataPoint iDataPoint2) {
        this.minimum = iDataPoint;
        this.maximum = iDataPoint2;
    }

    public boolean isChartAvailable() {
        return !this.data.isEmpty() && !this.isInconsistent;
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        Font font = graphics.getFont();
        int n5 = this.scaleInt(font.getSize());
        graphics.setFont(font.deriveFont((float)n5));
        if (!this.isChartAvailable()) {
            String string = this.isInconsistent ? Messages.getString("Chart.InconsistentData") : Messages.getString("Chart.NoData");
            int n6 = graphics.getFontMetrics().stringWidth(string);
            graphics.drawString(string, (n + n3 - n6) / 2, (n2 + n4) / 2 + n5 * 3 / 2);
            return;
        }
        String string = this.xAxis.getUnit();
        String string2 = this.yAxis.getUnit();
        int n7 = n + this.scaleInt(70);
        int n8 = n4 - this.scaleInt(40);
        int n9 = n3 - this.scaleInt(60);
        int n10 = n2 + this.scaleInt(20);
        if (string2 != null) {
            n10 += this.scaleInt(10);
        }
        int n11 = n9 - n7;
        int n12 = n10 - n8;
        graphics.drawLine(n7, n8, n9, n8);
        graphics.drawLine(n7, n8, n7, n10);
        this.xAxis.setPixelRange(n7, n9);
        this.yAxis.setPixelRange(n8, n10);
        int n13 = this.scaleInt(5);
        int n14 = this.xAxis.getTickMarkCount();
        double d = (double)n11 / ((double)n14 - 1.0);
        int n15 = this.scaleInt(8);
        int n16 = 0;
        while (n16 < n14) {
            int n17 = (int)((double)n7 + (double)n16 * d);
            graphics.drawLine(n17, n8 - n13, n17, n8 + n13);
            graphics.drawString(this.xAxis.getTickMarkLabel(n16), n17 - n15, n8 + 2 * n5);
            ++n16;
        }
        if (string != null) {
            n16 = graphics.getFontMetrics().stringWidth(string);
            graphics.drawString(string, n3 - n16 - n13, n8 + n13);
        }
        n16 = this.yAxis.getTickMarkCount();
        double d2 = (double)n12 / ((double)n16 - 1.0);
        int n18 = this.scaleInt(50);
        int n19 = this.scaleInt(10);
        int n20 = 0;
        while (n20 < n16) {
            int n21 = (int)((double)n8 + (double)n20 * d2);
            graphics.drawLine(n7 - n13, n21, n7 + n13, n21);
            String string3 = this.yAxis.getTickMarkLabel(n20);
            int n22 = Math.min(graphics.getFontMetrics().stringWidth(string3), n18) + n19;
            graphics.drawString(string3, n7 - n22, n21 + n5 / 2);
            ++n20;
        }
        if (string2 != null) {
            n20 = graphics.getFontMetrics().stringWidth(string2);
            graphics.drawString(string2, n7 - n20 / 2, n2 + n5);
        }
        n20 = this.data.size() - 1;
        while (n20 >= 0) {
            ChartLineData chartLineData = this.data.get(n20);
            boolean bl = chartLineData.areDataPointsDrawn();
            Color color = graphics.getColor();
            graphics.setColor(chartLineData.getColor());
            List<IDataPoint> list = chartLineData.getDataPoints();
            int n23 = this.xAxis.convertToPixelSpace(list.get(0).getX());
            int n24 = this.yAxis.convertToPixelSpace(list.get(0).getY());
            if (bl) {
                this.drawDataPoint(graphics, n23, n24);
            }
            int n25 = list.size();
            int n26 = 1;
            while (n26 < n25) {
                IDataPoint iDataPoint = list.get(n26);
                int n27 = this.xAxis.convertToPixelSpace(iDataPoint.getX());
                int n28 = this.yAxis.convertToPixelSpace(iDataPoint.getY());
                if (bl) {
                    this.drawDataPoint(graphics, n27, n28);
                }
                graphics.drawLine(n23, n24, n27, n28);
                n23 = n27;
                n24 = n28;
                ++n26;
            }
            graphics.setColor(color);
            --n20;
        }
        if (this.minimum != null && this.maximum != null) {
            this.drawExtremum(graphics, this.minimum, true);
            this.drawExtremum(graphics, this.maximum, false);
        }
        graphics.setFont(font);
    }

    private void drawExtremum(Graphics graphics, IDataPoint iDataPoint, boolean bl) {
        DecimalFormat decimalFormat = new DecimalFormat("#0.0");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf(decimalFormat.format(iDataPoint.getY())));
        if (this.yAxis.getUnit() != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.yAxis.getUnit());
        }
        String string = stringBuilder.toString();
        Font font = graphics.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        FontRenderContext fontRenderContext = fontMetrics.getFontRenderContext();
        float f = (float)font.getStringBounds(string, fontRenderContext).getHeight();
        int n = Math.round(f);
        int n2 = graphics.getFontMetrics().stringWidth(string);
        if (bl) {
            graphics.drawString(string, this.xAxis.convertToPixelSpace(this.xAxis.getMaximum()) - n2, this.yAxis.convertToPixelSpace(iDataPoint.getY()) + n);
        } else {
            graphics.drawString(string, this.xAxis.convertToPixelSpace(this.xAxis.getMaximum()) - n2, this.yAxis.convertToPixelSpace(iDataPoint.getY()) - 6);
        }
    }

    private void drawDataPoint(Graphics graphics, int n, int n2) {
        int n3 = this.scaleInt(7);
        int n4 = n3 / 2;
        int n5 = n - n4;
        int n6 = n2 - n4;
        if (n5 < 0 || n6 < 0) {
            graphics.fillOval(n, n2, n3, n3);
        } else {
            graphics.fillOval(n5, n6, n3, n3);
        }
    }

    private int scaleInt(int n) {
        return (int)((double)n * this.scalingFactor + 0.5);
    }
}

