/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui.mvc;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.impaxee.gui.mvc.IMutableSelectionModel;
import com.agfa.pacs.impaxee.gui.mvc.INavigatableSelectionController;
import com.agfa.pacs.impaxee.gui.mvc.IPopupMenuAction;
import com.agfa.pacs.impaxee.gui.mvc.ISelectionController;
import com.agfa.pacs.impaxee.gui.mvc.ISelectionView;
import com.agfa.pacs.impaxee.gui.mvc.SelectionModel;
import com.agfa.pacs.impaxee.gui.mvc.SelectionPopupMenu;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.swing.JList;

public abstract class AbstractSelectionController<E>
extends MouseAdapter
implements ISelectionController<E>,
INavigatableSelectionController {
    private final Collection<ISelectionView<E>> views = new ArrayList<ISelectionView<E>>();
    @Nonnull
    private IMutableSelectionModel<E> listModel = new SelectionModel();

    protected AbstractSelectionController() {
    }

    protected Iterable<ISelectionView<E>> getViews() {
        return this.views;
    }

    @Override
    public void addView(ISelectionView<E> iSelectionView) {
        this.views.add(iSelectionView);
        iSelectionView.setViewModel(this.listModel);
    }

    @Override
    public void removeView(ISelectionView<E> iSelectionView) {
        this.views.remove(iSelectionView);
    }

    public void removeAllViews() {
        this.views.clear();
    }

    @Override
    public void installPopupMenu(Component component) {
        if (this.isPopupMenuEnabled()) {
            component.addMouseListener(this);
            if (component instanceof Container) {
                Component[] componentArray;
                Component[] componentArray2 = componentArray = ((Container)component).getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component component2 = componentArray2[n2];
                    component2.addMouseListener(this);
                    ++n2;
                }
            }
        }
    }

    protected abstract boolean isPopupMenuEnabled();

    protected int getElementCount() {
        return this.listModel.getSize();
    }

    protected E getElementAt(int n) {
        return this.listModel.getElementAt(n);
    }

    protected void insertElementAt(int n, E e) {
        this.listModel.insertElementAt(e, n);
        this.selectElementAt(n);
    }

    protected void removeElementAt(int n) {
        this.listModel.removeElementAt(n);
        this.selectElementAt(n);
    }

    protected void selectElementAt(int n) {
        this.selectElementAt(n, false);
    }

    protected void selectElementAt(int n, boolean bl) {
        if (!bl && this.getSelectedIndex() == n) {
            return;
        }
        this.listModel.setSelectedIndex(n);
        for (ISelectionView<E> iSelectionView : this.views) {
            iSelectionView.selectionChanged(n);
        }
    }

    public int getSelectedIndex() {
        return this.listModel.getSelectedIndex();
    }

    @Override
    public boolean isRelativeChangePossible(int n) {
        int n2 = this.getSelectedIndex() + n;
        return n2 >= 0 && n2 < this.listModel.getSize();
    }

    @Override
    public boolean setSelectedItemRelative(int n) {
        int n2 = this.getSelectedIndex();
        if (n == 0 || n2 < 0) {
            return false;
        }
        int n3 = n2 + n;
        if (n3 >= 0 && n3 < this.listModel.getSize()) {
            this.selectElementAt(n3);
            return true;
        }
        return false;
    }

    public E getSelectedElement() {
        return this.getElementAt(this.getSelectedIndex());
    }

    public void refresh() {
        this.listModel = new SelectionModel();
        this.initDataModel(this.listModel);
        EventUtil.invoke(() -> {
            for (ISelectionView<E> iSelectionView : this.views) {
                iSelectionView.setViewModel(this.listModel);
            }
            this.afterRefresh();
        });
    }

    protected abstract void initDataModel(IMutableSelectionModel<E> var1);

    protected abstract void afterRefresh();

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    private void checkPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Object object;
            SelectionPopupMenu selectionPopupMenu = new SelectionPopupMenu();
            if (mouseEvent.getComponent() instanceof JList) {
                object = (JList)mouseEvent.getComponent();
                ((JList)object).setSelectedIndex(((JList)object).locationToIndex(mouseEvent.getPoint()));
            }
            Object object2 = object = this.getPopupMenuActions();
            int n = ((IPopupMenuAction[])object2).length;
            int n2 = 0;
            while (n2 < n) {
                Object object3 = object2[n2];
                selectionPopupMenu.addPopupMenuAction((IPopupMenuAction)object3);
                ++n2;
            }
            if (((Object)object).length > 0) {
                selectionPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    protected abstract IPopupMenuAction[] getPopupMenuActions();
}

