/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui.mvc;

import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.gui.mvc.ISelectionComponent;
import com.agfa.pacs.impaxee.gui.mvc.ISelectionController;
import com.agfa.pacs.impaxee.gui.mvc.ISelectionModel;
import com.agfa.pacs.impaxee.gui.mvc.ISelectionView;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class SComboBox<E>
implements ISelectionComponent<E> {
    private final JComboBox<E> comboBox;
    private ActionListener selectionListener;

    public SComboBox(JComboBox<E> jComboBox, Dimension dimension) {
        this.comboBox = jComboBox;
        this.comboBox.setPreferredSize(dimension);
    }

    public static <T> SComboBox<T> create(Class<T> clazz) {
        return SComboBox.create(clazz, null);
    }

    public static <T> SComboBox<T> create(Class<T> clazz, ListCellRenderer<? super T> listCellRenderer) {
        MultiMonitorComboBox<T> multiMonitorComboBox = ComponentFactory.instance.createMultiMonitorComboBox(clazz);
        if (listCellRenderer != null) {
            multiMonitorComboBox.setRenderer(listCellRenderer);
        }
        return new SComboBox<T>(multiMonitorComboBox, null);
    }

    @Override
    public void addSelectionListener(final ISelectionController<E> iSelectionController, final ISelectionView<E> iSelectionView) {
        if (this.selectionListener != null) {
            this.comboBox.removeActionListener(this.selectionListener);
        }
        this.selectionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = SComboBox.this.getSelectedIndex();
                if (n >= 0) {
                    iSelectionController.selectionActivated(iSelectionView.getUIComponent(), n);
                } else {
                    iSelectionController.selectionDeactivated();
                }
            }
        };
        this.comboBox.addActionListener(this.selectionListener);
    }

    @Override
    public Component getContainer() {
        return this.getComponent();
    }

    @Override
    public JComboBox<E> getComponent() {
        return this.comboBox;
    }

    @Override
    public ListModel<E> getModel() {
        return this.comboBox.getModel();
    }

    @Override
    public void setModel(@Nonnull ISelectionModel<E> iSelectionModel) {
        this.comboBox.removeActionListener(this.selectionListener);
        this.comboBox.setModel(iSelectionModel);
        this.setSelectedIndex(iSelectionModel.getSelectedIndex());
        this.comboBox.addActionListener(this.selectionListener);
    }

    private int getSelectedIndex() {
        return this.comboBox.getSelectedIndex();
    }

    @Override
    public void setSelectedIndex(int n) {
        if (n >= 0) {
            this.comboBox.setSelectedIndex(n);
        }
    }
}

