/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui.mvc;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.gui.mvc.ISelectionComponent;
import com.agfa.pacs.impaxee.gui.mvc.ISelectionController;
import com.agfa.pacs.impaxee.gui.mvc.ISelectionModel;
import com.agfa.pacs.impaxee.gui.mvc.ISelectionView;
import java.awt.Component;
import java.awt.Dimension;
import javax.annotation.Nonnull;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SList<E>
implements ISelectionComponent<E> {
    private static final int ITEMS_PER_BLOCK = 5;
    private final JScrollPane pane;
    private final JList<E> list;
    private final Dimension preferredSize;
    private ListSelectionListener listSelectionListener;
    private Boolean fitHorizontal;

    public SList(JList<E> jList, Dimension dimension, Boolean bl) {
        this.fitHorizontal = bl;
        this.list = jList;
        this.pane = ComponentFactory.instance.createScrollPane(this.list, 20, 31, true, false);
        this.preferredSize = dimension;
        this.calculatePreferredSize(null);
        this.list.setOpaque(false);
    }

    @Override
    public void addSelectionListener(final ISelectionController<E> iSelectionController, final ISelectionView<E> iSelectionView) {
        if (this.listSelectionListener != null) {
            this.list.removeListSelectionListener(this.listSelectionListener);
        }
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = SList.this.getSelectedIndex();
                if (n >= 0) {
                    iSelectionController.selectionActivated(iSelectionView.getUIComponent(), n);
                } else {
                    iSelectionController.selectionDeactivated();
                }
            }
        };
        this.list.addListSelectionListener(this.listSelectionListener);
    }

    @Override
    public Component getContainer() {
        return this.pane;
    }

    @Override
    public JList<E> getComponent() {
        return this.list;
    }

    @Override
    public ListModel<E> getModel() {
        return this.list.getModel();
    }

    @Override
    public void setModel(@Nonnull ISelectionModel<E> iSelectionModel) {
        this.list.removeListSelectionListener(this.listSelectionListener);
        this.list.setModel(iSelectionModel);
        this.calculatePreferredSize(iSelectionModel);
        this.setSelectedIndex(iSelectionModel.getSelectedIndex());
        this.list.addListSelectionListener(this.listSelectionListener);
    }

    private void calculatePreferredSize(ISelectionModel<E> iSelectionModel) {
        Dimension dimension = this.preferredSize;
        if (dimension == null && iSelectionModel != null && iSelectionModel.getSize() > 0) {
            int n = 0;
            Component component = this.list.getCellRenderer().getListCellRendererComponent(this.list, iSelectionModel.getElementAt(n), n, false, false);
            dimension = component.getPreferredSize();
            this.pane.getVerticalScrollBar().setUnitIncrement(dimension.height);
            int n2 = dimension.width;
            if (this.fitHorizontal.booleanValue()) {
                n2 = Math.max(GUI.getScaledDiagnosticInt((int)250), n2);
                dimension = new Dimension(n2, this.getContainer().getParent().getHeight() - GUI.getScaledDiagnosticInt((int)40));
            } else {
                dimension = new Dimension(n2, 5 * dimension.height);
            }
            this.pane.getVerticalScrollBar().setBlockIncrement(dimension.height);
        }
        this.pane.setPreferredSize(dimension);
    }

    private int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    @Override
    public void setSelectedIndex(int n) {
        this.list.setSelectedIndex(n);
        this.list.ensureIndexIsVisible(n);
    }
}

