/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui.selection;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.DisplaySetLabelUtils;
import com.agfa.pacs.impaxee.gui.selection.AbstractSelectionData;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import java.util.Arrays;
import javax.swing.JComponent;

public class DisplaySetSelectionData
extends AbstractSelectionData<IDisplaySet> {
    public DisplaySetSelectionData(IDisplaySet iDisplaySet) {
        super(iDisplaySet);
    }

    @Override
    public Iterable<IDisplaySet> getAllData() {
        IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(((IDisplaySet)this.getLoadedData()).getOneObject().getDicomObject());
        ISplitAndSortRuntime iSplitAndSortRuntime = iPatientRepresentation.getDecompositionRuntime();
        return Arrays.asList(iSplitAndSortRuntime.getDisplaySets());
    }

    @Override
    public String getLoadedDataTitle() {
        return Messages.getString("DisplaySetSelectionData.LoadedData.Title");
    }

    @Override
    public String getAdditionalDataTitle() {
        return Messages.getString("DisplaySetSelectionData.AdditionalData.Title");
    }

    @Override
    public JComponent getIcon(IDisplaySet iDisplaySet) {
        DisplaySetLabelUtils.DisplaySetIconFlag[] displaySetIconFlagArray = this.isLastModified(iDisplaySet) ? new DisplaySetLabelUtils.DisplaySetIconFlag[]{DisplaySetLabelUtils.DisplaySetIconFlag.LAST_MODIFIED} : new DisplaySetLabelUtils.DisplaySetIconFlag[]{};
        return DisplaySetLabelUtils.getIcon(iDisplaySet, displaySetIconFlagArray);
    }

    @Override
    protected String getLabelPrefixImpl(IDisplaySet iDisplaySet) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html> [<b>");
        stringBuilder.append(iDisplaySet.getTotalFrameCount());
        stringBuilder.append("</b>] </html>");
        return stringBuilder.toString();
    }

    @Override
    public String getLabel(IDisplaySet iDisplaySet) {
        return DisplaySetLabelUtils.getLabel(iDisplaySet);
    }

    protected boolean isLastModified(IDisplaySet iDisplaySet) {
        return false;
    }
}

