/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui.selection;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.gui.selection.ISelectionDialogAction;
import com.agfa.pacs.impaxee.gui.selection.ISelectionDialogData;
import com.agfa.pacs.impaxee.gui.selection.ISelectionDialogListData;
import com.agfa.pacs.impaxee.gui.selection.ISelectionGroupFactory;
import com.agfa.pacs.impaxee.gui.selection.SelectionDialogList;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorButton;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SelectionDialogComponentFactory {
    private SelectionDialogComponentFactory() {
    }

    public static <T> JButton createConfirmationButton(final Window window, final SelectionDialogList<T> selectionDialogList, final ISelectionDialogAction<T> iSelectionDialogAction) {
        MultiMonitorButton multiMonitorButton = ComponentFactory.instance.createMultiMonitorButton(iSelectionDialogAction.getTitle(), iSelectionDialogAction.getToolTip());
        multiMonitorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (iSelectionDialogAction.confirmSelection(selectionDialogList.getSelectedData()) && window != null) {
                    window.dispose();
                }
            }
        });
        return multiMonitorButton;
    }

    public static <T> JPanel createLoadedDataPanel(ISelectionDialogData<T> iSelectionDialogData) {
        JComponent jComponent;
        JComponent jComponent2;
        if (!iSelectionDialogData.getLoadedDataSelectionState().isShownSeparately()) {
            return null;
        }
        double[][] dArrayArray = new double[][]{{-2.0, -2.0, -1.0}, new double[0]};
        TableLayout tableLayout = new TableLayout((double[][])dArrayArray);
        tableLayout.insertRow(0, -2.0);
        JPanel jPanel = ComponentFactory.instance.createPanel((LayoutManager)tableLayout);
        Object t = iSelectionDialogData.getLoadedData();
        jPanel.setBorder(ComponentFactory.instance.createTitledBorder(iSelectionDialogData.getLoadedDataTitle()));
        JComponent jComponent3 = iSelectionDialogData.getIcon(t);
        if (jComponent3 != null) {
            jPanel.add((Component)jComponent3, "0,0");
        }
        if ((jComponent2 = iSelectionDialogData.getLabelPrefix(t)) != null) {
            jComponent = ComponentFactory.instance.createPanel();
            jComponent.setBorder(BorderFactory.createEmptyBorder(GUI.getScaledDiagnosticInt((int)15), GUI.getScaledDiagnosticInt((int)15), 0, GUI.getScaledDiagnosticInt((int)15)));
            jComponent.add(jComponent2);
            jPanel.add((Component)jComponent, "1,0");
        }
        jComponent = ComponentFactory.instance.createMultiMonitorLabel(iSelectionDialogData.getLabel(t));
        jPanel.add((Component)jComponent, "2,0");
        return jPanel;
    }

    public static <T> JPanel createUnmodifiableAllDataPanel(ISelectionDialogListData<T> iSelectionDialogListData) {
        return SelectionDialogComponentFactory.createAllDataPanel(iSelectionDialogListData, new UnmodifiableSelectionGroup());
    }

    public static <T> SelectionDialogList<T> createSingleSelectionPanel(ISelectionDialogListData<T> iSelectionDialogListData) {
        return SelectionDialogComponentFactory.createAllDataPanel(iSelectionDialogListData, new UniqueSelectionGroup());
    }

    public static <T> SelectionDialogList<T> createMultiSelectionDataPanel(ISelectionDialogListData<T> iSelectionDialogListData) {
        return SelectionDialogComponentFactory.createAllDataPanel(iSelectionDialogListData, null);
    }

    public static <T> SelectionDialogList<T> createAllDataPanel(ISelectionDialogListData<T> iSelectionDialogListData, ISelectionGroupFactory<T> iSelectionGroupFactory) {
        return new SelectionDialogList<T>(iSelectionDialogListData, iSelectionGroupFactory);
    }

    private static class UniqueSelectionGroup<T>
    implements ISelectionGroupFactory<T> {
        private final ISelectionGroupFactory.SelectionButtonGroup commonGroup = new ISelectionGroupFactory.SelectionButtonGroup();

        UniqueSelectionGroup() {
        }

        @Override
        public ISelectionGroupFactory.SelectionType getType() {
            return ISelectionGroupFactory.SelectionType.SINGLE_SELECTION;
        }

        @Override
        public ISelectionGroupFactory.SelectionButtonGroup getGroup(T t) {
            return this.commonGroup;
        }
    }

    private static class UnmodifiableSelectionGroup<T>
    implements ISelectionGroupFactory<T> {
        private UnmodifiableSelectionGroup() {
        }

        @Override
        public ISelectionGroupFactory.SelectionType getType() {
            return ISelectionGroupFactory.SelectionType.NO_SELECTION;
        }

        @Override
        public ISelectionGroupFactory.SelectionButtonGroup getGroup(T t) {
            return null;
        }
    }
}

