/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.gui.selection;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.gui.selection.ISelectionDialogListData;
import com.agfa.pacs.impaxee.gui.selection.ISelectionGroupFactory;
import com.agfa.pacs.listtext.swingx.controls.JSeparator2;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorButton;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class SelectionDialogList<T>
extends JPanel {
    private static final int PREFIX_LABEL_GAP = GUI.getScaledDiagnosticInt((int)15);
    private static final int CHECKBOX_VERTICAL_BORDER = GUI.getScaledDiagnosticInt((int)10);
    private final ISelectionDialogListData<T> dataProvider;
    private final List<JToggleButton> selectors = new ArrayList<JToggleButton>();
    private final List<T> elements = new ArrayList<T>();

    SelectionDialogList(ISelectionDialogListData<T> iSelectionDialogListData, ISelectionGroupFactory<T> iSelectionGroupFactory) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.dataProvider = iSelectionDialogListData;
        this.installComponents(iSelectionGroupFactory);
    }

    public void addActionListener(ActionListener actionListener) {
        for (JToggleButton jToggleButton : this.selectors) {
            jToggleButton.addActionListener(actionListener);
        }
    }

    public int getDataCount() {
        return this.elements.size();
    }

    public T getData(int n) {
        return this.elements.get(n);
    }

    public Set<T> getAvailableData() {
        HashSet<T> hashSet = new HashSet<T>(this.elements);
        if (this.dataProvider.getLoadedDataSelectionState().isShownSeparately()) {
            hashSet.add(this.dataProvider.getLoadedData());
        }
        return hashSet;
    }

    public List<T> getSelectedData() {
        ArrayList<T> arrayList = new ArrayList<T>();
        if (this.dataProvider.getLoadedDataSelectionState().isShownSeparately() && this.dataProvider.getLoadedDataSelectionState().isSelected()) {
            arrayList.add(this.dataProvider.getLoadedData());
        }
        int n = this.selectors.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.selectors.get(n2).isSelected()) {
                arrayList.add(this.getData(n2));
            }
            ++n2;
        }
        return arrayList;
    }

    public int[] getSelectedIndices() {
        int n = this.selectors.size();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.selectors.get(n3).isSelected()) {
                nArray[n2] = n3;
                ++n2;
            }
            ++n3;
        }
        return Arrays.copyOf(nArray, n2);
    }

    public void setSelected(int n, boolean bl) {
        this.selectors.get(n).setSelected(bl);
    }

    public boolean isSelected(int n) {
        return this.selectors.get(n).isSelected();
    }

    private void installComponents(ISelectionGroupFactory<T> iSelectionGroupFactory) {
        JComponent jComponent;
        JComponent jComponent2;
        Object object2;
        double[][] dArrayArray = new double[][]{{-2.0, -2.0, -1.0}, new double[0]};
        TableLayout tableLayout = new TableLayout((double[][])dArrayArray);
        JPanel jPanel = ComponentFactory.instance.createPanel((LayoutManager)tableLayout);
        jPanel.setBorder(SwingUtilities2.createEmptyBorder((int)GUI.getScaledDiagnosticInt((int)5)));
        int n = 0;
        T t = this.dataProvider.getLoadedData();
        boolean bl = this.dataProvider.getLoadedDataSelectionState().isShownSeparately();
        for (Object object2 : this.dataProvider.getAllData()) {
            JComponent jComponent3;
            Object object3;
            if (bl && object2 == t) continue;
            if (n > 0) {
                tableLayout.insertRow(n, (double)PREFIX_LABEL_GAP);
                jPanel.add((Component)new JSeparator2(), "0," + n + ",2," + n);
                ++n;
            }
            tableLayout.insertRow(n, -2.0);
            jComponent2 = this.dataProvider.getIcon(object2);
            if (jComponent2 != null) {
                jPanel.add((Component)jComponent2, "0," + n);
            }
            if ((jComponent = this.dataProvider.getLabelPrefix(object2)) != null) {
                object3 = ComponentFactory.instance.createPanel();
                ((JComponent)object3).setBorder(BorderFactory.createEmptyBorder(PREFIX_LABEL_GAP, PREFIX_LABEL_GAP, 0, PREFIX_LABEL_GAP));
                ((Container)object3).add(jComponent);
                jPanel.add((Component)object3, "1," + n);
            }
            object3 = this.dataProvider.getLabel(object2);
            if (iSelectionGroupFactory != null && iSelectionGroupFactory.getType() == ISelectionGroupFactory.SelectionType.NO_SELECTION) {
                jComponent3 = ComponentFactory.instance.createLabel((String)object3);
            } else {
                JToggleButton jToggleButton;
                if (iSelectionGroupFactory == null) {
                    jToggleButton = ComponentFactory.instance.createMultiMonitorCheckbox((String)object3);
                } else {
                    ISelectionGroupFactory.SelectionButtonGroup selectionButtonGroup;
                    jToggleButton = iSelectionGroupFactory.getType() == ISelectionGroupFactory.SelectionType.SINGLE_SELECTION ? ComponentFactory.instance.createMultiMonitorRadioButton((String)object3, null) : ComponentFactory.instance.createMultiMonitorCheckbox((String)object3);
                    if ((object2 != t || this.dataProvider.getLoadedDataSelectionState().isEditable()) && (selectionButtonGroup = iSelectionGroupFactory.getGroup(object2)) != null) {
                        selectionButtonGroup.add(jToggleButton);
                    }
                }
                jToggleButton.setSelected(object2 == t && this.dataProvider.getLoadedDataSelectionState().isSelected());
                jToggleButton.setEnabled(object2 != t || this.dataProvider.getLoadedDataSelectionState().isEditable());
                this.selectors.add(jToggleButton);
                this.elements.add(object2);
                jComponent3 = jToggleButton;
            }
            jPanel.add((Component)jComponent3, "2," + n);
            ++n;
        }
        object2 = ComponentFactory.instance.createScrollPane(jPanel, 20, 31, null, null);
        if (iSelectionGroupFactory == null) {
            MultiMonitorButton multiMonitorButton = ComponentFactory.instance.createMultiMonitorButton(Messages.getString("SelectAll"));
            multiMonitorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (JToggleButton jToggleButton : SelectionDialogList.this.selectors) {
                        jToggleButton.setSelected(true);
                    }
                }
            });
            jComponent2 = ComponentFactory.instance.createMultiMonitorButton(Messages.getString("DeselectAll"));
            ((AbstractButton)jComponent2).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (JToggleButton jToggleButton : SelectionDialogList.this.selectors) {
                        jToggleButton.setSelected(false);
                    }
                }
            });
            jComponent = ComponentFactory.instance.createPanel(new BorderLayout());
            jComponent.setBorder(BorderFactory.createEmptyBorder(CHECKBOX_VERTICAL_BORDER, PREFIX_LABEL_GAP, CHECKBOX_VERTICAL_BORDER, PREFIX_LABEL_GAP));
            jComponent.add((Component)multiMonitorButton, "West");
            jComponent.add((Component)jComponent2, "East");
            this.add((Component)jComponent, "North");
        }
        this.add((Component)object2, "Center");
    }
}

