/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging;

import com.agfa.pacs.base.util.Dcm4cheUtils;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.tiani.base.data.IStudyData;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.dcm4che3.data.Attributes;

public abstract class AbstractStudyContainer
implements IStudyContainer {
    private static final AtomicLong counter = new AtomicLong(1000L);
    private static final long CONTEXT_VALIDITY = Product.isRunningAutoTests() ? 1000 : 5000;
    protected IStudyData baseStudy;
    private final String id = Long.toHexString(counter.incrementAndGet());
    private String contextID;
    private long contextTimeStamp;
    private boolean loadedFromRIS;

    public AbstractStudyContainer(String string) {
        this.contextID = string;
        this.loadedFromRIS = string != null;
        this.contextTimeStamp = System.currentTimeMillis();
    }

    @Override
    public Date getBaseStudyDate() {
        return Dcm4cheUtils.getDate((int)524320, (Attributes)this.baseStudy.getDicomObject());
    }

    @Override
    public IStudyData getBaseStudy() {
        return this.baseStudy;
    }

    @Override
    public void reorderStudy(String string, int n) {
    }

    @Override
    public void cleanUp() {
        this.baseStudy = null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getIndexStringOfStudy(String string) {
        return Integer.toString(this.getIndexOfStudy(string));
    }

    @Override
    public String getPreferredHangingID() {
        return null;
    }

    @Override
    public String getAndResetContextID() {
        String string = this.contextID;
        this.contextID = null;
        if (System.currentTimeMillis() - this.contextTimeStamp < CONTEXT_VALIDITY) {
            return string;
        }
        return null;
    }

    @Override
    public String[] resolveStrings(int n) {
        return this.getBaseStudy().resolveStrings(n);
    }

    @Override
    public Attributes resolveStringEnhanced(int[] nArray, int n) {
        return this.getBaseStudy().resolveStringEnhanced(nArray, n);
    }

    @Override
    public String resolveString(int n) {
        if (n == -65525 || n == PrivateTagDictionary.patientNumberOfLoadedStudiesTag) {
            return Integer.toString(this.getRelevantPriorCount());
        }
        return this.getBaseStudy().resolveString(n);
    }

    public String toString() {
        return "Container:" + this.baseStudy;
    }

    @Override
    public boolean isLoadedFromRIS() {
        return this.loadedFromRIS;
    }
}

