/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging;

import com.agfa.pacs.impaxee.data.fetcher.FetchableCollection;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.impl.HangingFactory;
import com.agfa.pacs.impaxee.splitsort.I4DProperties;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.VisDisplay2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DisplaySetCalculationData {
    private static final ALogger LOGGER = ALogger.getLogger(DisplaySetCalculationData.class);
    private final IDisplaySet baseDisplaySet;
    private final List<IDisplaySet> allDisplaySets;

    public DisplaySetCalculationData(VisDisplay2 visDisplay2) {
        IDisplaySet iDisplaySet = visDisplay2.getData().getDisplaySet();
        if (iDisplaySet.is4D()) {
            this.allDisplaySets = DisplaySetCalculationData.split4DDisplaySet(iDisplaySet);
            I4DProperties i4DProperties = visDisplay2.getData().get4DProperties();
            int n = i4DProperties.isPrimaryNavigationInSpace() ? i4DProperties.getSecondaryIndex() : visDisplay2.getNavigPos();
            int n2 = this.allDisplaySets.size();
            if (n < 0) {
                LOGGER.warn("Illegal base display set index: " + n);
                n = 0;
            } else if (n >= n2) {
                LOGGER.warn("Illegal base display set index: " + n);
                n = n2 - 1;
            }
            this.baseDisplaySet = this.allDisplaySets.get(n);
        } else {
            this.baseDisplaySet = iDisplaySet;
            this.allDisplaySets = Arrays.asList(DataSelectionManager.getInstance().getActiveHanging().getSplitAndSortRuntime().getDisplaySets());
        }
    }

    private static List<IDisplaySet> split4DDisplaySet(IDisplaySet iDisplaySet) {
        IFrameObjectData[][] iFrameObjectDataArray = iDisplaySet.getFrames();
        ISplitAndSortRuntime iSplitAndSortRuntime = DataSelectionManager.getInstance().getCurrentPatient().getDecompositionRuntime();
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>(iFrameObjectDataArray.length);
        IFrameObjectData[][] iFrameObjectDataArray2 = iFrameObjectDataArray;
        int n = iFrameObjectDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFrameObjectData[] iFrameObjectDataArray3 = iFrameObjectDataArray2[n2];
            FetchableCollection fetchableCollection = new FetchableCollection();
            fetchableCollection.addImageFrame(iDisplaySet, iFrameObjectDataArray3);
            arrayList.add(HangingFactory.getInstance().newTemporaryDisplaySet(fetchableCollection, iSplitAndSortRuntime));
            ++n2;
        }
        return Collections.unmodifiableList(arrayList);
    }

    public IStudyData getStudy() {
        return this.baseDisplaySet.getStudy();
    }

    public IDisplaySet getBaseDisplaySet() {
        return this.baseDisplaySet;
    }

    public List<IDisplaySet> getAllDisplaySets() {
        return this.allDisplaySets;
    }

    public int getFrameCount() {
        return this.baseDisplaySet.getRunFrameCount();
    }

    public String getFrameOfReferenceUID() {
        return this.baseDisplaySet.getFrameOfReferenceUID();
    }
}

