/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging;

import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.impaxee.splitsort.runtime.IDisplaySetContainerRuntime;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.util.TwoDArrayIterator;
import java.util.Iterator;
import org.apache.commons.collections4.IteratorUtils;
import org.dcm4che3.data.Attributes;

public class DisplaySetUtils {
    private static final ALogger log = ALogger.getLogger(DisplaySetUtils.class);

    private DisplaySetUtils() {
    }

    public static IStudyData getStudy(IDisplaySet iDisplaySet) {
        if (iDisplaySet == null) {
            return null;
        }
        try {
            return iDisplaySet.getStudy();
        }
        catch (Exception exception) {
            log.error("Could not determine StudyData object from display set label.", (Throwable)exception);
            return null;
        }
    }

    public static IDisplaySetContainerRuntime getDisplaySetContainerRuntime(IDisplaySet iDisplaySet) {
        ISplitAndSortRuntime iSplitAndSortRuntime;
        IPatientRepresentation iPatientRepresentation;
        IStudyData iStudyData = DisplaySetUtils.getStudy(iDisplaySet);
        if (iStudyData != null && (iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(iStudyData.getParent().getKey())) != null && (iSplitAndSortRuntime = iPatientRepresentation.getDecompositionRuntime()) instanceof IDisplaySetContainerRuntime) {
            return (IDisplaySetContainerRuntime)iSplitAndSortRuntime;
        }
        return null;
    }

    public static Iterable<Attributes> getAttributes(IDisplaySet iDisplaySet) {
        return new DisplaySetAttributesIterable(iDisplaySet);
    }

    private static class DisplaySetAttributesIterable
    implements Iterable<Attributes> {
        private final IDisplaySet displaySet;

        DisplaySetAttributesIterable(IDisplaySet iDisplaySet) {
            this.displaySet = iDisplaySet;
        }

        @Override
        public Iterator<Attributes> iterator() {
            return IteratorUtils.transformedIterator(new TwoDArrayIterator<IFrameObjectData>(this.displaySet.getFrames()), IDataObject::getDicomObject);
        }
    }
}

