/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging;

import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.HangingRuntimeManager;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingApplicability;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.registry.HPRegistry;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.util.expressions.IEvaluationContext;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class HPEvaluationThread
extends Thread
implements Cancelable {
    private static final ALogger log = ALogger.getLogger(HPEvaluationThread.class);
    private static DataManager dm = DataManager.getInstance();
    private List<HangingProtocol> hpList;
    private IPatientRepresentation patientRepresentation;
    private IStudyContainer studyContainer = null;
    private volatile boolean shouldTerminate;
    private volatile boolean running;
    private boolean shouldStartAgain;
    private boolean firstActivation;
    private List<IStudyContainer> containersToCheck;

    public HPEvaluationThread(List<HangingProtocol> list, IPatientRepresentation iPatientRepresentation, boolean bl) {
        super("HP Evaluation Thread");
        this.setPriority(1);
        this.hpList = list;
        this.patientRepresentation = iPatientRepresentation;
        this.firstActivation = bl;
        this.containersToCheck = this.patientRepresentation.getUncheckedStudyContainers();
    }

    public void setStudyContainer(IStudyContainer iStudyContainer) {
        this.studyContainer = iStudyContainer;
    }

    IPatientRepresentation getPatientRepresentation() {
        return this.patientRepresentation;
    }

    synchronized void terminate() {
    }

    private void checkHPs(Pair<IStudyContainer, List<IEvaluationContext>> pair, List<HangingProtocol> list) {
        String string = ((IStudyContainer)pair.getLeft()).getPreferredHangingID();
        IHanging iHanging = null;
        for (HangingProtocol hangingProtocol : list) {
            if (this.shouldTerminate || this.shouldStartAgain) break;
            HangingApplicability hangingApplicability = hangingProtocol.getHangingApplicability();
            if (!HangingRuntimeManager.checkApplicability(hangingApplicability, pair, hangingProtocol)) continue;
            if (Objects.equals(string, hangingProtocol.getName())) {
                iHanging = dm.addHangingProtocol(hangingProtocol, (IStudyContainer)pair.getLeft());
                continue;
            }
            dm.addHangingProtocol(hangingProtocol, (IStudyContainer)pair.getLeft());
        }
        if (iHanging != null) {
            log.debug("Applying preferred hanging: " + iHanging);
            DataSelectionManager.getInstance().setActiveHanging(this.patientRepresentation, iHanging, true, false);
        }
        dm.notifyPatientRepresentationModified(this.patientRepresentation);
    }

    @Override
    public void run() {
        this.running = true;
        if (this.firstActivation && this.studyContainer != null) {
            ImmutablePair object2 = new ImmutablePair((Object)this.studyContainer, HangingRuntimeManager.getDSforStudy(this.studyContainer));
            this.checkHPs((Pair<IStudyContainer, List<IEvaluationContext>>)object2, this.hpList);
            this.studyContainer = null;
        }
        if (!this.containersToCheck.isEmpty()) {
            this.hpList = HPRegistry.getInstance().getActiveHangingProtocolsForCurrentRole();
            while (true) {
                if (this.studyContainer == null) {
                    for (IStudyContainer iStudyContainer : this.containersToCheck) {
                        ImmutablePair immutablePair = new ImmutablePair((Object)iStudyContainer, HangingRuntimeManager.getDSforStudy(iStudyContainer));
                        this.checkHPs((Pair<IStudyContainer, List<IEvaluationContext>>)immutablePair, this.hpList);
                    }
                } else {
                    ImmutablePair immutablePair = new ImmutablePair((Object)this.studyContainer, HangingRuntimeManager.getDSforStudy(this.studyContainer));
                    this.checkHPs((Pair<IStudyContainer, List<IEvaluationContext>>)immutablePair, this.hpList);
                }
                if (this.shouldTerminate || !this.shouldStartAgain) break;
                this.shouldStartAgain = false;
            }
        }
        log.info("finished hanging protocol evaluation thread");
        this.running = false;
    }

    public void cancel() {
        this.shouldTerminate = true;
    }

    public boolean isRunning() {
        return this.running;
    }
}

