/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.HangingEvaluation;
import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.descriptors.DescriptorRegistry;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.attributes.ConfiguredAttributeFilter;
import com.agfa.pacs.impaxee.hanging.gui.advanced.HangingProtocolWarningUtil;
import com.agfa.pacs.impaxee.hanging.model.IHangingProtocolDefinition;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingApplicability;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.model.xml.ReferencedDescriptor;
import com.agfa.pacs.impaxee.hanging.registry.HPRegistry;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.main.DisplaySetEvaluable;
import com.tiani.util.expressions.EvaluationContext;
import com.tiani.util.expressions.IEvaluableData;
import com.tiani.util.expressions.IEvaluationContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.dcm4che3.util.TagUtils;

public class HangingRuntimeManager {
    private static final ALogger log = ALogger.getLogger(HangingRuntimeManager.class);
    private static final ConfiguredAttributeFilter attributeFilter = ConfiguredAttributeFilter.getInstance();
    private static final DescriptorRegistry descriptorsRegistry = DescriptorRegistry.getInstance();
    private static HangingRuntimeManager instance = new HangingRuntimeManager();
    private static boolean autoHangup = Config.impaxee.jvision.HANGMAN.AutoHangup.get();

    private HangingRuntimeManager() {
    }

    public static HangingRuntimeManager getInstance() {
        return instance;
    }

    public static boolean isAutoHangupEnabled() {
        return autoHangup;
    }

    public static void toggleAutoHangup() {
        autoHangup = !autoHangup;
    }

    static EvaluationResult evaluateDescriptor(ReferencedDescriptor referencedDescriptor, Pair<IStudyContainer, List<IEvaluationContext>> pair) {
        Condition condition;
        EvaluationResult evaluationResult = EvaluationResult.FALSE;
        Descriptor descriptor = descriptorsRegistry.getDescriptorWithID(referencedDescriptor.getId());
        if (descriptor == null) {
            log.error("Referenced descriptor (ID=" + referencedDescriptor.getId() + ") not found in registry. Returning evaluation result FALSE.");
            return EvaluationResult.FALSE;
        }
        int n = 0;
        while ((condition = descriptor.getCondition(n)) != null && (evaluationResult = HangingRuntimeManager.meetsCondition(condition, pair)) != EvaluationResult.FALSE) {
            ++n;
        }
        if (log.isDebugEnabled()) {
            log.debug("Evaluation of descriptor(ID=" + referencedDescriptor.getId() + ", name='" + descriptor.getName() + "'): result=" + (Object)((Object)evaluationResult));
        }
        return evaluationResult;
    }

    static boolean checkHangingCondition(HangingCondition hangingCondition2, HangingProtocol hangingProtocol, Pair<IStudyContainer, List<IEvaluationContext>> pair) {
        ReferencedDescriptor referencedDescriptor;
        boolean bl = false;
        if (log.isDebugEnabled()) {
            log.debug("Starting evaluating applicability of hanging protocol '" + hangingProtocol.getName() + "'");
        }
        int n = 0;
        while ((referencedDescriptor = hangingCondition2.getReferencedDescriptor(n)) != null) {
            EvaluationResult evaluationResult = HangingRuntimeManager.evaluateDescriptor(referencedDescriptor, pair);
            switch (evaluationResult) {
                case TRUE: {
                    bl = true;
                    break;
                }
                case FALSE: {
                    return false;
                }
            }
            ++n;
        }
        if (log.isDebugEnabled()) {
            log.debug("Finished evaluating applicability of hanging protocol '" + hangingProtocol.getName() + "': result=" + bl);
        }
        return bl;
    }

    static boolean checkPriors(IStudyContainer iStudyContainer, IHangingProtocolDefinition iHangingProtocolDefinition) {
        int n = iHangingProtocolDefinition.getNumberOfPriors();
        switch (iHangingProtocolDefinition.getUsePriors()) {
            case FIRST_X_PRIORS: 
            case FIRST_X_PRIORS_WITH_LAST: {
                return iStudyContainer.getRelevantPriorCount() >= n;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean checkApplicability(HangingApplicability hangingApplicability, Pair<IStudyContainer, List<IEvaluationContext>> pair, HangingProtocol hangingProtocol) {
        if (pair == null) {
            return false;
        }
        if (!HangingRuntimeManager.checkPriors((IStudyContainer)pair.getLeft(), hangingProtocol)) {
            if (log.isDebugEnabled()) {
                log.debug(String.valueOf(hangingProtocol.getName()) + " has not enough priors");
            }
            return false;
        }
        try {
            HangingCondition hangingCondition2;
            Iterator<HangingCondition> iterator = hangingApplicability.hangingConditions().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!HangingRuntimeManager.checkHangingCondition(hangingCondition2 = iterator.next(), hangingProtocol, pair) || HangingProtocolWarningUtil.hasOnlyOneStudyContradictions(hangingProtocol));
            return true;
        }
        catch (Exception exception) {
            log.error("Could not check applicability", (Throwable)exception);
            return false;
        }
    }

    private List<HangingProtocol> getActiveHPsForCurrentRole() {
        return HPRegistry.getInstance().getActiveHangingProtocolsForCurrentRole();
    }

    public HangingEvaluation triggerFirstHPEvaluation(IPatientRepresentation iPatientRepresentation) {
        log.info("Start HP Evaluation:" + iPatientRepresentation.toLoggingString());
        List<HangingProtocol> list = this.getActiveHPsForCurrentRole();
        int n = this.findApplicablePreferredHangingIndex(iPatientRepresentation, list);
        if (autoHangup || n >= 0) {
            IStudyContainer iStudyContainer = iPatientRepresentation.getFirstUncheckedStudyContainer();
            if (iStudyContainer == null) {
                return null;
            }
            ImmutablePair immutablePair = new ImmutablePair((Object)iStudyContainer, HangingRuntimeManager.getDSforStudy(iStudyContainer));
            if (n > 0) {
                ArrayList<HangingProtocol> arrayList = new ArrayList<HangingProtocol>(list.size());
                arrayList.add(list.get(n));
                arrayList.addAll(list.subList(0, n));
                arrayList.addAll(list.subList(n + 1, list.size()));
                list = arrayList;
            }
            int n2 = 0;
            while (n2 < list.size()) {
                HangingProtocol hangingProtocol = list.get(n2);
                HangingApplicability hangingApplicability = hangingProtocol.getHangingApplicability();
                if (HangingRuntimeManager.checkApplicability(hangingApplicability, (Pair<IStudyContainer, List<IEvaluationContext>>)immutablePair, hangingProtocol)) {
                    log.debug("hp application success: " + hangingProtocol.getName());
                    return new HangingEvaluation(hangingProtocol, iStudyContainer, list.subList(++n2, list.size()));
                }
                log.debug("hp application failed: " + hangingProtocol.getName());
                ++n2;
            }
        }
        return null;
    }

    public void triggerFurtherHPEvaluation(IPatientRepresentation iPatientRepresentation, HangingEvaluation hangingEvaluation) {
        if (hangingEvaluation != null) {
            iPatientRepresentation.startHPEvaluation(hangingEvaluation.hangingProtocols, hangingEvaluation.container);
        } else {
            iPatientRepresentation.startHPEvaluation(null, null);
        }
    }

    static List<IEvaluationContext> getDSforStudy(IStudyContainer iStudyContainer) {
        ArrayList<IEvaluationContext> arrayList = new ArrayList<IEvaluationContext>(32);
        String string = iStudyContainer.getBaseStudy().getKey();
        for (IDisplaySet iDisplaySet : iStudyContainer.getPatientRepresentation().getDecompositionRuntime().getDisplaySetsOfStudy(string)) {
            arrayList.add(new DisplaySetEvaluable(iDisplaySet.getOneObject(), iDisplaySet, iStudyContainer));
        }
        return arrayList;
    }

    private int findApplicablePreferredHangingIndex(IPatientRepresentation iPatientRepresentation, List<HangingProtocol> list) {
        HangingProtocol hangingProtocol;
        IStudyContainer iStudyContainer = iPatientRepresentation.peekFirstUncheckedStudyContainer();
        if (iStudyContainer == null) {
            return -1;
        }
        int n = this.findHangingProtocolIndex(list, iStudyContainer.getPreferredHangingID());
        if (n >= 0 && !HangingRuntimeManager.checkApplicability((hangingProtocol = list.get(n)).getHangingApplicability(), (Pair<IStudyContainer, List<IEvaluationContext>>)Pair.of((Object)iStudyContainer, HangingRuntimeManager.getDSforStudy(iStudyContainer)), hangingProtocol)) {
            n = -1;
        }
        return n;
    }

    private int findHangingProtocolIndex(List<HangingProtocol> list, String string) {
        if (string != null) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(list.get(n2).getName())) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    static EvaluationResult meetsCondition(Condition condition, Pair<IStudyContainer, List<IEvaluationContext>> pair) {
        int n = condition.getTag();
        boolean bl = TagUtils.isPrivateGroup((int)n);
        EvaluationResult evaluationResult = null;
        if (attributeFilter.getPatientLevel().isIn(n) || attributeFilter.getStudyLevel().isIn(n) || bl) {
            EvaluationResult evaluationResult2 = evaluationResult = Condition.evaluate(condition, new EvaluationContext((IEvaluableData)pair.getLeft(), null)) ? EvaluationResult.TRUE : EvaluationResult.FALSE;
            if (evaluationResult == EvaluationResult.TRUE || !bl) {
                return evaluationResult;
            }
        }
        for (IEvaluationContext iEvaluationContext : (List)pair.getRight()) {
            EvaluationResult evaluationResult3 = evaluationResult = Condition.evaluate(condition, iEvaluationContext) ? EvaluationResult.TRUE : EvaluationResult.FALSE;
            if (evaluationResult != EvaluationResult.TRUE) continue;
            return evaluationResult;
        }
        return EvaluationResult.FALSE;
    }

    public boolean meetsConditions(Iterable<Condition> iterable, IHanging iHanging) {
        IStudyContainer iStudyContainer = iHanging.getStudyContainer();
        if (iStudyContainer != null) {
            ImmutablePair immutablePair = new ImmutablePair((Object)iStudyContainer, HangingRuntimeManager.getDSforStudy(iStudyContainer));
            for (Condition condition : iterable) {
                if (HangingRuntimeManager.meetsCondition(condition, (Pair<IStudyContainer, List<IEvaluationContext>>)immutablePair) == EvaluationResult.TRUE) continue;
                return false;
            }
        }
        return true;
    }

    private static enum EvaluationResult {
        TRUE,
        FALSE;

    }
}

