/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IMultiplePatientHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.ISinglePatientHanging;
import com.agfa.pacs.impaxee.hanging.gui.advanced.HangingDefinitionConfigurationEditDialog;
import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHangingScreen;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplayLayout;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetConditionRule;
import com.agfa.pacs.impaxee.hanging.model.xml.Layout;
import com.agfa.pacs.impaxee.hanging.model.xml.ScreenLayout;
import com.agfa.pacs.impaxee.hanging.model.xml.Snapshot;
import com.agfa.pacs.impaxee.hanging.registry.HPRegistry;
import com.agfa.pacs.impaxee.hanging.runtime.DefaultHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingDefinitionRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.SinglePatientHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.UserDefinedHangingProtocolRuntime;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.sessions.gui.NewSessionDialog;
import com.agfa.pacs.impaxee.sessions.gui.WorklistChooser;
import com.agfa.pacs.listtext.lta.base.controls.PermissionUtilities;
import com.agfa.pacs.listtext.lta.base.session.SessionDeleter;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IKeyObjectData;
import com.tiani.gui.dialog.GUIMessageHandler;
import com.tiani.gui.dialog.StandardDialog;
import com.tiani.jvision.main.DisplaySetEvaluable;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.awt.Frame;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public abstract class HangingUtil {
    private static final boolean IS_AUTOMATED_TESTING = Product.isRunningAutoTests();
    private static final SessionDeleter SESSION_DELETER = new SessionDeleter((IComponentFactory)ComponentFactory.instance);

    public static boolean newSession(Component component, boolean bl) {
        SessionCreationCheckResult sessionCreationCheckResult = HangingUtil.checkSessionCreation(DataSelectionManager.getInstance().getActiveHanging());
        if (sessionCreationCheckResult != SessionCreationCheckResult.ALLOWED) {
            switch (sessionCreationCheckResult) {
                case MULTI_PATIENT: 
                case LOSSY_PREFETCH: {
                    Message.error(Messages.getString("HangingUtil.SessionCreationCheckError." + sessionCreationCheckResult.name()));
                    break;
                }
                case NO_PERMISSION: {
                    PermissionUtilities.showPermissionDeniedDialog((Component)component, null);
                    break;
                }
            }
            return false;
        }
        Session session = HangingUtil.createSession(bl);
        if (session != null) {
            IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
            iPatientRepresentation.addHanging(session);
            boolean bl2 = Config.impaxee.jvision.PLUGINS.AutoSetLive.get();
            Config.impaxee.jvision.PLUGINS.AutoSetLive.set(true);
            DataSelectionManager.getInstance().setActiveHanging(iPatientRepresentation, session, true, true, true);
            Config.impaxee.jvision.PLUGINS.AutoSetLive.set(bl2);
            return true;
        }
        return false;
    }

    public static String createSessionName() {
        Object object;
        boolean bl;
        IStudyInfo iStudyInfo = null;
        boolean bl2 = bl = !Config.impaxee.jvision.DISPLAY.UseBaseStudyAttributesInSessionName.get();
        if (!bl && (object = DataSelectionManager.getInstance().getActiveHanging().getStudyContainer().getBaseStudy()) != null) {
            iStudyInfo = (IStudyInfo)object.getQueryObject();
        }
        object = new StringBuilder("Session ");
        ((StringBuilder)object).append(URLProviderFactory.getProvider().getLoginInformation().getUserFullName());
        if (bl || iStudyInfo == null) {
            if (!IS_AUTOMATED_TESTING) {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
                ((StringBuilder)object).append(' ').append(dateFormat.format(new Date()));
            }
        } else {
            String string;
            Date date;
            ((StringBuilder)object).append('-');
            String string2 = DicomUtils.getModalitiesInStudiesAsString((IStudyInfo)iStudyInfo, (boolean)true, (boolean)true, (boolean)false);
            if (string2 != null) {
                ((StringBuilder)object).append(string2).append(' ');
            }
            if ((date = iStudyInfo.getDate(524320)) != null) {
                ((StringBuilder)object).append(DateTimeUtils.date2String((Date)date)).append(' ');
            }
            if ((string = iStudyInfo.getString(528432)) != null) {
                ((StringBuilder)object).append(string).append(' ');
            }
            ((StringBuilder)object).deleteCharAt(((StringBuilder)object).length() - 1);
        }
        return ((StringBuilder)object).toString();
    }

    private static Session createSession(boolean bl) {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation != null) {
            NewSessionDialog newSessionDialog = new NewSessionDialog((Frame)JVision2.getMainFrame(), iPatientRepresentation, bl);
            if (IS_AUTOMATED_TESTING || !Config.impaxee.jvision.DIALOGS.StoreSessionIntoWorklist.get()) {
                newSessionDialog.confirmSessionCreation();
            } else {
                newSessionDialog.setVisible(true);
            }
            if (newSessionDialog.getDialogResult() == 0) {
                return newSessionDialog.getSession();
            }
        } else {
            Message.error(Messages.getString("NO_PATIENT_FOR_HANGING"));
        }
        return null;
    }

    public static void dismissCurrentHanging() {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging instanceof DefaultHangingProtocolRuntime) {
            return;
        }
        assert (iHanging != null) : "There must be a current hanging state for action hideCurrentHangingState!";
        HangingUtil.dismissHanging(iHanging);
    }

    public static void deleteCurrentHanging() {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging instanceof UserDefinedHangingProtocolRuntime && Message.yesNo(Messages.getString("HangingUtil.ConfirmDeletionDialogTitle"), Messages.getString("HangingUtil.ConfirmDeletionMessage")) == 0) {
            HPRegistry.getInstance().deleteHangingProtocol(((UserDefinedHangingProtocolRuntime)iHanging).getHangingProtocol());
            HangingUtil.dismissHanging(iHanging);
        }
    }

    public static void deleteCurrentSession() {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging instanceof Session) {
            Session session = (Session)iHanging;
            IKeyObjectData iKeyObjectData = session.getKeyObjectData();
            boolean bl = iKeyObjectData != null && iKeyObjectData.getQueryObject() != null;
            boolean bl2 = false;
            bl2 = bl ? SESSION_DELETER.deleteSession(null, (IObjectInfo)session.getKeyObjectData().getQueryObject()) : true;
            if (bl2) {
                session.setSaved(true);
                HangingUtil.dismissHanging(iHanging);
            }
        }
    }

    public static void dismissHanging(IHanging iHanging) {
        Collection<IPatientRepresentation> collection;
        DataManager.getInstance().removeHangingState(iHanging);
        if (iHanging instanceof ISinglePatientHanging) {
            IPatientRepresentation iPatientRepresentation = ((ISinglePatientHanging)iHanging).getPatient();
            HangingUtil.ensureActiveHangingForPatient(iPatientRepresentation, Collections.singletonList(iHanging));
        } else if (iHanging instanceof IMultiplePatientHanging && (collection = ((IMultiplePatientHanging)iHanging).getPatients()) != null) {
            for (IPatientRepresentation iPatientRepresentation : collection) {
                HangingUtil.ensureActiveHangingForPatient(iPatientRepresentation, Collections.singletonList(iHanging));
            }
        }
    }

    public static void dismissHangings(IPatientRepresentation iPatientRepresentation, List<IHanging> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (IHanging iHanging : list) {
            DataManager.getInstance().removeHangingState(iHanging);
        }
        HangingUtil.ensureActiveHangingForPatient(iPatientRepresentation, list);
    }

    private static void ensureActiveHangingForPatient(IPatientRepresentation iPatientRepresentation, List<IHanging> list) {
        IHanging iHanging = iPatientRepresentation.getActiveHanging();
        if (iHanging == null || list.contains(iHanging)) {
            IHanging iHanging2 = iPatientRepresentation.countHangings() > 0 ? iPatientRepresentation.getHanging(0) : null;
            boolean bl = false;
            for (IHanging iHanging3 : list) {
                if (!(iHanging3 instanceof IHangingSession)) continue;
                bl = true;
                break;
            }
            DataSelectionManager.getInstance().setActiveHanging(iPatientRepresentation, iHanging2, true, bl);
        }
    }

    private HangingUtil() {
    }

    public static boolean belongsToCurrentPatient(IHanging iHanging) {
        return HangingUtil.belongsToPatient(DataSelectionManager.getInstance().getCurrentPatient(), iHanging);
    }

    public static boolean belongsToPatient(IPatientRepresentation iPatientRepresentation, IHanging iHanging) {
        if (iPatientRepresentation != null) {
            if (iHanging instanceof ISinglePatientHanging) {
                return ((ISinglePatientHanging)iHanging).getPatient() == iPatientRepresentation;
            }
            if (iHanging instanceof IMultiplePatientHanging) {
                Collection<IPatientRepresentation> collection = ((IMultiplePatientHanging)iHanging).getPatients();
                if (collection != null) {
                    return collection.contains(iPatientRepresentation);
                }
            } else if (iHanging instanceof Session) {
                return ((Session)iHanging).getStudyContainer().getPatientRepresentation() == iPatientRepresentation;
            }
        }
        return false;
    }

    public static boolean editUserDefinedHanging(UserDefinedHangingProtocolRuntime userDefinedHangingProtocolRuntime) {
        Object object;
        HangingProtocolSnapshotRuntime[] hangingProtocolSnapshotRuntimeArray = ((HangingDefinitionRuntime)userDefinedHangingProtocolRuntime.getHangingDefinition()).snapshots();
        int n = hangingProtocolSnapshotRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = hangingProtocolSnapshotRuntimeArray[n2];
            ((HangingProtocolSnapshotRuntime)object).setUseRuntimeForSave(true);
            ++n2;
        }
        object = new UserDefinedHangingProtocolRuntime(userDefinedHangingProtocolRuntime);
        Object object2 = ((HangingDefinitionRuntime)userDefinedHangingProtocolRuntime.getHangingDefinition()).snapshots();
        int n3 = ((HangingProtocolSnapshotRuntime[])object2).length;
        n = 0;
        while (n < n3) {
            HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime = object2[n];
            hangingProtocolSnapshotRuntime.setUseRuntimeForSave(false);
            ++n;
        }
        object2 = ((HangingDefinitionRuntime)((SinglePatientHangingProtocolRuntime)object).getHangingDefinition()).snapshots();
        n3 = ((HangingProtocolSnapshotRuntime[])object2).length;
        n = 0;
        while (n < n3) {
            HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime = object2[n];
            hangingProtocolSnapshotRuntime.setHangingApplied(false);
            hangingProtocolSnapshotRuntime.setCacheDisplaySets(false);
            ++n;
        }
        String string = userDefinedHangingProtocolRuntime.getIdentifier();
        String string2 = userDefinedHangingProtocolRuntime.getName();
        String string3 = userDefinedHangingProtocolRuntime.getVisibleName();
        object2 = new HangingDefinitionConfigurationEditDialog(JVision2.getMainFrame(), (UserDefinedHangingProtocolRuntime)object, userDefinedHangingProtocolRuntime.getStudyContainer());
        ((StandardDialog)object2).setVisible(true);
        if (((StandardDialog)object2).getDialogResult() == 0) {
            HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime;
            HangingProtocolSnapshotRuntime[] hangingProtocolSnapshotRuntimeArray2 = ((HangingDefinitionRuntime)((SinglePatientHangingProtocolRuntime)object).getHangingDefinition()).snapshots();
            int n4 = hangingProtocolSnapshotRuntimeArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                hangingProtocolSnapshotRuntime = hangingProtocolSnapshotRuntimeArray2[n5];
                hangingProtocolSnapshotRuntime.setUseRuntimeForSave(true);
                ++n5;
            }
            userDefinedHangingProtocolRuntime.initFrom((SinglePatientHangingProtocolRuntime)object);
            userDefinedHangingProtocolRuntime.save();
            hangingProtocolSnapshotRuntimeArray2 = ((HangingDefinitionRuntime)userDefinedHangingProtocolRuntime.getHangingDefinition()).snapshots();
            n4 = hangingProtocolSnapshotRuntimeArray2.length;
            n5 = 0;
            while (n5 < n4) {
                hangingProtocolSnapshotRuntime = hangingProtocolSnapshotRuntimeArray2[n5];
                hangingProtocolSnapshotRuntime.setUseRuntimeForSave(false);
                ++n5;
            }
            userDefinedHangingProtocolRuntime.getPatient().setActiveHanging(null);
            DataSelectionManager.getInstance().clearCurrentSnapshot();
            if (string2.equals(userDefinedHangingProtocolRuntime.getName())) {
                userDefinedHangingProtocolRuntime.setVisibleName(string3);
                userDefinedHangingProtocolRuntime.setIdentifier(string);
            }
            DataSelectionManager.getInstance().setActiveHanging(userDefinedHangingProtocolRuntime.getPatient(), userDefinedHangingProtocolRuntime, true, false);
            return true;
        }
        if (((HangingDefinitionConfigurationEditDialog)object2).isReHangupRequired()) {
            DataSelectionManager.getInstance().reHangup();
        }
        return false;
    }

    public static IDisplaySet getFirstMatchingDisplaySet(HangingProtocolRuntime hangingProtocolRuntime, DisplaySetCondition displaySetCondition2) {
        return HangingUtil.getFirstMatchingDisplaySet(hangingProtocolRuntime.getDisplaySets(), hangingProtocolRuntime, displaySetCondition2, false);
    }

    public static IDisplaySet consumeFirstMatchingDisplaySet(List<IDisplaySet> list, HangingProtocolRuntime hangingProtocolRuntime, DisplaySetCondition displaySetCondition2) {
        return HangingUtil.getFirstMatchingDisplaySet(list, hangingProtocolRuntime, displaySetCondition2, true);
    }

    private static IDisplaySet getFirstMatchingDisplaySet(List<IDisplaySet> list, HangingProtocolRuntime hangingProtocolRuntime, DisplaySetCondition displaySetCondition2, boolean bl) {
        Iterator<IDisplaySet> iterator = list.iterator();
        IDisplaySet iDisplaySet = null;
        while (iterator.hasNext()) {
            iDisplaySet = iterator.next();
            IFrameObjectData iFrameObjectData = iDisplaySet.getOneObject();
            if (iFrameObjectData == null) continue;
            for (DisplaySetConditionRule displaySetConditionRule : displaySetCondition2.rules()) {
                int n = displaySetConditionRule.conditionCount();
                boolean bl2 = true;
                int n2 = 0;
                while (n2 < n) {
                    DisplaySetEvaluable displaySetEvaluable;
                    Condition condition = displaySetConditionRule.cachedConditions().get(n2);
                    if (!Condition.evaluate(condition, displaySetEvaluable = new DisplaySetEvaluable(iFrameObjectData, iDisplaySet, hangingProtocolRuntime.getStudyContainer()))) {
                        bl2 = false;
                        break;
                    }
                    ++n2;
                }
                if (!bl2 || n <= 0) continue;
                if (bl) {
                    iterator.remove();
                }
                return iDisplaySet;
            }
        }
        return null;
    }

    public static boolean matches(IDisplaySet iDisplaySet, HangingProtocolRuntime hangingProtocolRuntime, Iterable<Condition> iterable) {
        IFrameObjectData iFrameObjectData = iDisplaySet.getOneObject();
        for (Condition condition : iterable) {
            DisplaySetEvaluable displaySetEvaluable;
            if (Condition.evaluate(condition, displaySetEvaluable = new DisplaySetEvaluable(iFrameObjectData, iDisplaySet, hangingProtocolRuntime.getStudyContainer()))) continue;
            return false;
        }
        return true;
    }

    public static Snapshot createSnapshot(String string) {
        Snapshot snapshot = new Snapshot(string);
        Layout layout = new Layout();
        layout.setType(MainLayoutType.variable);
        ScreenLayout screenLayout = new ScreenLayout();
        screenLayout.setHorizontalXVertical("1x1");
        DisplayLayout displayLayout = new DisplayLayout("1x1");
        screenLayout.addDisplayLayout(displayLayout);
        layout.addScreenLayout(screenLayout);
        screenLayout = new ScreenLayout();
        screenLayout.setHorizontalXVertical("1x1");
        displayLayout = new DisplayLayout("1x1");
        screenLayout.addDisplayLayout(displayLayout);
        layout.addScreenLayout(screenLayout);
        snapshot.setLayout(layout);
        ConditionalHanging conditionalHanging = new ConditionalHanging();
        ConditionalHangingScreen conditionalHangingScreen = new ConditionalHangingScreen();
        conditionalHangingScreen.addDisplaySetCondition(new DisplaySetCondition());
        conditionalHanging.addConditionalHangingScreen(conditionalHangingScreen);
        snapshot.setConditionalHanging(conditionalHanging);
        return snapshot;
    }

    public static boolean saveSession(IHangingSession iHangingSession, boolean bl) {
        WorklistChooser worklistChooser;
        List<IWorklistContext> list = iHangingSession.getUserAndScheduledWorklistContexts();
        boolean bl2 = bl && Config.impaxee.jvision.DIALOGS.StoreSessionIntoWorklist.get() && !list.isEmpty() ? ((worklistChooser = new WorklistChooser(GUIMessageHandler.getParentWindow(), list, iHangingSession)).getDialogResult() == "OK_OPTION" ? worklistChooser.saveReplacementDataAndSession() : false) : iHangingSession.saveReplacementDataAndSession(null);
        return bl2;
    }

    public static boolean isCreateSessionPossible(IHanging iHanging) {
        return HangingUtil.checkSessionCreation(iHanging) == SessionCreationCheckResult.ALLOWED;
    }

    private static SessionCreationCheckResult checkSessionCreation(IHanging iHanging) {
        if (Product.isReducedVersion() || !Permissions.getInstance().isAllowed("ImageArea/AllowedToCreateAndSaveSessions")) {
            return SessionCreationCheckResult.NO_PERMISSION;
        }
        if (DataSelectionManager.getInstance().getCurrentPatient() == null) {
            return SessionCreationCheckResult.NO_PATIENT;
        }
        if (!(iHanging instanceof ISinglePatientHanging)) {
            return SessionCreationCheckResult.MULTI_PATIENT;
        }
        if (iHanging.getStudyContainer() != null && iHanging.getStudyContainer().getPatientRepresentation().getPatientData().hasLossyPrefetchedImages()) {
            return SessionCreationCheckResult.LOSSY_PREFETCH;
        }
        return SessionCreationCheckResult.ALLOWED;
    }

    private static enum SessionCreationCheckResult {
        ALLOWED,
        NO_PERMISSION,
        NO_PATIENT,
        MULTI_PATIENT,
        LOSSY_PREFETCH;

    }
}

