/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.descriptors.AbstractDescriptorsXmlLoader;
import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.descriptors.DescriptorRegistry;
import com.agfa.pacs.impaxee.hanging.HangingImportExport;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHangingScreen;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetConditionRule;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.model.xml.Snapshot;
import com.agfa.pacs.impaxee.hanging.registry.HPRegistry;
import com.agfa.pacs.impaxee.model.xml.shared.AbstractReferencedDescriptorsContainer;
import com.agfa.pacs.logging.ALogger;
import com.tiani.config.xml.minijaxb.XmlLoadable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HangingXmlLoader
extends AbstractDescriptorsXmlLoader {
    public static final String FILE_EXTENSION = ".AGH";
    private static final ALogger log = ALogger.getLogger(HangingXmlLoader.class);

    public HangingXmlLoader() {
        super(FILE_EXTENSION);
    }

    @Override
    protected boolean importSelectedXmlData(Component component, XmlLoadable xmlLoadable, boolean bl) {
        HangingImportExport hangingImportExport = (HangingImportExport)xmlLoadable;
        List<HangingProtocol> list = hangingImportExport.hangingProtocolsAsList();
        for (HangingProtocol hangingProtocol : list) {
            if (!this.importReferencedDescriptors(hangingProtocol, hangingImportExport, bl)) continue;
            HPRegistry.getInstance().importHangingProtocol(hangingProtocol);
        }
        return true;
    }

    @Override
    protected Class<? extends XmlLoadable> getXmlLoadableClass() {
        return HangingImportExport.class;
    }

    @Override
    protected String getAbortOption() {
        return Messages.getString("HangingXmlLoader.DecriptorConflict.DontImport");
    }

    protected boolean importReferencedDescriptors(HangingProtocol hangingProtocol, HangingImportExport hangingImportExport, boolean bl) {
        long l;
        long l2;
        Collection collection = null;
        try {
            collection = hangingProtocol.referencedDescriptorIDs();
        }
        catch (Exception exception) {
            log.error("Error getting descriptor information from hanging protocol", (Throwable)exception);
            return false;
        }
        List<Descriptor> list = hangingImportExport.descriptorsAsList();
        ArrayList<Descriptor> arrayList2 = new ArrayList<Descriptor>();
        for (Descriptor arrayList3 : list) {
            if (!collection.contains(arrayList3.getId())) continue;
            arrayList2.add(arrayList3);
        }
        ArrayList<Descriptor> arrayList = new ArrayList<Descriptor>();
        HashMap hashMap = new HashMap();
        if (!this.collectReferencedDescriptorsForImport(arrayList2, arrayList, hashMap, bl)) {
            return false;
        }
        HashSet<AbstractReferencedDescriptorsContainer> hashSet = new HashSet<AbstractReferencedDescriptorsContainer>();
        for (Descriptor descriptor : arrayList) {
            l2 = descriptor.getId();
            l = DescriptorRegistry.getInstance().importDescriptor(descriptor);
            hangingProtocol.updateReferencedDescriptors(l2, l);
            this.collectConditions(hangingProtocol, l2, l, hashSet);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            l2 = (Long)entry.getKey();
            l = (Long)entry.getValue();
            for (HangingCondition hangingCondition2 : hangingProtocol.getHangingApplicability().hangingConditions()) {
                hangingCondition2.updateReferencedDescriptors(l2, l);
                hashSet.add(hangingCondition2);
            }
            this.collectConditions(hangingProtocol, l2, l, hashSet);
        }
        for (AbstractReferencedDescriptorsContainer abstractReferencedDescriptorsContainer : hashSet) {
            abstractReferencedDescriptorsContainer.rebuildConditions();
        }
        return true;
    }

    private void collectConditions(HangingProtocol hangingProtocol, long l, long l2, Set<AbstractReferencedDescriptorsContainer> set) {
        Snapshot[] snapshotArray = hangingProtocol.getHangingDefinition().snapshots();
        int n = snapshotArray.length;
        int n2 = 0;
        while (n2 < n) {
            Snapshot snapshot = snapshotArray[n2];
            if (snapshot.getConditionalHanging() != null) {
                for (ConditionalHangingScreen conditionalHangingScreen : snapshot.getConditionalHanging().screens()) {
                    for (DisplaySetCondition displaySetCondition2 : conditionalHangingScreen.displaySetConditions()) {
                        for (DisplaySetConditionRule displaySetConditionRule : displaySetCondition2.rules()) {
                            displaySetConditionRule.updateReferencedDescriptors(l, l2);
                            set.add(displaySetConditionRule);
                        }
                    }
                }
            }
            ++n2;
        }
    }
}

