/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PAsynchronousAction;
import com.agfa.pacs.impaxee.actions.PAsynchronousActionListener;
import com.agfa.pacs.impaxee.hanging.AbstractDisplaySetActionProvider;
import com.agfa.pacs.impaxee.hanging.DisplaySetUtils;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.keyimages.IKeyImageExpansion;
import com.agfa.pacs.impaxee.keyimages.KeyImageDisplaySetExpansion;
import com.agfa.pacs.impaxee.keyimages.KeyImageStudyExpansion;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class KeyImageExpansionActionProvider
extends AbstractDisplaySetActionProvider {
    public static final String DISPLAY_SET_EXPANSION_ACTION_ID = "DISPLAY_SET_EXPANSION_TOGGLE";
    public static final String STUDY_EXPANSION_ACTION_ID = "STUDY_EXPANSION_TOGGLE";

    @Override
    protected List<PAction> getActions(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider) {
        ArrayList<PAction> arrayList = new ArrayList<PAction>(2);
        arrayList.add(new DisplaySetExpansionAction(iDisplaySetProvider));
        arrayList.add(new StudyExpansionAction(iDisplaySetProvider));
        return arrayList;
    }

    private static abstract class AbstractKeyImageExpansionAction<T>
    extends AbstractDisplaySetActionProvider.AbstractDisplaySetPAction
    implements PAsynchronousAction {
        private final IKeyImageExpansion<T> helper;

        AbstractKeyImageExpansionAction(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider, IKeyImageExpansion<T> iKeyImageExpansion) {
            super(iDisplaySetProvider);
            this.helper = iKeyImageExpansion;
        }

        abstract T getData(IDisplaySet var1);

        @Override
        public String getGroupName() {
            return WORKFLOW_HANDLING_GROUP;
        }

        @Override
        public boolean isEnabled(VisData visData) {
            return visData != null && this.helper.isCollapsableOrExpandable(this.getData(visData.getParent().getDisplaySet()));
        }

        @Override
        protected boolean isEnabledImpl() {
            return this.helper.isCollapsableOrExpandable(this.getData(this.provider.getDisplaySet()));
        }

        @Override
        public boolean perform(Component component, PAsynchronousActionListener pAsynchronousActionListener) {
            this.notifyActionPerformed();
            this.helper.toggleExpansionState(this.getData(this.provider.getDisplaySet()), pAsynchronousActionListener);
            return true;
        }
    }

    private static class DisplaySetExpansionAction
    extends AbstractKeyImageExpansionAction<IDisplaySet> {
        DisplaySetExpansionAction(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider) {
            super(iDisplaySetProvider, KeyImageDisplaySetExpansion.getInstance());
        }

        @Override
        public String getID() {
            return KeyImageExpansionActionProvider.DISPLAY_SET_EXPANSION_ACTION_ID;
        }

        @Override
        public String getName() {
            return Messages.getString("DisplaySetExpansionAction.Name");
        }

        @Override
        public String getCaption() {
            return Messages.getString("DisplaySetExpansionAction.Caption");
        }

        @Override
        IDisplaySet getData(IDisplaySet iDisplaySet) {
            return iDisplaySet;
        }
    }

    private static class StudyExpansionAction
    extends AbstractKeyImageExpansionAction<IStudyData> {
        StudyExpansionAction(AbstractDisplaySetActionProvider.IDisplaySetProvider iDisplaySetProvider) {
            super(iDisplaySetProvider, KeyImageStudyExpansion.getInstance());
        }

        @Override
        public String getID() {
            return KeyImageExpansionActionProvider.STUDY_EXPANSION_ACTION_ID;
        }

        @Override
        public String getName() {
            return Messages.getString("StudyExpansionAction.Name");
        }

        @Override
        public String getCaption() {
            return Messages.getString("StudyExpansionAction.Caption");
        }

        @Override
        IStudyData getData(IDisplaySet iDisplaySet) {
            return DisplaySetUtils.getStudy(iDisplaySet);
        }
    }
}

