/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.listtext.lta.util.WeakListenerSupport;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.studies.StudyTableController;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.VisScreen2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class OnlyOneStudyManager {
    private static OnlyOneStudyManager instance;
    private static final ALogger LOG;
    private Map<VisScreen2, String> screensToStudies;
    private boolean isRefreshingScreen;
    private WeakListenerSupport<IOnlyOneStudyManagerListener> listenerSupport = new WeakListenerSupport();

    static {
        LOG = ALogger.getLogger(OnlyOneStudyManager.class);
    }

    private OnlyOneStudyManager() {
        this.screensToStudies = new HashMap<VisScreen2, String>(8);
    }

    public static synchronized OnlyOneStudyManager get() {
        if (instance == null) {
            instance = new OnlyOneStudyManager();
        }
        return instance;
    }

    public static IStudyData[] getAllStudiesForScreen(VisScreen2 visScreen2) {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging != null) {
            IStudyContainer iStudyContainer = iHanging.getStudyContainer();
            ArrayList<IStudyData> arrayList = new ArrayList<IStudyData>(StudyTableController.findDisplayedStudies(iStudyContainer.getPatientRepresentation()));
            arrayList.removeIf(iStudyData -> !iStudyContainer.hasStudy(iStudyData.getKey()));
            return arrayList.toArray(new IStudyData[arrayList.size()]);
        }
        return new IStudyData[0];
    }

    public static IStudyData getDefaultStudyForScreen(VisScreen2 visScreen2) {
        List<VisData> list = visScreen2.getVisDatas();
        if (list != null) {
            for (VisData visData : list) {
                if (!visData.isInView() || !visData.isLoaded()) continue;
                return visData.getStudyData();
            }
        }
        return null;
    }

    public String getAllowedStudyUIDOnScreen(VisScreen2 visScreen2) {
        return this.screensToStudies.get(visScreen2);
    }

    public boolean isAllowedOnScreen(VisScreen2 visScreen2, IStudyData iStudyData) {
        return this.isAllowedOnScreen(visScreen2, iStudyData.getStudyInstanceUID());
    }

    public boolean isAllowedOnScreen(VisScreen2 visScreen2, String string) {
        return this.isAllowedOnScreen(visScreen2, string, true);
    }

    public boolean isAllowedOnScreen(VisScreen2 visScreen2, String string, boolean bl) {
        if (this.screensToStudies.containsKey(visScreen2)) {
            String string2 = this.screensToStudies.get(visScreen2);
            if (string2 == null) {
                if (bl) {
                    this.screensToStudies.put(visScreen2, string);
                }
                return true;
            }
            return Objects.equals(string2, string);
        }
        return true;
    }

    public boolean isAllowedOnDisplay(VisDisplay2 visDisplay2, IDisplaySet iDisplaySet) {
        return this.isAllowedOnDisplay(visDisplay2, iDisplaySet, true);
    }

    public boolean isAllowedOnDisplay(VisDisplay2 visDisplay2, IDisplaySet iDisplaySet, boolean bl) {
        return this.isAllowedOnScreen(visDisplay2.getVisScreen(), iDisplaySet.getStudyUID(), bl);
    }

    public boolean isActivatedOnScreen(VisScreen2 visScreen2) {
        return this.screensToStudies.containsKey(visScreen2);
    }

    public boolean activateOnScreen(VisScreen2 visScreen2, IStudyData iStudyData) {
        return this.activateOnScreen(visScreen2, iStudyData != null ? iStudyData.getStudyInstanceUID() : null);
    }

    public boolean activateOnScreen(VisScreen2 visScreen2, String string) {
        if (!this.isRefreshingScreen) {
            String string2 = this.screensToStudies.get(visScreen2);
            if (!this.screensToStudies.containsKey(visScreen2) || !CompareUtils.equals((Object)string2, (Object)string)) {
                this.screensToStudies.put(visScreen2, string);
                this.fireStateChanged();
                return true;
            }
        }
        return false;
    }

    public boolean deactivateOnScreen(VisScreen2 visScreen2) {
        if (this.isActivatedOnScreen(visScreen2)) {
            this.screensToStudies.remove(visScreen2);
            this.fireStateChanged();
            return true;
        }
        return false;
    }

    public boolean deactivateOnAllScreens() {
        if (!this.screensToStudies.isEmpty()) {
            this.screensToStudies.clear();
            this.fireStateChanged();
            return true;
        }
        return false;
    }

    public void purgeScreen(VisScreen2 visScreen2) {
        List<VisDisplay2> list = visScreen2.getAllDisplays();
        for (VisDisplay2 visDisplay2 : list) {
            IDisplaySet iDisplaySet;
            VisDisplayData visDisplayData = visDisplay2.getData();
            if (visDisplayData == null || (iDisplaySet = visDisplayData.getDisplaySet()) == null || this.isAllowedOnDisplay(visDisplay2, iDisplaySet)) continue;
            visDisplay2.clear(false, false);
        }
    }

    public void refreshScreen(VisScreen2 visScreen2) {
        try {
            try {
                this.isRefreshingScreen = true;
                JVision2.getMainFrame().refreshCurrentHangupOnScreen(visScreen2);
            }
            catch (Exception exception) {
                LOG.error(null, (Throwable)exception);
                this.isRefreshingScreen = false;
            }
        }
        finally {
            this.isRefreshingScreen = false;
        }
    }

    public WeakListenerSupport<IOnlyOneStudyManagerListener> getListenerSupport() {
        return this.listenerSupport;
    }

    private void fireStateChanged() {
        for (IOnlyOneStudyManagerListener iOnlyOneStudyManagerListener : this.listenerSupport.getAllListeners()) {
            iOnlyOneStudyManagerListener.stateChanged();
        }
    }

    public static interface IOnlyOneStudyManagerListener {
        public void stateChanged();
    }
}

