/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging;

import com.agfa.pacs.impaxee.data.fetcher.FetcherUtils;
import com.agfa.pacs.impaxee.data.fetcher.IImageDownloadListener;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.listtext.lta.util.WaitingUtil;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameListener;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;

public class WaitForImagesUtil {
    private static final ALogger log = ALogger.getLogger(WaitForImagesUtil.class);

    public static void awaitImages(long l) {
        try {
            WaitForImagesUtil.awaitImagesImpl(l);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            log.warn("Layout change while waiting for available images, repeating ...", (Throwable)concurrentModificationException);
            WaitingUtil.sleep((WaitingUtil.WaitingType)WaitingUtil.WaitingType.OTHER, (long)500L);
            try {
                WaitForImagesUtil.awaitImagesImpl(l);
            }
            catch (ConcurrentModificationException concurrentModificationException2) {
                log.warn("Layout change again while waiting for available images, aborting ...", (Throwable)concurrentModificationException2);
                WaitingUtil.sleep((WaitingUtil.WaitingType)WaitingUtil.WaitingType.OTHER, (long)l);
            }
        }
    }

    public static void awaitImages(VisDisplay2 visDisplay2, long l) {
        if (visDisplay2 == null) {
            return;
        }
        FetcherUtils.prioritizeDownload(visDisplay2.getData().getDisplaySet(), new IImageDownloadListener[0]);
        long l2 = System.currentTimeMillis();
        WaitForImagesUtil.awaitDisplayWithData(Collections.singletonList(visDisplay2), l);
        for (VisData visData : visDisplay2.getVisDatas()) {
            if (WaitForImagesUtil.awaitImage(visData, WaitingUtil.getRemainingWaitingTime((long)l2, (long)l))) continue;
            WaitForImagesUtil.registerFrameListener(visData.getFrameData());
        }
    }

    static boolean areDisplaysEmpty(List<VisDisplay2> list) {
        for (VisDisplay2 visDisplay2 : list == null ? JVision2.getMainFrame().getDisplays() : list) {
            if (!visDisplay2.hasData() || !visDisplay2.getVisViews().stream().anyMatch(Vis2::hasData)) continue;
            return false;
        }
        return true;
    }

    private static void awaitImagesImpl(long l) {
        long l2 = System.currentTimeMillis();
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging != null) {
            WaitForImagesUtil.awaitDisplayWithData(null, l);
        }
        for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
            if (!visDisplay2.hasData()) continue;
            List<Vis2> list = visDisplay2.getVisViews();
            for (Vis2 vis2 : list) {
                if (!vis2.hasData() || WaitForImagesUtil.awaitImage(vis2, WaitingUtil.getRemainingWaitingTime((long)l2, (long)l))) continue;
                WaitForImagesUtil.registerFrameListener(vis2.getView().getFrameData());
            }
        }
    }

    private static boolean awaitImage(VisData visData, long l) {
        return WaitingUtil.waitUntil(visData::isImageAvailable, (WaitingUtil.WaitingType)WaitingUtil.WaitingType.IMAGE_DISPLAY, (long)l);
    }

    public static boolean awaitImage(Vis2 vis2, long l) {
        return WaitingUtil.waitUntil(() -> vis2.getData() != null && vis2.getData().isImageAvailable(), (WaitingUtil.WaitingType)WaitingUtil.WaitingType.IMAGE_DISPLAY, (long)l);
    }

    private static void registerFrameListener(IFrameObjectData iFrameObjectData) {
        if (!log.isDebugEnabled()) {
            return;
        }
        final String string = iFrameObjectData.getKey();
        log.debug("Frame {} not yet available", (Object)string);
        iFrameObjectData.addListener(new IFrameListener(){

            @Override
            public void notifyHasError(String string2) {
                log.debug("Loading frame {} failed: {}", (Object)string, (Object)string2);
            }

            @Override
            public boolean frameAvailable(IFrameObjectData iFrameObjectData, String string2) {
                log.debug("Frame {} loaded successfully", (Object)iFrameObjectData.getKey());
                return false;
            }
        });
    }

    private static boolean awaitDisplayWithData(List<VisDisplay2> list, long l) {
        return WaitingUtil.waitUntil(() -> !WaitForImagesUtil.areDisplaysEmpty(list), (WaitingUtil.WaitingType)WaitingUtil.WaitingType.DISPLAY_INIT, (long)l);
    }
}

