/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.attributes;

import com.agfa.pacs.impaxee.hanging.attributes.AbstractAttributeFilterSubset;
import com.agfa.pacs.impaxee.hanging.attributes.Attr;
import com.agfa.pacs.impaxee.hanging.attributes.AttributeFilterLevel;
import com.agfa.pacs.impaxee.hanging.attributes.Instance;
import com.agfa.pacs.impaxee.hanging.attributes.Patient;
import com.agfa.pacs.impaxee.hanging.attributes.Series;
import com.agfa.pacs.impaxee.hanging.attributes.Study;
import java.util.HashSet;
import java.util.Set;

public class AttributeFilter {
    protected Patient patientAttributes = new Patient();
    protected Study studyAttributes = new Study();
    protected Series seriesAttributes = new Series();
    protected Instance instanceAttributes = new Instance();
    private AbstractAttributeFilterSubset[] attributes = new AbstractAttributeFilterSubset[4];
    private Set<Integer> allAttributes;

    public AttributeFilter() {
        this.attributes[AttributeFilterLevel.PATIENTLEVEL.getIndex()] = this.patientAttributes;
        this.attributes[AttributeFilterLevel.STUDYLEVEL.getIndex()] = this.studyAttributes;
        this.attributes[AttributeFilterLevel.SERIESLEVEL.getIndex()] = this.seriesAttributes;
        this.attributes[AttributeFilterLevel.INSTANCELEVEL.getIndex()] = this.instanceAttributes;
    }

    public boolean isInPatientLevel(int n) {
        return this.patientAttributes.isIn(n);
    }

    public boolean isInStudyLevel(int n) {
        return this.studyAttributes.isIn(n);
    }

    public boolean isInSeriesLevel(int n) {
        return this.seriesAttributes.isIn(n);
    }

    public boolean isInInstanceLevel(int n) {
        return this.instanceAttributes.isIn(n);
    }

    public AbstractAttributeFilterSubset getPatientLevel() {
        return this.patientAttributes;
    }

    public AbstractAttributeFilterSubset getStudyLevel() {
        return this.studyAttributes;
    }

    public AbstractAttributeFilterSubset getSeriesLevel() {
        return this.seriesAttributes;
    }

    public AbstractAttributeFilterSubset getInstanceLevel() {
        return this.instanceAttributes;
    }

    public void addAttribute(AttributeFilterLevel attributeFilterLevel, Attr attr) {
        this.attributes[attributeFilterLevel.getIndex()].addAttr(attr);
    }

    public void addAttributeToPatientLevel(Attr attr) {
        this.patientAttributes.addAttr(attr);
    }

    public void addAttributeToStudyLevel(Attr attr) {
        this.studyAttributes.addAttr(attr);
    }

    public void addAttributeToSeriesLevel(Attr attr) {
        this.seriesAttributes.addAttr(attr);
    }

    public void addAttributeToInstanceLevel(Attr attr) {
        this.instanceAttributes.addAttr(attr);
    }

    public boolean containsTag(int n) {
        if (this.allAttributes == null) {
            this.allAttributes = new HashSet<Integer>();
            this.allAttributes.addAll(this.patientAttributes.getAllContainedTags());
            this.allAttributes.addAll(this.studyAttributes.getAllContainedTags());
            this.allAttributes.addAll(this.seriesAttributes.getAllContainedTags());
            this.allAttributes.addAll(this.instanceAttributes.getAllContainedTags());
        }
        return this.allAttributes.contains(n);
    }
}

