/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTagUtil;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.tiani.util.expressions.OperatorEnum;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class ConditionListEntry
extends JLabel {
    private static Map<String, String> ops = new HashMap<String, String>();
    private static Map<String, String> ops2;
    private static final Map<Pattern, String> htmlEncodings;

    static {
        ops.put(OperatorEnum.EQUAL.getOperator(), Messages.getString("ConditionListEntry.EqualPart1"));
        ops.put(OperatorEnum.LESS_THAN.getOperator(), Messages.getString("ConditionListEntry.LessPart1"));
        ops.put(OperatorEnum.LESS_EQUAL.getOperator(), Messages.getString("ConditionListEntry.EqualOrEqualPart1"));
        ops.put(OperatorEnum.GREATER_THAN.getOperator(), Messages.getString("ConditionListEntry.GreaterPart1"));
        ops.put(OperatorEnum.GREATER_EQUAL.getOperator(), Messages.getString("ConditionListEntry.GreaterEqualPart1"));
        ops.put(OperatorEnum.NOT_EQUAL.getOperator(), Messages.getString("ConditionListEntry.NotEqualPart1"));
        ops.put(OperatorEnum.CONTAINS.getOperator(), Messages.getString("ConditionListEntry.ContainslPart1"));
        ops.put(OperatorEnum.DOESNOTCONTAIN.getOperator(), Messages.getString("ConditionListEntry.DoesNotContainPart1"));
        ops.put(OperatorEnum.STARTSWITH.getOperator(), Messages.getString("ConditionListEntry.StartsWithPart1"));
        ops.put(OperatorEnum.ENDSWITH.getOperator(), Messages.getString("ConditionListEntry.EndsWithPart1"));
        ops.put(OperatorEnum.ISONEOF.getOperator(), Messages.getString("ConditionListEntry.IsOneOfPart1"));
        ops.put(OperatorEnum.ISNONEOF.getOperator(), Messages.getString("ConditionListEntry.IsNoneOfPart1"));
        ops.put(OperatorEnum.INCLUDESONEOF.getOperator(), Messages.getString("ConditionListEntry.IncludesOneOfPart1"));
        ops.put(OperatorEnum.HASPOSITIONFROMMAX.getOperator(), Messages.getString("ConditionListEntry.HasPositionFromMaxPart1"));
        ops.put(OperatorEnum.HASPOSITIONFROMMIN.getOperator(), Messages.getString("ConditionListEntry.HasPositionFromMinPart1"));
        ops.put(OperatorEnum.ISMAXIN.getOperator(), Messages.getString("ConditionListEntry.IsMaxInPart1"));
        ops.put(OperatorEnum.ISMININ.getOperator(), Messages.getString("ConditionListEntry.IsMinInPart1"));
        ops.put(OperatorEnum.ISENHANCED.getOperator(), "");
        ops2 = new HashMap<String, String>();
        ops2.put(OperatorEnum.EQUAL.getOperator(), Messages.getString("ConditionListEntry.EqualPart2"));
        ops2.put(OperatorEnum.LESS_THAN.getOperator(), Messages.getString("ConditionListEntry.LessPart2"));
        ops2.put(OperatorEnum.LESS_EQUAL.getOperator(), Messages.getString("ConditionListEntry.LessEqualPart2"));
        ops2.put(OperatorEnum.GREATER_THAN.getOperator(), Messages.getString("ConditionListEntry.GreaterPart2"));
        ops2.put(OperatorEnum.GREATER_EQUAL.getOperator(), Messages.getString("ConditionListEntry.GreaterEqualPart2"));
        ops2.put(OperatorEnum.NOT_EQUAL.getOperator(), Messages.getString("ConditionListEntry.NotEqualPart2"));
        ops2.put(OperatorEnum.CONTAINS.getOperator(), Messages.getString("ConditionListEntry.ContainsPart2"));
        ops2.put(OperatorEnum.DOESNOTCONTAIN.getOperator(), Messages.getString("ConditionListEntry.DoesNotContainPart2"));
        ops2.put(OperatorEnum.STARTSWITH.getOperator(), Messages.getString("ConditionListEntry.StartsWithPart2"));
        ops2.put(OperatorEnum.ENDSWITH.getOperator(), Messages.getString("ConditionListEntry.EndsWithPart2"));
        ops2.put(OperatorEnum.ISONEOF.getOperator(), Messages.getString("ConditionListEntry.IsOneOfPart2"));
        ops2.put(OperatorEnum.ISNONEOF.getOperator(), Messages.getString("ConditionListEntry.IsNoneOfPart2"));
        ops2.put(OperatorEnum.INCLUDESONEOF.getOperator(), Messages.getString("ConditionListEntry.IncludesOneOfPart2"));
        ops2.put(OperatorEnum.HASPOSITIONFROMMAX.getOperator(), Messages.getString("ConditionListEntry.HasPositionFromMaxPart2"));
        ops2.put(OperatorEnum.HASPOSITIONFROMMIN.getOperator(), Messages.getString("ConditionListEntry.HasPositionFromMinPart2"));
        ops2.put(OperatorEnum.ISMAXIN.getOperator(), Messages.getString("ConditionListEntry.IsMaxInPart2"));
        ops2.put(OperatorEnum.ISMININ.getOperator(), Messages.getString("ConditionListEntry.IsMinInPart2"));
        ops2.put(OperatorEnum.ISENHANCED.getOperator(), Messages.getString("ConditionListEntry.IsEnhanced2"));
        htmlEncodings = new HashMap<Pattern, String>();
        htmlEncodings.put(Pattern.compile("\\<"), "&lt;");
        htmlEncodings.put(Pattern.compile("\\>"), "&gt;");
    }

    public ConditionListEntry(Condition condition) {
        this(condition, ComponentFactory.instance);
    }

    public ConditionListEntry(Condition condition, IComponentFactory iComponentFactory) {
        this.setOpaque(true);
        this.setText(ConditionListEntry.formString(condition));
        if (iComponentFactory != null) {
            iComponentFactory.scaleLabel((JLabel)this);
        } else {
            ComponentFactory.instance.scaleLabel(this);
        }
    }

    public ConditionListEntry(Condition condition, Icon icon, IComponentFactory iComponentFactory) {
        super(icon, 2);
        this.setOpaque(true);
        this.setText(ConditionListEntry.formString(condition));
        if (iComponentFactory != null) {
            iComponentFactory.scaleLabel((JLabel)this);
        } else {
            ComponentFactory.instance.scaleLabel(this);
        }
    }

    public ConditionListEntry(Condition condition, Icon icon) {
        this(condition, icon, null);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setForeground(bl ? (Color)UIManager.get("Label.foreground") : (Color)UIManager.get("Label.disabledForeground"));
    }

    public static String formString(Condition condition) {
        OperatorEnum operatorEnum = condition.getOperator();
        if (operatorEnum.isUnary()) {
            return "<html>" + ops.get(operatorEnum.getOperator().toUpperCase()) + " \"<b>" + ConditionListEntry.getTagString(condition) + "</b>\" " + ops2.get(operatorEnum.getOperator().toUpperCase()) + "</html>";
        }
        return "<html><b>" + ConditionListEntry.getTagString(condition) + "</b> " + ops.get(operatorEnum.getOperator().toUpperCase()) + " \"<b>" + ConditionListEntry.encodeForHtml(condition.getValue()) + "</b>\" " + ops2.get(operatorEnum.getOperator().toUpperCase()) + "</html>";
    }

    public static String getPlainString(Condition condition) {
        OperatorEnum operatorEnum = condition.getOperator();
        if (operatorEnum.isUnary()) {
            return String.valueOf(ops.get(operatorEnum.getOperator().toUpperCase())) + " " + ConditionListEntry.getTagString(condition) + " " + ops2.get(operatorEnum.getOperator().toUpperCase());
        }
        return String.valueOf(ConditionListEntry.getTagString(condition)) + " " + ops.get(operatorEnum.getOperator().toUpperCase()) + " " + condition.getValue() + " " + ops2.get(operatorEnum.getOperator().toUpperCase());
    }

    public static String formStringWithoutHTMLTag(Condition condition) {
        if (condition == null) {
            return "";
        }
        OperatorEnum operatorEnum = condition.getOperator();
        if (operatorEnum.isUnary()) {
            return String.valueOf(ops.get(operatorEnum.getOperator().toUpperCase())) + " \"<b>" + ConditionListEntry.getTagString(condition) + "</b>\" " + ops2.get(operatorEnum.getOperator().toUpperCase()) + "</html>";
        }
        return "<b>" + ConditionListEntry.getTagString(condition) + "</b> " + ops.get(operatorEnum.getOperator().toUpperCase()) + " \"<b>" + ConditionListEntry.encodeForHtml(condition.getValue()) + "</b>\" " + ops2.get(operatorEnum.getOperator().toUpperCase());
    }

    private static String getTagString(Condition condition) {
        String string;
        if (condition.getTag() == null) {
            string = Messages.getString("ConditionListEntry.NoTagNumber");
        } else {
            String string2;
            String string3;
            String string4 = DicomTagUtil.getDicomGroupAsHex((Integer)condition.getTag());
            String string5 = DicomTagUtil.getDicomElementAsHex((Integer)condition.getTag());
            string = Integer.valueOf(string4, 16) % 2 == 0 ? ((string3 = TagDictionary.getInstance().descriptionForTag(condition.getTag().intValue())) != null ? string3 : String.valueOf(Messages.getString("ConditionListEntry.UnknownTag")) + " (" + string4 + "," + string5 + ")") : ((string2 = TagDictionary.getInstance().getPrivateTagDictionary().descriptionForTag(condition.getTag().intValue())) != null ? string2 : String.valueOf(Messages.getString("ConditionListEntry.UnknownPrivateTag")) + " (" + string4 + "," + string5 + ")");
        }
        return string;
    }

    private static String encodeForHtml(String string) {
        String string2 = string;
        for (Map.Entry<Pattern, String> entry : htmlEncodings.entrySet()) {
            string2 = entry.getKey().matcher(string2).replaceAll(entry.getValue());
        }
        return string2;
    }
}

