/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ActivationStateTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.CreateAbstractConditionPanel;
import com.agfa.pacs.impaxee.model.xml.shared.INamedElement;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTreeNode
extends ActivationStateTreeNode {
    private int conditionNumber = 1;
    private List<String> conditionNames = new ArrayList<String>();
    private List<CreateAbstractConditionPanel> conditionPanels = new ArrayList<CreateAbstractConditionPanel>();

    public AbstractTreeNode(IComponentFactory iComponentFactory) {
        super(iComponentFactory);
    }

    @Override
    public abstract JPanel getPanel();

    void addCondition(INamedElement iNamedElement, JTabbedPane jTabbedPane, CreateAbstractConditionPanel createAbstractConditionPanel) {
        this.conditionPanels.add(createAbstractConditionPanel);
        String string = iNamedElement.getName();
        if (StringUtils.isEmpty((CharSequence)string)) {
            string = String.valueOf(Messages.getString("Condition.Rule")) + ' ' + this.conditionNumber;
            ++this.conditionNumber;
            iNamedElement.setName(string);
        }
        jTabbedPane.add((Component)createAbstractConditionPanel, string);
        jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
        this.conditionNames.add(string);
    }

    void deleteCondition(int n, JTabbedPane jTabbedPane) {
        CreateAbstractConditionPanel createAbstractConditionPanel = (CreateAbstractConditionPanel)jTabbedPane.getComponentAt(n);
        createAbstractConditionPanel.deregisterListener();
        jTabbedPane.remove(n);
        this.conditionNames.remove(n);
    }

    boolean isNameAllowedForCondition(String string) {
        if (StringUtils.isEmpty((CharSequence)string) || StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        for (String string2 : this.conditionNames) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return false;
        }
        return true;
    }
}

