/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.hanging.gui.advanced.HangingProtocolWarningIconFactory;
import com.agfa.pacs.impaxee.hanging.gui.advanced.IActivationStateTreeListener;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public abstract class ActivationStateTreeNode
extends DefaultMutableTreeNode {
    protected IComponentFactory componentFactory;
    protected Window parentWindow;
    private boolean isActive = true;
    protected DefaultTreeModel model;
    private final HangingProtocolWarningIconFactory iconFactory;
    protected Icon currentIcon = null;
    private boolean hasErrorSelf;
    private boolean hasWarningSelf;
    private boolean hasErrorInChilds;
    private boolean hasWarningInChilds;
    private List<String> errorMessagesSelf = new ArrayList<String>(1);
    private List<String> warningMessagesSelf = new ArrayList<String>(1);
    private Collection<String> errorMessagesInChilds = new LinkedHashSet<String>();
    private Collection<String> warningMessagesInChilds = new LinkedHashSet<String>();
    private List<IActivationStateTreeListener> activationListener = new ArrayList<IActivationStateTreeListener>(2);

    protected ActivationStateTreeNode(IComponentFactory iComponentFactory) {
        this.componentFactory = iComponentFactory;
        this.iconFactory = new HangingProtocolWarningIconFactory(iComponentFactory);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean bl) {
        if (this.isActive != bl) {
            this.isActive = bl;
            for (IActivationStateTreeListener iActivationStateTreeListener : this.activationListener) {
                iActivationStateTreeListener.activationChanged(this);
            }
        }
    }

    public abstract JPanel getPanel();

    @Override
    public void add(MutableTreeNode mutableTreeNode) {
        super.add(mutableTreeNode);
    }

    public void setModel(DefaultTreeModel defaultTreeModel) {
        this.model = defaultTreeModel;
        if (this.children != null) {
            for (Object e : this.children) {
                if (!(e instanceof ActivationStateTreeNode)) continue;
                ((ActivationStateTreeNode)e).setModel(defaultTreeModel);
            }
        }
    }

    public Icon getIcon() {
        return this.currentIcon;
    }

    protected void setHasErrorSelf(boolean bl) {
        if (this.hasErrorSelf != bl) {
            this.hasErrorSelf = bl;
            if (this.getParent() instanceof ActivationStateTreeNode) {
                ((ActivationStateTreeNode)this.getParent()).validStateChanged();
            }
            this.ensureRightIcon();
        }
    }

    protected void setErrorMessagesSelf(List<String> list) {
        this.errorMessagesSelf = list;
    }

    protected void setWarningMessagesSelf(List<String> list) {
        this.warningMessagesSelf = list;
    }

    private void setHasErrorInChilds(boolean bl) {
        if (this.hasErrorInChilds != bl) {
            this.hasErrorInChilds = bl;
            if (this.getParent() instanceof ActivationStateTreeNode) {
                ((ActivationStateTreeNode)this.getParent()).validStateChanged();
            }
            this.ensureRightIcon();
        }
    }

    public boolean getHasError() {
        return this.hasErrorSelf || this.hasErrorInChilds;
    }

    protected void setHasWarningSelf(boolean bl) {
        if (this.hasWarningSelf != bl) {
            this.hasWarningSelf = bl;
            if (this.getParent() instanceof ActivationStateTreeNode) {
                ((ActivationStateTreeNode)this.getParent()).validStateChanged();
            }
            this.ensureRightIcon();
        }
    }

    private void setHasWarningInChilds(boolean bl) {
        if (this.hasWarningInChilds != bl) {
            this.hasWarningInChilds = bl;
            if (this.getParent() instanceof ActivationStateTreeNode) {
                ((ActivationStateTreeNode)this.getParent()).validStateChanged();
            }
            this.ensureRightIcon();
        }
    }

    private boolean getHasWarning() {
        return this.hasWarningSelf || this.hasWarningInChilds;
    }

    public Collection<String> getWarningMessages() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.warningMessagesSelf);
        linkedHashSet.addAll(this.warningMessagesInChilds);
        return linkedHashSet;
    }

    public Collection<String> getErrorMessages() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.errorMessagesSelf);
        linkedHashSet.addAll(this.errorMessagesInChilds);
        return linkedHashSet;
    }

    protected void validStateChanged() {
        boolean bl = false;
        boolean bl2 = false;
        this.errorMessagesInChilds.clear();
        this.warningMessagesInChilds.clear();
        if (this.children != null) {
            for (Object e : this.children) {
                if (!(e instanceof ActivationStateTreeNode)) continue;
                bl |= ((ActivationStateTreeNode)e).getHasError();
                bl2 |= ((ActivationStateTreeNode)e).getHasWarning();
                this.errorMessagesInChilds.addAll(((ActivationStateTreeNode)e).getErrorMessages());
                this.warningMessagesInChilds.addAll(((ActivationStateTreeNode)e).getWarningMessages());
            }
        }
        this.setHasErrorInChilds(bl);
        this.setHasWarningInChilds(bl2);
    }

    private void ensureRightIcon() {
        Icon icon = this.currentIcon;
        this.currentIcon = this.iconFactory.getIcon(this.getHasError(), this.getHasWarning());
        if (icon != this.currentIcon && this.model != null) {
            this.model.nodeChanged(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
        if (mutableTreeNode instanceof ActivationStateTreeNode) {
            this.validStateChanged();
        }
    }

    public void addActivationStateTreeListener(IActivationStateTreeListener iActivationStateTreeListener) {
        if (!this.activationListener.contains(iActivationStateTreeListener)) {
            this.activationListener.add(iActivationStateTreeListener);
        }
    }

    public boolean removeActivationStateTreeListener(IActivationStateTreeListener iActivationStateTreeListener) {
        return this.activationListener.remove(iActivationStateTreeListener);
    }

    public void deregisterListeners() {
        if (this.children != null) {
            for (Object e : this.children) {
                if (!(e instanceof ActivationStateTreeNode)) continue;
                ((ActivationStateTreeNode)e).deregisterListeners();
            }
        }
    }
}

