/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.ui.DropDownButton;
import com.agfa.pacs.impaxee.actions.ui.LayoutChooserPopupMenu;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IHangingProtocolManipulationListener;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ScreenSettingsPanel;
import com.agfa.pacs.impaxee.hanging.gui.advanced.SnapshotSettingsPanel;
import com.agfa.pacs.impaxee.hanging.model.DisplayState;
import com.agfa.pacs.impaxee.hanging.model.IDisplayLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.IDisplayState;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.enums.PrimaryDimension;
import com.agfa.pacs.impaxee.hanging.model.enums.ThickMode;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.toptoolbar.FilterActions;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;

public class DisplaySettingsPanel
extends JPanel {
    private JToggleButton[] displayLayoutButtons;
    private JToggleButton[] filmLayoutButtons;
    private final Icon[] variableLayoutIcons;
    private final Icon[] filmLayoutIcons;
    private static String[] variableLayouts = new String[]{"1x1", "1x2", "2x1", "2x2"};
    private static String[] filmLayouts = new String[]{"1x1", "2x2", "3x3", "4x4", "5x5", "6x6", "7x7", "8x8"};
    private static int[] degrees;
    private static String[] degreeCaptions;
    private static int[] pixelZoomFactors;
    private static String[] pixelZoomFactorCaptions;
    private static int[] zfr;
    private Vector<PresentationSizeModeWrapper> wrappers = new Vector();
    private ButtonGroup buttonGroupDisplayLayout;
    private ButtonGroup buttonGroupFilmLayout;
    private JComboBox<PluginName> comboBoxPlugin;
    private final JComboBox<FilterActions.FilterType> comboBoxFilter;
    private IDisplayLayoutDefinition displayLayout;
    private IDisplayState displayState;
    private JPanel panelDisplayLayoutButtons;
    private JPanel panelFilmLayoutButtons;
    private JPanel panelStripeLayout;
    private JPanel leftPanel;
    private JLabel labelStripeColsInfo;
    private MainLayoutType screenLayoutType;
    private JComboBox<KeyImageOverviewType> keyImageOverviewCBox;
    private JComboBox<PresentationSizeModeWrapper> comboBoxPresentationSizeMode;
    private JComboBox<ThickMode> comboBoxEMPRMode;
    private JFormattedTextField formattedTextFieldZoomFactor;
    private JFormattedTextField formattedEMPRThickness;
    private JComboBox<String> comboBoxRotation;
    private JCheckBox checkBoxHorizontalFlip;
    private JCheckBox checkBoxSynced;
    private JCheckBox checkBoxInverted;
    private final JCheckBox checkBoxLocalizer;
    private DropDownButton displayLayoutDropdown;
    private JFormattedTextField formattedTextWindowCenter;
    private JFormattedTextField formattedTextWindowWidth;
    private JComboBox<String> comboBoxPixelZoomFactors;
    private JSlider sliderScrollingPosition;
    private final JCheckBox jumpToFirstKeyImage;
    private JCheckBox checkBoxStoreWindowLevel;
    private JLabel labelWindowCenter;
    private JLabel labelWindowWidth;
    private JSpinner spinner4DNavigationPosition;
    private JComboBox<String> comboBox4DNavigationOrder;
    private static final String[] NAVIGATION_ORDER;
    private JComboBox<PrimaryDimensionWrapper> comboBox4DPrimaryDimension;
    private List<PrimaryDimensionWrapper> primaryDimensionWrappers = new ArrayList<PrimaryDimensionWrapper>();
    private double currentScrollingPosition;
    private IHangingProtocolManipulationListener listener;

    static {
        int[] nArray = new int[4];
        nArray[1] = 90;
        nArray[2] = 180;
        nArray[3] = 270;
        degrees = nArray;
        degreeCaptions = new String[]{"0\u00b0", "90\u00b0", "180\u00b0", "270\u00b0"};
        pixelZoomFactors = new int[]{1, 2, 4, 8};
        pixelZoomFactorCaptions = new String[]{"1x", "2x", "4x", "8x"};
        int[] nArray2 = new int[9];
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 2;
        nArray2[5] = 2;
        nArray2[6] = 2;
        nArray2[7] = 3;
        nArray2[8] = 3;
        zfr = nArray2;
        NAVIGATION_ORDER = new String[]{Messages.getString("DisplaySettingsPanel.4DFromTheFront"), Messages.getString("DisplaySettingsPanel.4DFromBehind")};
    }

    public DisplaySettingsPanel(MainLayoutType mainLayoutType, IDisplayLayoutDefinition iDisplayLayoutDefinition, IComponentFactory iComponentFactory, IHangingProtocolManipulationListener iHangingProtocolManipulationListener) {
        Object object;
        this.displayLayout = iDisplayLayoutDefinition;
        this.displayState = iDisplayLayoutDefinition.getDisplayState();
        this.listener = iHangingProtocolManipulationListener;
        if (this.displayState == null) {
            this.displayState = new DisplayState();
        }
        this.screenLayoutType = mainLayoutType;
        this.setOpaque(false);
        this.setBorder(iComponentFactory.createTitledBorder(Messages.getString("DisplaySettingsPanel.DisplaySettings")));
        this.setLayout(new BorderLayout());
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -2.0, -2.0}, new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0});
        tableLayout.setVGap(10);
        tableLayout.setHGap(40);
        this.leftPanel = iComponentFactory.createPanel((LayoutManager)tableLayout);
        this.panelDisplayLayoutButtons = ComponentFactory.instance.createPanel(new GridLayout(1, variableLayouts.length, 0, 0));
        this.panelFilmLayoutButtons = ComponentFactory.instance.createPanel(new GridLayout(2, filmLayouts.length / 2, 0, 0));
        this.panelStripeLayout = ComponentFactory.instance.createPanel(new BorderLayout());
        this.labelStripeColsInfo = iComponentFactory.createLabel("");
        this.panelStripeLayout.add(this.labelStripeColsInfo);
        IAIconFactory iAIconFactory = new IAIconFactory(iComponentFactory, 32);
        this.variableLayoutIcons = new Icon[variableLayouts.length];
        int n = 0;
        while (n < variableLayouts.length) {
            this.variableLayoutIcons[n] = iAIconFactory.loadIcon("icon_display_layout_" + variableLayouts[n] + ".svg");
            ++n;
        }
        this.filmLayoutIcons = new Icon[filmLayouts.length];
        n = 0;
        while (n < filmLayouts.length) {
            this.filmLayoutIcons[n] = iAIconFactory.loadIcon("icon_film_layout_" + filmLayouts[n] + ".svg");
            ++n;
        }
        this.displayLayoutButtons = new JToggleButton[this.variableLayoutIcons.length];
        this.filmLayoutButtons = new JToggleButton[this.filmLayoutIcons.length];
        this.buttonGroupDisplayLayout = new ButtonGroup();
        this.buttonGroupFilmLayout = new ButtonGroup();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplaySettingsPanel.this.storeHorizontalXVertical();
            }
        };
        int n2 = 0;
        while (n2 < this.variableLayoutIcons.length) {
            this.displayLayoutButtons[n2] = SnapshotSettingsPanel.createToggleButtonWithScaledIcon(iComponentFactory, this.variableLayoutIcons[n2]);
            this.buttonGroupDisplayLayout.add(this.displayLayoutButtons[n2]);
            this.panelDisplayLayoutButtons.add(this.displayLayoutButtons[n2]);
            this.displayLayoutButtons[n2].addActionListener(actionListener);
            ++n2;
        }
        this.displayLayoutDropdown = new DropDownButton("", null, LayoutChooserPopupMenu.createPopupMenu(new LayoutChooserPopupMenu.ILayoutSelectionHandler(){

            @Override
            public void layoutSelected(LayoutChooserPopupMenu.ILayoutSelectionSource iLayoutSelectionSource) {
                DisplaySettingsPanel.this.displayLayoutDropdown.setText(iLayoutSelectionSource.toLayoutString());
                DisplaySettingsPanel.this.storeHorizontalXVertical();
            }
        }), DropDownButton.Orientation.bottom);
        this.panelDisplayLayoutButtons.add(this.displayLayoutDropdown);
        this.displayLayoutDropdown.setPreferredSize(new Dimension(GUI.getScaledInt((int)100), (int)this.displayLayoutButtons[0].getPreferredSize().getHeight()));
        this.displayLayoutDropdown.setIcon((Icon)iAIconFactory.loadIcon("layout-configuration.svg"));
        n2 = 0;
        while (n2 < this.filmLayoutIcons.length) {
            this.filmLayoutButtons[n2] = SnapshotSettingsPanel.createToggleButtonWithScaledIcon(iComponentFactory, this.filmLayoutIcons[n2]);
            this.buttonGroupFilmLayout.add(this.filmLayoutButtons[n2]);
            this.panelFilmLayoutButtons.add(this.filmLayoutButtons[n2]);
            this.filmLayoutButtons[n2].addActionListener(actionListener);
            ++n2;
        }
        this.panelDisplayLayoutButtons.setAlignmentX(0.0f);
        this.comboBoxPlugin = iComponentFactory.createComboBox((Object[])PluginName.pluginValues());
        this.comboBoxFilter = iComponentFactory.createComboBox((Object[])FilterActions.FilterType.values());
        Object object2 = ZoomMode.values();
        int n3 = ((ZoomMode[])object2).length;
        int n4 = 0;
        while (n4 < n3) {
            ZoomMode zoomMode = object2[n4];
            this.wrappers.add(new PresentationSizeModeWrapper(zoomMode));
            ++n4;
        }
        this.comboBoxPresentationSizeMode = iComponentFactory.createComboBox(this.wrappers);
        this.comboBoxPresentationSizeMode.setSelectedIndex(-1);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(3);
        this.formattedTextFieldZoomFactor = iComponentFactory.createFormattedTextField((Format)numberFormat);
        Dimension dimension = this.formattedTextFieldZoomFactor.getPreferredSize();
        dimension.width = iComponentFactory.scaleInt(50);
        this.formattedTextFieldZoomFactor.setPreferredSize(dimension);
        this.comboBoxPixelZoomFactors = iComponentFactory.createComboBox((Object[])pixelZoomFactorCaptions);
        dimension = this.comboBoxPixelZoomFactors.getPreferredSize();
        dimension.width = iComponentFactory.scaleInt(60);
        this.comboBoxPixelZoomFactors.setPreferredSize(dimension);
        NumberFormat numberFormat2 = NumberFormat.getNumberInstance();
        numberFormat2.setMaximumFractionDigits(1);
        this.formattedEMPRThickness = iComponentFactory.createFormattedTextField((Format)numberFormat2);
        this.comboBoxEMPRMode = iComponentFactory.createComboBox((Object[])ThickMode.values());
        dimension = this.formattedEMPRThickness.getPreferredSize();
        dimension.width = iComponentFactory.scaleInt(60);
        this.formattedEMPRThickness.setPreferredSize(dimension);
        dimension = this.comboBoxEMPRMode.getPreferredSize();
        dimension.width = iComponentFactory.scaleInt(60);
        this.comboBoxEMPRMode.setPreferredSize(dimension);
        this.comboBoxRotation = iComponentFactory.createComboBox((Object[])degreeCaptions);
        this.checkBoxHorizontalFlip = iComponentFactory.createCheckBox(Messages.getString("DisplaySettingsPanel.HorizontalFlip"));
        this.checkBoxSynced = iComponentFactory.createCheckBox(Messages.getString("DisplaySettingsPanel.Synchronized"));
        this.checkBoxInverted = iComponentFactory.createCheckBox(Messages.getString("DisplaySettingsPanel.Inverted"));
        this.checkBoxLocalizer = iComponentFactory.createCheckBox(Messages.getString("DisplaySettingsPanel.Localizer"));
        object2 = NumberFormat.getNumberInstance();
        ((NumberFormat)object2).setMaximumFractionDigits(6);
        this.formattedTextWindowCenter = iComponentFactory.createFormattedTextField((Format)new EmptyStringNumberFormatter((Format)object2));
        this.formattedTextWindowWidth = iComponentFactory.createFormattedTextField((Format)new EmptyStringNumberFormatter((Format)object2));
        dimension = this.formattedTextWindowCenter.getPreferredSize();
        dimension.width = iComponentFactory.scaleInt(60);
        this.formattedTextWindowCenter.setPreferredSize(dimension);
        dimension = this.formattedTextWindowWidth.getPreferredSize();
        dimension.width = iComponentFactory.scaleInt(60);
        this.formattedTextWindowWidth.setPreferredSize(dimension);
        this.labelWindowCenter = iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.WindowCenter")) + ":");
        this.labelWindowWidth = iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.WindowWidth")) + ":");
        this.checkBoxStoreWindowLevel = iComponentFactory.createCheckBox(Messages.getString("EditDisplaysetConditionAndSimpleDisplayStatePanel.UseWindowLevel"), Messages.getString("EditDisplaysetConditionAndSimpleDisplayStatePanel.UseWindowLevelToolTip"));
        this.sliderScrollingPosition = iComponentFactory.createSlider(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(100), Integer.valueOf(0));
        this.sliderScrollingPosition.setMajorTickSpacing(25);
        this.sliderScrollingPosition.setPaintLabels(true);
        this.sliderScrollingPosition.setPaintTicks(true);
        this.sliderScrollingPosition.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = DisplaySettingsPanel.this.sliderScrollingPosition.getValue();
                DisplaySettingsPanel.this.currentScrollingPosition = (double)n / 100.0;
            }
        });
        this.jumpToFirstKeyImage = iComponentFactory.createCheckBox(Messages.getString("DisplaySettingsPanel.JumpToFirstKeyImage"));
        this.keyImageOverviewCBox = iComponentFactory.createComboBox((Object[])KeyImageOverviewType.values());
        this.comboBox4DNavigationOrder = iComponentFactory.createComboBox((Object[])NAVIGATION_ORDER);
        TableLayout tableLayout2 = PrimaryDimension.values();
        int n5 = ((PrimaryDimension[])tableLayout2).length;
        int n6 = 0;
        while (n6 < n5) {
            object = tableLayout2[n6];
            this.primaryDimensionWrappers.add(new PrimaryDimensionWrapper((PrimaryDimension)((Object)object)));
            ++n6;
        }
        this.comboBox4DPrimaryDimension = iComponentFactory.createComboBox((Object[])this.primaryDimensionWrappers.toArray(new PrimaryDimensionWrapper[0]));
        object = this.comboBox4DNavigationOrder.getPreferredSize();
        this.comboBox4DNavigationOrder.setPreferredSize(new Dimension((int)(((Dimension)object).getWidth() + (double)GUI.getScaledDiagnosticInt((int)20)), (int)((Dimension)object).getHeight()));
        object = this.comboBox4DPrimaryDimension.getPreferredSize();
        this.comboBox4DPrimaryDimension.setPreferredSize(new Dimension((int)(((Dimension)object).getWidth() + (double)GUI.getScaledDiagnosticInt((int)20)), (int)((Dimension)object).getHeight()));
        this.leftPanel.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.Layout")) + ":"), "0,0");
        this.leftPanel.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.Plugin")) + ":"), "0,1");
        this.leftPanel.add(this.comboBoxPlugin, "1,1");
        this.leftPanel.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.Filter")) + ":"), "0,2");
        this.leftPanel.add(this.comboBoxFilter, "1,2");
        this.leftPanel.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.EMPRMode")) + ":"), "0,3");
        this.leftPanel.add(this.comboBoxEMPRMode, "1,3");
        this.leftPanel.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.EMPRThickness")) + " (mm):"), "0,4");
        this.leftPanel.add((Component)this.formattedEMPRThickness, "1,4");
        this.leftPanel.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.Rotation")) + ":"), "0,5");
        this.leftPanel.add(this.comboBoxRotation, "1,5");
        TableLayout tableLayout3 = new TableLayout(new double[]{-2.0, -2.0}, new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0});
        tableLayout3.setHGap(20);
        tableLayout3.setVGap(10);
        JPanel jPanel = iComponentFactory.createPanel((LayoutManager)tableLayout3);
        jPanel.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.ZoomMode")) + ":"), "0,0");
        jPanel.add(this.comboBoxPresentationSizeMode, "1,0");
        jPanel.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.MagnificationRatio")) + ":"), "0,1");
        jPanel.add((Component)this.formattedTextFieldZoomFactor, "1,1");
        jPanel.add(this.comboBoxPixelZoomFactors, "1,1");
        jPanel.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.KeyImageOverview")) + ":"), "0,2");
        jPanel.add(this.keyImageOverviewCBox, "1,2");
        jPanel.add((Component)this.checkBoxStoreWindowLevel, "0,3");
        jPanel.add((Component)this.labelWindowCenter, "0,4");
        jPanel.add((Component)this.formattedTextWindowCenter, "1,4");
        jPanel.add((Component)this.labelWindowWidth, "0,5");
        jPanel.add((Component)this.formattedTextWindowWidth, "1,5");
        tableLayout2 = new TableLayout(new double[]{-2.0, -2.0}, new double[]{-2.0});
        tableLayout2.setHGap(50);
        JPanel jPanel2 = iComponentFactory.createPanel((LayoutManager)tableLayout2);
        jPanel2.add((Component)this.leftPanel, "0,0");
        jPanel2.add((Component)jPanel, "1,0");
        TableLayout tableLayout4 = new TableLayout(new double[]{-2.0, -2.0, -2.0, -2.0}, new double[]{-2.0});
        tableLayout4.setHGap(30);
        JPanel jPanel3 = iComponentFactory.createPanel((LayoutManager)tableLayout4);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 0, 5, 0));
        jPanel3.add((Component)this.checkBoxHorizontalFlip, "0,0");
        jPanel3.add((Component)this.checkBoxSynced, "1,0");
        jPanel3.add((Component)this.checkBoxInverted, "2,0");
        jPanel3.add((Component)this.checkBoxLocalizer, "3,0");
        TableLayout tableLayout5 = new TableLayout(new double[]{-2.0, -1.0}, new double[]{-2.0, -2.0, -2.0, -2.0, -2.0});
        tableLayout5.setVGap(10);
        tableLayout5.setHGap(20);
        JPanel jPanel4 = iComponentFactory.createPanel((LayoutManager)tableLayout5);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel4.add((Component)jPanel2, "0,0,1,0");
        jPanel4.add((Component)jPanel3, "0,1,1,1");
        jPanel4.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.ScrollingPosition")) + ":"), "0,2");
        jPanel4.add((Component)this.sliderScrollingPosition, "1,2");
        jPanel4.add((Component)this.jumpToFirstKeyImage, "1,3");
        TableLayout tableLayout6 = new TableLayout(new double[]{-2.0, -2.0, -2.0, -2.0, -2.0}, new double[]{-2.0});
        tableLayout6.setHGap(10);
        JPanel jPanel5 = iComponentFactory.createPanel((LayoutManager)tableLayout6);
        this.spinner4DNavigationPosition = iComponentFactory.createSpinner((SpinnerModel)new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        jPanel5.add((Component)iComponentFactory.createLabel(Messages.getString("DisplaySettingsPanel.4DNavigationPosition")), "0,0");
        jPanel5.add((Component)this.spinner4DNavigationPosition, "1,0");
        jPanel5.add(this.comboBox4DNavigationOrder, "2,0");
        jPanel5.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.4DPrimaryDimension")) + ':'), "3,0");
        jPanel5.add(this.comboBox4DPrimaryDimension, "4,0");
        jPanel4.add((Component)iComponentFactory.createLabel(String.valueOf(Messages.getString("DisplaySettingsPanel.4DInitialDisplay")) + ':'), "0,4");
        jPanel4.add((Component)jPanel5, "1,4");
        this.ensureSamePreferredSize(this.comboBoxPlugin, this.comboBoxPresentationSizeMode);
        this.add((Component)jPanel4, "Center");
        this.init(iDisplayLayoutDefinition);
        this.registerListeners();
        this.showProperInputComponentForZoomFactor();
    }

    private void ensureSamePreferredSize(JComponent jComponent, JComponent jComponent2) {
        Dimension dimension = jComponent.getPreferredSize();
        Dimension dimension2 = jComponent2.getPreferredSize();
        int n = Math.max(dimension.height, dimension2.height);
        int n2 = Math.max(dimension.width, dimension2.width);
        jComponent.setPreferredSize(new Dimension(n2, n));
        jComponent2.setPreferredSize(new Dimension(n2, n));
    }

    private void registerListeners() {
        this.comboBoxPresentationSizeMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DisplaySettingsPanel.this.showProperInputComponentForZoomFactor();
                DisplaySettingsPanel.this.storeZoomMode();
            }
        });
        this.formattedTextFieldZoomFactor.addPropertyChangeListener("value", propertyChangeEvent -> this.storeZoomMode());
        this.comboBoxPlugin.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DisplaySettingsPanel.this.storePluginName();
                DisplaySettingsPanel.this.enableDisplayStateComponents(DisplaySettingsPanel.this.comboBoxPlugin.getSelectedItem() == PluginName.DEFAULT);
            }
        });
        this.comboBoxFilter.addItemListener(itemEvent -> this.storeFilterName());
        this.formattedEMPRThickness.addPropertyChangeListener("value", propertyChangeEvent -> this.storeEMPRThickness());
        this.comboBoxEMPRMode.addItemListener(itemEvent -> this.storeEMPRMode());
        this.formattedTextWindowCenter.addPropertyChangeListener("value", propertyChangeEvent -> this.storeWindowCenter());
        this.formattedTextWindowWidth.addPropertyChangeListener("value", propertyChangeEvent -> this.storeWindowWidth());
        this.checkBoxInverted.addActionListener(actionEvent -> this.storeInverted());
        this.checkBoxLocalizer.addActionListener(actionEvent -> this.storeLocalizer());
        this.checkBoxSynced.addActionListener(actionEvent -> this.storeSynced());
        this.checkBoxHorizontalFlip.addActionListener(actionEvent -> this.storeHorizontalFlip());
        this.comboBoxRotation.addItemListener(itemEvent -> this.storeImageRotation());
        this.comboBoxPixelZoomFactors.addItemListener(itemEvent -> this.storeZoomMode());
        this.sliderScrollingPosition.addChangeListener(changeEvent -> this.storeScrollingPosition());
        this.jumpToFirstKeyImage.addActionListener(actionEvent -> this.storeJumpToFirstKeyImage());
        this.checkBoxStoreWindowLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplaySettingsPanel.this.setWindowingComponentsVisible(DisplaySettingsPanel.this.checkBoxStoreWindowLevel.isSelected());
                DisplaySettingsPanel.this.storeUseWindowLevel();
            }
        });
        this.keyImageOverviewCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplaySettingsPanel.this.displayState.setKeyImageOverviewStudyIndex(((KeyImageOverviewType)((Object)DisplaySettingsPanel.this.keyImageOverviewCBox.getSelectedItem())).getStudyIndex());
                DisplaySettingsPanel.this.informListener();
            }
        });
        this.spinner4DNavigationPosition.addPropertyChangeListener(propertyChangeEvent -> this.store4DNavigationPosition());
        this.comboBox4DNavigationOrder.addItemListener(itemEvent -> this.store4DNavigationOrder());
        this.comboBox4DPrimaryDimension.addItemListener(itemEvent -> this.store4DPrimaryDimension());
    }

    private void setWindowingComponentsVisible(boolean bl) {
        this.formattedTextWindowCenter.setVisible(bl);
        this.formattedTextWindowWidth.setVisible(bl);
        this.labelWindowCenter.setVisible(bl);
        this.labelWindowWidth.setVisible(bl);
    }

    protected void showProperInputComponentForZoomFactor() {
        Object object = this.comboBoxPresentationSizeMode.getSelectedItem();
        this.formattedTextFieldZoomFactor.setVisible(false);
        this.comboBoxPixelZoomFactors.setVisible(false);
        if (object != null && object instanceof PresentationSizeModeWrapper) {
            if (((PresentationSizeModeWrapper)object).getZoomMode() == ZoomMode.NORMAL) {
                this.formattedTextFieldZoomFactor.setVisible(true);
            } else if (((PresentationSizeModeWrapper)object).getZoomMode() == ZoomMode.PIXELIDENTITY) {
                this.comboBoxPixelZoomFactors.setVisible(true);
            }
        }
    }

    public void setLayout(MainLayoutType mainLayoutType, String string) {
        this.leftPanel.remove(this.panelDisplayLayoutButtons);
        this.leftPanel.remove(this.panelFilmLayoutButtons);
        this.leftPanel.remove(this.panelStripeLayout);
        if (mainLayoutType == MainLayoutType.variable) {
            this.leftPanel.add((Component)this.panelDisplayLayoutButtons, "1,0,2,0");
            int n = this.getIndexOfVariableLayout(string);
            this.buttonGroupDisplayLayout.clearSelection();
            if (n >= 0) {
                this.displayLayoutButtons[n].setSelected(true);
                this.displayLayoutDropdown.setText(variableLayouts[n]);
            } else {
                this.displayLayoutDropdown.setText(string);
            }
        } else if (mainLayoutType == MainLayoutType.film) {
            this.leftPanel.add((Component)this.panelFilmLayoutButtons, "1,0,2,0");
            int n = this.getIndexOfFilmLayout(string);
            if (this.buttonGroupFilmLayout.getSelection() != null) {
                this.buttonGroupFilmLayout.getSelection().setSelected(false);
            }
            if (n >= 0) {
                this.filmLayoutButtons[n].setSelected(true);
            } else {
                this.filmLayoutButtons[0].setSelected(true);
            }
        } else if (mainLayoutType == MainLayoutType.stripe) {
            this.leftPanel.add((Component)this.panelStripeLayout, "1,0,2,0");
            this.labelStripeColsInfo.setText(string == null ? "1x1" : ScreenSettingsPanel.correctStripeCols(string));
        }
        this.screenLayoutType = mainLayoutType;
        this.storeHorizontalXVertical();
    }

    public void init(IDisplayLayoutDefinition iDisplayLayoutDefinition) {
        if (iDisplayLayoutDefinition != null) {
            PluginName pluginName = PluginName.getItemWithName(iDisplayLayoutDefinition.getPluginName());
            this.comboBoxPlugin.setSelectedItem((Object)(pluginName != null ? pluginName : PluginName.DEFAULT));
            this.enableDisplayStateComponents(this.comboBoxPlugin.getSelectedItem() == PluginName.DEFAULT);
            this.setLayout(this.screenLayoutType, iDisplayLayoutDefinition.getHorizontalXVertical());
            IDisplayState iDisplayState = iDisplayLayoutDefinition.getDisplayState();
            if (iDisplayState != null) {
                this.comboBoxFilter.setSelectedItem((Object)FilterActions.FilterType.parse(iDisplayState.getFilterName()));
                this.comboBoxPresentationSizeMode.setSelectedItem(iDisplayState.getZoomMode() != null ? this.getWrapperForPresentationSizeMode(iDisplayState.getZoomMode()) : this.getWrapperForPresentationSizeMode(ZoomMode.NORMAL));
                this.formattedTextFieldZoomFactor.setEnabled(iDisplayState.getZoomMode() != ZoomMode.TRUESIZE);
                this.comboBoxPixelZoomFactors.setSelectedIndex(zfr[(int)Math.min(Math.max(0.0, iDisplayState.getMagnificationRatio()), 8.0)]);
                this.formattedTextFieldZoomFactor.setValue(iDisplayState.getMagnificationRatio());
                this.formattedEMPRThickness.setValue(iDisplayState.getEMPRThickness());
                this.comboBoxEMPRMode.setSelectedIndex(iDisplayState.getEMPRMode().ordinal());
                this.checkBoxHorizontalFlip.setSelected(iDisplayState.getImageHorizontalFlip() != null ? iDisplayState.getImageHorizontalFlip() : false);
                this.checkBoxInverted.setSelected(iDisplayState.getImageInvert() != null ? iDisplayState.getImageInvert() : false);
                this.checkBoxLocalizer.setSelected(iDisplayState.getLocalizerEnabled() != null ? iDisplayState.getLocalizerEnabled() : false);
                this.checkBoxSynced.setSelected(iDisplayState.getSynced() != null ? iDisplayState.getSynced() : false);
                this.sliderScrollingPosition.setValue(iDisplayState.getScrollPosition() != null ? (int)(100.0 * iDisplayState.getScrollPosition() + 0.5) : 0);
                this.currentScrollingPosition = iDisplayState.getScrollPosition() != null ? iDisplayState.getScrollPosition() : 0.0;
                this.jumpToFirstKeyImage.setSelected(Boolean.TRUE.equals(iDisplayState.getJumpToFirstKeyImage()));
                this.keyImageOverviewCBox.setSelectedItem((Object)KeyImageOverviewType.getForStudyIndex(iDisplayState.getKeyImageOverviewStudyIndex()));
                this.spinner4DNavigationPosition.setValue(iDisplayState.getNavigationPosition4D());
                this.comboBox4DNavigationOrder.setSelectedIndex(iDisplayState.getIsNavigationPosition4DOrderFrontToBack() != false ? 0 : 1);
                this.comboBox4DPrimaryDimension.setSelectedItem(this.displayState.getPrimaryDimension4D() != null ? this.getPrimaryDimensionWrapper(iDisplayState.getPrimaryDimension4D()) : this.getPrimaryDimensionWrapper(PrimaryDimension.DEFAULT));
                Integer n = iDisplayState.getImageRotation();
                if (n != null) {
                    int n2 = 0;
                    int n3 = n % 360 / 90 * 90;
                    int n4 = 1;
                    while (n4 < degrees.length) {
                        if (degrees[n4] == n3) {
                            n2 = n4;
                            break;
                        }
                        ++n4;
                    }
                    this.comboBoxRotation.setSelectedIndex(n2);
                } else {
                    this.comboBoxRotation.setSelectedIndex(0);
                }
                this.formattedTextWindowCenter.setValue(iDisplayState.getWindowCenter());
                this.formattedTextWindowWidth.setValue(iDisplayState.getWindowWidth());
                this.setWindowingComponentsVisible(iDisplayState.getUseWindowLevel());
                this.checkBoxStoreWindowLevel.setSelected(iDisplayState.getUseWindowLevel());
            } else {
                this.comboBoxPresentationSizeMode.setSelectedItem(this.getWrapperForPresentationSizeMode(ZoomMode.NORMAL));
                this.formattedTextFieldZoomFactor.setEnabled(false);
                this.formattedTextFieldZoomFactor.setValue(Float.valueOf(1.0f));
                this.comboBoxPixelZoomFactors.setSelectedIndex(0);
                this.formattedEMPRThickness.setValue(0.0);
                this.formattedEMPRThickness.setEnabled(false);
                this.comboBoxEMPRMode.setSelectedIndex(0);
                this.comboBoxEMPRMode.setEnabled(false);
                this.checkBoxHorizontalFlip.setSelected(false);
                this.checkBoxInverted.setSelected(false);
                this.checkBoxLocalizer.setSelected(false);
                this.checkBoxSynced.setSelected(false);
                this.comboBoxRotation.setSelectedIndex(0);
                this.formattedTextWindowCenter.setValue(null);
                this.formattedTextWindowWidth.setValue(null);
                this.setWindowingComponentsVisible(true);
                this.checkBoxStoreWindowLevel.setSelected(true);
                this.sliderScrollingPosition.setValue(0);
                this.jumpToFirstKeyImage.setSelected(false);
                this.keyImageOverviewCBox.setSelectedItem((Object)KeyImageOverviewType.NO);
            }
        } else {
            this.comboBoxPlugin.setSelectedItem((Object)PluginName.DEFAULT);
            this.comboBoxFilter.setSelectedItem((Object)FilterActions.FilterType.None);
            this.setLayout(this.screenLayoutType, null);
        }
    }

    private void enableDisplayStateComponents(boolean bl) {
        JToggleButton jToggleButton;
        boolean bl2 = this.comboBoxPlugin.getSelectedItem() == PluginName.MAMMO2;
        boolean bl3 = this.comboBoxPlugin.getSelectedItem() == PluginName.EMPR;
        this.comboBoxPresentationSizeMode.setEnabled(bl || bl2);
        this.formattedTextFieldZoomFactor.setEnabled(bl || bl2);
        this.comboBoxPixelZoomFactors.setEnabled(bl);
        this.comboBoxFilter.setEnabled(bl || bl2);
        this.formattedEMPRThickness.setEnabled(bl3);
        this.comboBoxEMPRMode.setEnabled(bl3);
        this.checkBoxHorizontalFlip.setEnabled(bl || bl2);
        this.checkBoxSynced.setEnabled(bl || bl2);
        this.checkBoxLocalizer.setEnabled(bl);
        this.comboBoxRotation.setEnabled(bl);
        this.formattedTextWindowCenter.setEnabled(bl);
        this.formattedTextWindowWidth.setEnabled(bl);
        this.checkBoxStoreWindowLevel.setEnabled(bl);
        this.sliderScrollingPosition.setEnabled(bl);
        this.jumpToFirstKeyImage.setEnabled(bl);
        JToggleButton[] jToggleButtonArray = this.filmLayoutButtons;
        int n = this.filmLayoutButtons.length;
        int n2 = 0;
        while (n2 < n) {
            jToggleButton = jToggleButtonArray[n2];
            jToggleButton.setEnabled(bl);
            ++n2;
        }
        jToggleButtonArray = this.displayLayoutButtons;
        n = this.displayLayoutButtons.length;
        n2 = 0;
        while (n2 < n) {
            jToggleButton = jToggleButtonArray[n2];
            jToggleButton.setEnabled(bl);
            ++n2;
        }
    }

    private int getIndexOfVariableLayout(String string) {
        int n = 0;
        while (n < variableLayouts.length) {
            if (variableLayouts[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int getIndexOfFilmLayout(String string) {
        int n = 0;
        while (n < filmLayouts.length) {
            if (filmLayouts[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setStripeDisplayLayout(String string) {
        this.labelStripeColsInfo.setText(string);
    }

    private void storeHorizontalXVertical() {
        String string = this.displayLayout.getHorizontalXVertical();
        if (this.screenLayoutType == MainLayoutType.film) {
            int n = 0;
            while (n < this.filmLayoutButtons.length) {
                if (this.filmLayoutButtons[n].isSelected() && !filmLayouts[n].equalsIgnoreCase(string)) {
                    this.displayLayout.setHorizontalXVertical(filmLayouts[n]);
                    this.informListener();
                    break;
                }
                ++n;
            }
        } else if (this.screenLayoutType == MainLayoutType.stripe) {
            if (!this.labelStripeColsInfo.getText().equalsIgnoreCase(string)) {
                this.displayLayout.setHorizontalXVertical(this.labelStripeColsInfo.getText());
                this.informListener();
            }
        } else {
            String string2;
            boolean bl = false;
            int n = 0;
            while (n < this.displayLayoutButtons.length) {
                if (this.displayLayoutButtons[n].isSelected() && !variableLayouts[n].equalsIgnoreCase(string)) {
                    this.displayLayout.setHorizontalXVertical(variableLayouts[n]);
                    this.displayLayoutDropdown.setText(variableLayouts[n]);
                    bl = true;
                    this.informListener();
                    break;
                }
                ++n;
            }
            if (!(bl || (string2 = this.displayLayoutDropdown.getText()) == null || string2.isEmpty() || string2.equals(string))) {
                this.displayLayout.setHorizontalXVertical(string2);
                this.buttonGroupDisplayLayout.clearSelection();
                int n2 = this.getIndexOfVariableLayout(string2);
                if (n2 >= 0) {
                    this.displayLayoutButtons[n2].setSelected(true);
                    this.informListener();
                }
            }
        }
    }

    private void storeUseWindowLevel() {
        Boolean bl = this.displayState.getUseWindowLevel();
        Boolean bl2 = this.checkBoxStoreWindowLevel.isSelected();
        if (!bl2.equals(bl)) {
            this.displayState.setUseWindowLevel(bl2);
            this.informListener();
        }
    }

    private void storeImageRotation() {
        Integer n = this.displayState.getImageRotation();
        Integer n2 = 0;
        int n3 = this.comboBoxRotation.getSelectedIndex();
        if (n3 >= 0 && n3 < degrees.length) {
            n2 = degrees[n3];
        }
        if (!n2.equals(n)) {
            this.displayState.setImageRotation(n2);
            this.informListener();
        }
    }

    private void storeEMPRMode() {
        ThickMode thickMode = this.displayState.getEMPRMode();
        ThickMode thickMode2 = (ThickMode)((Object)this.comboBoxEMPRMode.getSelectedItem());
        if (!thickMode2.equals((Object)thickMode)) {
            this.displayState.setEMPRMode(thickMode2);
            this.informListener();
        }
    }

    private void storeEMPRThickness() {
        Double d = this.displayState.getEMPRThickness();
        Double d2 = 0.0;
        Object object = this.formattedEMPRThickness.getValue();
        if (object != null && object instanceof Number) {
            Number number = (Number)object;
            d2 = number.doubleValue();
        }
        if (!d2.equals(d)) {
            this.displayState.setEMPRThickness(d2);
            this.informListener();
        }
    }

    private void storeHorizontalFlip() {
        Boolean bl = this.displayState.getImageHorizontalFlip();
        Boolean bl2 = this.checkBoxHorizontalFlip.isSelected();
        if (!bl2.equals(bl)) {
            this.displayState.setImageHorizontalFlip(bl2);
            this.informListener();
        }
    }

    private void storeInverted() {
        Boolean bl = this.displayState.getImageInvert();
        Boolean bl2 = this.checkBoxInverted.isSelected();
        if (!bl2.equals(bl)) {
            this.displayState.setImageInvert(bl2);
            this.informListener();
        }
    }

    void storeLocalizer() {
        Boolean bl = this.displayState.getLocalizerEnabled();
        Boolean bl2 = this.checkBoxLocalizer.isSelected();
        if (!bl2.equals(bl)) {
            this.displayState.setLocalizerEnabled(bl2);
            this.informListener();
        }
    }

    private void storeWindowWidth() {
        Double d = this.displayState.getWindowWidth();
        Object object = this.formattedTextWindowWidth.getValue();
        if (object != null && object instanceof Number) {
            Number number = (Number)object;
            Double d2 = number.doubleValue();
            if (!d2.equals(d)) {
                this.displayState.setWindowWidth(d2);
                this.informListener();
            }
        } else if (d != null) {
            this.displayState.setWindowWidth(null);
            this.informListener();
        }
    }

    private void storeWindowCenter() {
        Double d = this.displayState.getWindowCenter();
        Object object = this.formattedTextWindowCenter.getValue();
        if (object != null && object instanceof Number) {
            Number number = (Number)object;
            Double d2 = number.doubleValue();
            if (!d2.equals(d)) {
                this.displayState.setWindowCenter(d2);
                this.informListener();
            }
        } else if (d != null) {
            this.displayState.setWindowCenter(null);
            this.informListener();
        }
    }

    private void storeSynced() {
        Boolean bl = this.displayState.getSynced();
        Boolean bl2 = this.checkBoxSynced.isSelected();
        if (!bl2.equals(bl)) {
            this.displayState.setSynced(bl2);
            this.informListener();
        }
    }

    private void storePluginName() {
        String string = this.displayLayout.getPluginName();
        Object object = this.comboBoxPlugin.getSelectedItem();
        if (object != null && object instanceof PluginName) {
            String string2 = ((PluginName)((Object)object)).getPluginName();
            if (!string2.equals(string)) {
                this.displayLayout.setPluginName(string2);
                this.informListener();
            }
        } else if (string != null) {
            this.displayLayout.setPluginName(null);
            this.informListener();
        }
    }

    void storeFilterName() {
        String string = this.displayState.getFilterName();
        Object object = this.comboBoxFilter.getSelectedItem();
        if (object instanceof FilterActions.FilterType) {
            String string2 = ((FilterActions.FilterType)((Object)object)).name();
            if (!string2.equals(string)) {
                this.displayState.setFilterName(string2);
                this.informListener();
            }
        } else if (string != null) {
            this.displayState.setFilterName(null);
            this.informListener();
        }
    }

    private void storeScrollingPosition() {
        Double d = this.displayState.getScrollPosition();
        Double d2 = this.currentScrollingPosition;
        if (!d2.equals(d)) {
            this.displayState.setScrollPosition(d2);
            this.informListener();
        }
    }

    void storeJumpToFirstKeyImage() {
        Boolean bl = this.displayState.getJumpToFirstKeyImage();
        Boolean bl2 = this.jumpToFirstKeyImage.isSelected();
        if (!bl2.equals(bl)) {
            this.displayState.setJumpToFirstKeyImage(bl2);
            this.informListener();
        }
    }

    private void store4DNavigationPosition() {
        Integer n;
        Integer n2 = this.displayState.getNavigationPosition4D();
        if (!Objects.equals(n2, n = (Integer)this.spinner4DNavigationPosition.getValue())) {
            this.displayState.setNavigationPosition4D(n);
            this.informListener();
        }
    }

    private void store4DNavigationOrder() {
        String string;
        Boolean bl;
        Boolean bl2 = this.displayState.getIsNavigationPosition4DOrderFrontToBack();
        if (!Objects.equals(bl2, bl = Boolean.valueOf(NAVIGATION_ORDER[0].equals(string = (String)this.comboBox4DNavigationOrder.getSelectedItem())))) {
            this.displayState.setIsNavigationPosition4DOrderFrontToBack(bl);
            this.informListener();
        }
    }

    private void store4DPrimaryDimension() {
        PrimaryDimensionWrapper primaryDimensionWrapper;
        PrimaryDimension primaryDimension = this.displayState.getPrimaryDimension4D();
        if (primaryDimension != (primaryDimensionWrapper = (PrimaryDimensionWrapper)this.comboBox4DPrimaryDimension.getSelectedItem()).getPrimaryDimension()) {
            this.displayState.setPrimaryDimension4D(primaryDimensionWrapper.getPrimaryDimension());
            this.informListener();
        }
    }

    private void storeZoomMode() {
        ZoomMode zoomMode = this.displayState.getZoomMode();
        Double d = this.displayState.getMagnificationRatio();
        ZoomMode zoomMode2 = ZoomMode.NORMAL;
        Double d2 = 0.0;
        Object object = this.comboBoxPresentationSizeMode.getSelectedItem();
        if (object != null && object instanceof PresentationSizeModeWrapper) {
            int n;
            zoomMode2 = ((PresentationSizeModeWrapper)object).getZoomMode();
            if (zoomMode2 == ZoomMode.NORMAL) {
                Object object2 = this.formattedTextFieldZoomFactor.getValue();
                if (object2 != null && object2 instanceof Number) {
                    Number number = (Number)object2;
                    d2 = number.doubleValue();
                }
            } else if (zoomMode2 == ZoomMode.PIXELIDENTITY && (n = this.comboBoxPixelZoomFactors.getSelectedIndex()) >= 0) {
                d2 = pixelZoomFactors[n];
            }
        }
        boolean bl = false;
        if (zoomMode != zoomMode2) {
            bl = true;
            this.displayState.setZoomMode(zoomMode2);
        }
        if (!d2.equals(d)) {
            bl = true;
            this.displayState.setMagnificationRatio(d2);
        }
        if (bl) {
            this.informListener();
        }
    }

    public PresentationSizeModeWrapper getWrapperForPresentationSizeMode(ZoomMode zoomMode) {
        for (PresentationSizeModeWrapper presentationSizeModeWrapper : this.wrappers) {
            if (presentationSizeModeWrapper.getZoomMode() != zoomMode) continue;
            return presentationSizeModeWrapper;
        }
        return null;
    }

    private PrimaryDimensionWrapper getPrimaryDimensionWrapper(PrimaryDimension primaryDimension) {
        for (PrimaryDimensionWrapper primaryDimensionWrapper : this.primaryDimensionWrappers) {
            if (primaryDimensionWrapper.getPrimaryDimension() != primaryDimension) continue;
            return primaryDimensionWrapper;
        }
        return null;
    }

    private void informListener() {
        if (this.listener != null) {
            this.listener.hangingChanged();
        }
    }

    private static class EmptyStringNumberFormatter
    extends Format {
        private Format delegate;

        public EmptyStringNumberFormatter(Format format) {
            this.delegate = format;
        }

        @Override
        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            if (object != null && object instanceof String && ((String)object).trim().length() == 0) {
                return new StringBuffer();
            }
            return this.delegate.format(object, stringBuffer, fieldPosition);
        }

        @Override
        public Object parseObject(String string) throws ParseException {
            ParsePosition parsePosition = new ParsePosition(0);
            Object object = this.parseObject(string, parsePosition);
            if (parsePosition.getIndex() == 0) {
                throw new ParseException("Format.parseObject(String) failed", parsePosition.getErrorIndex());
            }
            return object;
        }

        @Override
        public Object parseObject(String string, ParsePosition parsePosition) {
            if (StringUtils.isBlank((CharSequence)string)) {
                parsePosition.setIndex(-1);
                return null;
            }
            return this.delegate.parseObject(string, parsePosition);
        }
    }

    private static enum KeyImageOverviewType {
        NO(-1),
        BASE(0),
        PRIOR1(1),
        PRIOR2(2),
        PRIOR3(3),
        PRIOR4(4),
        PRIOR5(5);

        private int studyIndex;

        private KeyImageOverviewType(int n2) {
            this.studyIndex = n2;
        }

        public static KeyImageOverviewType getForStudyIndex(Integer n) {
            if (n != null) {
                KeyImageOverviewType[] keyImageOverviewTypeArray = KeyImageOverviewType.values();
                int n2 = keyImageOverviewTypeArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    KeyImageOverviewType keyImageOverviewType = keyImageOverviewTypeArray[n3];
                    if (keyImageOverviewType.studyIndex == n) {
                        return keyImageOverviewType;
                    }
                    ++n3;
                }
            }
            return NO;
        }

        public int getStudyIndex() {
            return this.studyIndex;
        }

        public String toString() {
            return Messages.getString("DisplaySettingsPanel.KeyImageOverviewType." + this.name().toUpperCase());
        }
    }

    private static class PresentationSizeModeWrapper {
        private ZoomMode zoomMode;

        public PresentationSizeModeWrapper(ZoomMode zoomMode) {
            this.zoomMode = zoomMode;
        }

        public String toString() {
            return this.zoomMode.getDescription();
        }

        public ZoomMode getZoomMode() {
            return this.zoomMode;
        }
    }

    private static class PrimaryDimensionWrapper {
        private PrimaryDimension primaryDimension;

        public PrimaryDimensionWrapper(PrimaryDimension primaryDimension) {
            this.primaryDimension = primaryDimension;
        }

        public String toString() {
            return this.primaryDimension.getDescription();
        }

        public PrimaryDimension getPrimaryDimension() {
            return this.primaryDimension;
        }
    }
}

