/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.HangingProtocolManipulationListenerDispatcher;
import com.agfa.pacs.impaxee.hanging.HangingUtil;
import com.agfa.pacs.impaxee.hanging.IConditionEvaluator;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHangingProtocolManipulationListener;
import com.agfa.pacs.impaxee.hanging.gui.advanced.AbstractTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ActivationStateTreeNode;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ConditionButtonsPanel;
import com.agfa.pacs.impaxee.hanging.gui.advanced.CreateAbstractConditionPanel;
import com.agfa.pacs.impaxee.hanging.gui.advanced.DisplaySettingsPanel;
import com.agfa.pacs.impaxee.hanging.gui.advanced.ScreenTreeNode;
import com.agfa.pacs.impaxee.hanging.model.IDisplayLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetConditionRule;
import com.agfa.pacs.impaxee.hanging.runtime.DisplayLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.ScreenLayoutRuntime;
import com.agfa.pacs.listtext.lta.base.LTAUtil;
import com.tiani.util.message.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DisplayTreeNode
extends AbstractTreeNode
implements IHangingProtocolManipulationListener,
IConditionEvaluator {
    private int display;
    private CreateAbstractConditionPanel conditionPanel;
    private DisplaySettingsPanel displaySettingsPanel;
    private JPanel panel;
    private ConditionButtonsPanel conditionButtonsPanel;
    private JTabbedPane tabbedPane;
    private DisplaySetCondition displaySetCondition;
    private IDisplayLayoutDefinition displayLayout;
    private HangingProtocolManipulationListenerDispatcher hangingProtocolManipulationListenerDispatcher;

    public DisplayTreeNode(Window window, MainLayoutType mainLayoutType, DisplaySetCondition displaySetCondition2, IDisplayLayoutDefinition iDisplayLayoutDefinition, IHangingProtocolManipulationListener iHangingProtocolManipulationListener, IComponentFactory iComponentFactory, int n, boolean bl) {
        super(iComponentFactory);
        this.display = n;
        this.displayLayout = iDisplayLayoutDefinition;
        this.displaySetCondition = displaySetCondition2;
        this.componentFactory = iComponentFactory;
        this.hangingProtocolManipulationListenerDispatcher = new HangingProtocolManipulationListenerDispatcher();
        this.hangingProtocolManipulationListenerDispatcher.registerListener(iHangingProtocolManipulationListener);
        this.hangingProtocolManipulationListenerDispatcher.registerListener(this);
        this.displaySettingsPanel = new DisplaySettingsPanel(mainLayoutType, iDisplayLayoutDefinition, iComponentFactory, this.hangingProtocolManipulationListenerDispatcher);
        this.tabbedPane = iComponentFactory.createTabbedPane(Integer.valueOf(1), Integer.valueOf(1));
        for (DisplaySetConditionRule object2 : displaySetCondition2.rules()) {
            this.conditionPanel = this.createConditionPanel(object2);
            this.addCondition(object2, this.tabbedPane, this.conditionPanel);
        }
        this.conditionButtonsPanel = new ConditionButtonsPanel(iComponentFactory, new AddSeriesConditionAction(), new DeleteSeriesConditionAction());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.tabbedPane, "Center");
        jPanel.add((Component)this.conditionButtonsPanel, "South");
        JPanel jPanel2 = ComponentFactory.instance.createPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)this.displaySettingsPanel, "North");
        JScrollPane jScrollPane = iComponentFactory.createScrollPane((Component)jPanel2, Integer.valueOf(20), Integer.valueOf(30), Boolean.valueOf(true), Boolean.valueOf(false));
        jScrollPane.getViewport().add(jPanel2);
        this.panel = ComponentFactory.instance.createPanel(new BorderLayout());
        this.panel.add(jScrollPane);
        this.kindOfHangingChanged(bl);
    }

    private CreateAbstractConditionPanel createConditionPanel(DisplaySetConditionRule displaySetConditionRule) {
        return new CreateAbstractConditionPanel(this.parentWindow, Messages.getString("DisplayTreeNode.DisplayConditionSets"), displaySetConditionRule, this.componentFactory, this.hangingProtocolManipulationListenerDispatcher, this);
    }

    @Override
    public String toString() {
        return String.valueOf(Messages.getString("MyTreeNode.Display")) + " " + this.display;
    }

    public DisplaySettingsPanel getDisplaySettingsPanel() {
        return this.displaySettingsPanel;
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    public void screenLayoutTypeChanged(MainLayoutType mainLayoutType) {
        this.getDisplaySettingsPanel().setLayout(mainLayoutType, null);
    }

    public void displayLayoutChanged(MainLayoutType mainLayoutType, String string) {
        this.displaySettingsPanel.setLayout(mainLayoutType, string);
    }

    public DisplaySetCondition getDisplaySetCondition() {
        return this.displaySetCondition;
    }

    public void kindOfHangingChanged(boolean bl) {
        boolean bl2 = !bl;
        this.setEnabled(this.conditionPanel, bl2);
        this.conditionButtonsPanel.enableButtons(bl2);
        this.checkForWarningsAndErrors();
    }

    private void setEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof Container) {
            Container container = (Container)component;
            Component[] componentArray = container.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component2 = componentArray[n2];
                this.setEnabled(component2, bl);
                ++n2;
            }
        }
    }

    public IDisplayLayoutDefinition getDisplayLayout() {
        return this.displayLayout;
    }

    @Override
    public void hangingChanged() {
        this.checkForWarningsAndErrors();
        if (this.model != null) {
            this.model.nodeChanged(this);
        }
    }

    public ScreenTreeNode getScreenNode() {
        TreeNode treeNode = super.getParent();
        if (treeNode instanceof ScreenTreeNode) {
            return (ScreenTreeNode)treeNode;
        }
        return null;
    }

    private void checkForWarningsAndErrors() {
        this.setHasWarningSelf(false);
    }

    @Override
    public boolean isEvaluationPossible() {
        if (this.displayLayout instanceof DisplayLayoutRuntime) {
            DisplayLayoutRuntime displayLayoutRuntime = (DisplayLayoutRuntime)this.displayLayout;
            return displayLayoutRuntime.getDisplaySet() != null && displayLayoutRuntime.getScreenLayoutRuntime() != null;
        }
        return false;
    }

    @Override
    public boolean meetsConditions(Iterable<Condition> iterable) {
        if (this.displayLayout instanceof DisplayLayoutRuntime) {
            DisplayLayoutRuntime displayLayoutRuntime = (DisplayLayoutRuntime)this.displayLayout;
            IDisplaySet iDisplaySet = displayLayoutRuntime.getDisplaySet();
            ScreenLayoutRuntime screenLayoutRuntime = displayLayoutRuntime.getScreenLayoutRuntime();
            if (iDisplaySet != null && screenLayoutRuntime != null) {
                HangingProtocolRuntime hangingProtocolRuntime = screenLayoutRuntime.getLayoutRuntime().getHangingSnapshot().getHangingDefinitionRuntime().getHangingProtocolRuntime();
                return HangingUtil.matches(iDisplaySet, hangingProtocolRuntime, iterable);
            }
        }
        return true;
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
        if (mutableTreeNode instanceof ActivationStateTreeNode) {
            this.hangingChanged();
        }
    }

    @Override
    public void deregisterListeners() {
        super.deregisterListeners();
        this.conditionPanel.deregisterListener();
    }

    private class AddSeriesConditionAction
    extends AbstractAction {
        public AddSeriesConditionAction() {
            super(Messages.getString("DisplayTreeNode.AddRule"));
            this.putValue("ShortDescription", Messages.getString("DisplayTreeNode.AddRule.ToolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(LTAUtil.getMainWindow(), (Object)(String.valueOf(Messages.getString("DisplayTreeNode.NameOfNewRule")) + ':'));
            if (string != null) {
                if (DisplayTreeNode.this.isNameAllowedForCondition(string)) {
                    DisplaySetConditionRule displaySetConditionRule = DisplayTreeNode.this.displaySetCondition.createRule(string);
                    DisplayTreeNode.this.addCondition(displaySetConditionRule, DisplayTreeNode.this.tabbedPane, DisplayTreeNode.this.createConditionPanel(displaySetConditionRule));
                } else {
                    DisplayTreeNode.this.componentFactory.showErrorDialog(Messages.getString("ERROR"), Messages.getString("HangingProtocolTreeNode.ErrorMessageNonUniqueHangingConditionName"), (Component)DisplayTreeNode.this.panel);
                }
            }
        }
    }

    private class DeleteSeriesConditionAction
    extends AbstractAction {
        public DeleteSeriesConditionAction() {
            super(Messages.getString("DisplayTreeNode.DeleteRule"));
            this.putValue("ShortDescription", Messages.getString("DisplayTreeNode.DeleteRule.ToolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (Message.okCancel(Messages.getString("DisplayTreeNode.DeleteRule.Title"), Messages.getString("DisplayTreeNode.DeleteRule.Question")) == 0 && (n = DisplayTreeNode.this.tabbedPane.getSelectedIndex()) >= 0) {
                DisplayTreeNode.this.deleteCondition(n, DisplayTreeNode.this.tabbedPane);
                DisplayTreeNode.this.displaySetCondition.removeRule(n);
            }
        }
    }
}

