/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.HangingProtocolManipulationHandler;
import com.agfa.pacs.impaxee.hanging.IHangingProtocolManipulationListener;
import com.agfa.pacs.impaxee.hanging.gui.advanced.HangingActionSelection;
import com.agfa.pacs.impaxee.hanging.model.IHangingProtocolDefinition;
import com.agfa.pacs.impaxee.hanging.model.enums.UsePriors;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingAccessAuthorization;
import com.agfa.pacs.impaxee.hanging.model.xml.ReferencedRole;
import com.agfa.pacs.impaxee.hanging.registry.HPRegistry;
import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.security.role.IRole;
import com.agfa.pacs.security.role.RoleManagerFactory;
import com.tiani.gui.util.TIcon;
import com.tiani.gui.util.tree.ImpaxEETree;
import com.tiani.util.message.Message;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HangingProtocolSettingsPanel
extends JPanel {
    private static TIcon iconAllowed = new TIcon("/icons/hangingGUI/success_16x16.png");
    private static TIcon iconForbidden = new TIcon("/icons/hangingGUI/error_16x16.png");
    private static TIcon iconInherited = new TIcon("/icons/hangingGUI/inherited_16x16.png");
    private IHangingProtocolDefinition hangingProtocolDefinition;
    private JTextField textFieldName;
    private JLabel labelCreatedby;
    private JLabel labelLastModifiedBy;
    private JComboBox comboBoxUsePriors;
    private JSpinner spinnerNumberOfPriors;
    private JLabel labelNumberOfPriors;
    private JCheckBox checkBoxFitToBreast;
    private JCheckBox checkBoxActive;
    private UsePriors[] usePriorsEnumerationElements;
    private HangingProtocolManipulationHandler hangingProtocolManipulationHandler;
    private ImpaxEETree roleTree;
    private IComponentFactory componentFactory;
    private RoleTreeNode treeRootNode;
    private Icon scaledIconAllowed;
    private Icon scaledIconForbidden;
    private Icon scaledIconInherited;
    private JLabel labelAction;
    private JComboBox<PAction> cmbAction;

    public HangingProtocolSettingsPanel(IHangingProtocolDefinition iHangingProtocolDefinition, IComponentFactory iComponentFactory, HangingProtocolManipulationHandler hangingProtocolManipulationHandler, boolean bl) {
        HPRegistry.getInstance().couldBeEdited();
        this.hangingProtocolDefinition = iHangingProtocolDefinition;
        this.hangingProtocolManipulationHandler = hangingProtocolManipulationHandler;
        this.hangingProtocolManipulationHandler.registerListener(new MyHangingProtocolManipulationListener());
        this.componentFactory = iComponentFactory;
        this.scaledIconAllowed = this.scaleIcon(iconAllowed);
        this.scaledIconForbidden = this.scaleIcon(iconForbidden);
        this.scaledIconInherited = this.scaleIcon(iconInherited);
        this.init(bl);
    }

    private Icon scaleIcon(TIcon tIcon) {
        int n = this.componentFactory.scaleInt(tIcon.getIconWidth());
        int n2 = this.componentFactory.scaleInt(tIcon.getIconHeight());
        return IconUtil.scaleImageIcon((ImageIcon)tIcon, (int)n, (int)n2);
    }

    private void init(boolean bl) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        TableLayout tableLayout = new TableLayout(new double[]{-3.0, -1.0, -1.0}, new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0});
        tableLayout.setHGap(5);
        tableLayout.setVGap(5);
        JPanel jPanel = ComponentFactory.instance.createPanel((LayoutManager)tableLayout);
        this.usePriorsEnumerationElements = UsePriors.values();
        Object[] objectArray = new String[this.usePriorsEnumerationElements.length];
        int n = 0;
        while (n < this.usePriorsEnumerationElements.length) {
            objectArray[n] = this.usePriorsEnumerationElements[n].getDescription();
            ++n;
        }
        this.textFieldName = this.componentFactory.createTextField(this.hangingProtocolDefinition.getName());
        this.labelCreatedby = this.componentFactory.createLabel(this.hangingProtocolDefinition.getCreatedBy());
        this.labelLastModifiedBy = this.componentFactory.createLabel(this.hangingProtocolDefinition.getLastModifiedBy());
        this.comboBoxUsePriors = this.componentFactory.createComboBox(objectArray);
        this.spinnerNumberOfPriors = this.componentFactory.createSpinner((SpinnerModel)new SpinnerNumberModel(this.hangingProtocolDefinition.getNumberOfPriors() != null ? this.hangingProtocolDefinition.getNumberOfPriors() : 0, 0, Integer.MAX_VALUE, 1));
        this.checkBoxFitToBreast = this.componentFactory.createCheckBox(Messages.getString("HangingProtocolSettingsPanel.FitToBreast.Label"), Messages.getString("HangingProtocolSettingsPanel.FitToBreast.ToolTip"), this.hangingProtocolDefinition.getFitToBreast());
        this.checkBoxActive = this.componentFactory.createCheckBox(Messages.getString("HangingProtocolSettingsPanel.HPisActiveLabel"), Messages.getString("HangingProtocolSettingsPanel.HPisActiveToolTip"), this.hangingProtocolDefinition.getActive());
        this.labelNumberOfPriors = this.componentFactory.createLabel("");
        n = 0;
        while (n < this.usePriorsEnumerationElements.length) {
            if (this.usePriorsEnumerationElements[n] == this.hangingProtocolDefinition.getUsePriors()) {
                this.comboBoxUsePriors.setSelectedIndex(n);
            }
            ++n;
        }
        this.ensureEnabledSpinner(this.hangingProtocolDefinition.getUsePriors());
        this.labelAction = HangingActionSelection.createActionLabel(this.componentFactory);
        this.cmbAction = HangingActionSelection.createActionComboBox(this.componentFactory, this.hangingProtocolDefinition.getActionID());
        n = ConfigurationProviderFactory.getConfig().isSupportingRoles() ? 0 : 1;
        JPanel jPanel2 = ComponentFactory.instance.createPanel(new BorderLayout());
        jPanel2.setBorder(this.componentFactory.createTitledBorder(Messages.getString("HangingProtocolSettingsPanel.HangingProtocolAccessAuthorization")));
        JPanel jPanel3 = ComponentFactory.instance.createPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        this.roleTree = null;
        jPanel.add((Component)this.componentFactory.createLabel(String.valueOf(Messages.getString("HangingProtocolSettingsPanel.Name")) + ": "), "0, 0");
        jPanel.add((Component)this.componentFactory.createLabel(String.valueOf(Messages.getString("HangingProtocolSettingsPanel.CreatedBy")) + ": "), "0, 1");
        jPanel.add((Component)this.componentFactory.createLabel(String.valueOf(Messages.getString("HangingProtocolSettingsPanel.LastModifiedBy")) + ": "), "0, 2");
        jPanel.add((Component)this.componentFactory.createLabel(String.valueOf(Messages.getString("HangingProtocolSettingsPanel.Priors")) + ": "), "0, 3");
        jPanel.add((Component)this.labelNumberOfPriors, "0, 4, 1, 4");
        jPanel.add((Component)this.textFieldName, "1, 0, 2, 0");
        jPanel.add((Component)this.labelCreatedby, "1, 1, 2, 1");
        jPanel.add((Component)this.labelLastModifiedBy, "1, 2, 2, 2");
        jPanel.add((Component)this.comboBoxUsePriors, "1, 3, 2, 3");
        jPanel.add((Component)this.spinnerNumberOfPriors, "2, 4");
        jPanel.add((Component)this.checkBoxFitToBreast, "0, 5, 2, 5");
        if (!bl) {
            jPanel.add((Component)this.checkBoxActive, "0, 7, 2, 7");
        }
        jPanel.add((Component)this.labelAction, "0, 8, 2, 3");
        jPanel.add(this.cmbAction, "1, 8, 2, 3");
        if (n == 0 && !bl) {
            List list = RoleManagerFactory.getInstance().getEnterpriseRoles();
            this.hangingProtocolDefinition.getHangingAccessAuthorization().forceNonInheritedStateForEnterpriseRoles();
            this.treeRootNode = new RoleTreeNode(null);
            for (IRole iRole : list) {
                RoleTreeNode roleTreeNode = this.getTreeNodeForRoleRecursively(iRole, this.getRoles(this.hangingProtocolDefinition.getHangingAccessAuthorization()));
                this.treeRootNode.add(roleTreeNode);
            }
            this.roleTree = new ImpaxEETree((TreeNode)this.treeRootNode, this.componentFactory);
            this.roleTree.setCellRenderer(new RoleTreeCellRenderer());
            this.roleTree.setRootVisible(false);
            this.roleTree.setOpaque(false);
            this.roleTree.addMouseListener(new TreeContextMenuMouseListener());
            int n2 = 0;
            while (n2 < this.roleTree.getRowCount()) {
                this.roleTree.expandRow(n2);
                ++n2;
            }
            jPanel2.add((Component)this.componentFactory.createScrollPane((Component)this.roleTree), "Center");
            jPanel2.setPreferredSize(this.componentFactory.scaleDimension(250, 250));
            jPanel3.add((Component)jPanel2, "East");
        }
        jPanel.validate();
        this.add((Component)jPanel3, "Center");
        this.installListener();
    }

    private RoleTreeNode getTreeNodeForRoleRecursively(IRole iRole, List<AccessRule> list) {
        List list2 = iRole.getChildren();
        Boolean bl = this.isAllowed(list, iRole);
        RoleTreeNode roleTreeNode = new RoleTreeNode(iRole);
        if (list2 != null) {
            for (IRole iRole2 : list2) {
                roleTreeNode.add(this.getTreeNodeForRoleRecursively(iRole2, list));
            }
            if (bl == null) {
                roleTreeNode.setHpAllowed(true);
                roleTreeNode.setInherited(true);
            } else {
                roleTreeNode.setInherited(false);
                roleTreeNode.setHpAllowed(bl);
            }
        }
        return roleTreeNode;
    }

    private List<AccessRule> getRoles(HangingAccessAuthorization hangingAccessAuthorization) {
        ReferencedRole referencedRole;
        ArrayList<AccessRule> arrayList = new ArrayList<AccessRule>();
        int n = 0;
        while ((referencedRole = hangingAccessAuthorization.getReferencedRole(n)) != null) {
            arrayList.add(new AccessRule(referencedRole));
            ++n;
        }
        return arrayList;
    }

    private Boolean isAllowed(List<AccessRule> list, IRole iRole) {
        Boolean bl = null;
        for (AccessRule accessRule : list) {
            if (!accessRule.role.equals(iRole.getFullPath())) continue;
            bl = !accessRule.forbidden;
            break;
        }
        return bl;
    }

    private void installListener() {
        this.comboBoxUsePriors.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = HangingProtocolSettingsPanel.this.comboBoxUsePriors.getSelectedIndex();
                if (n >= 0) {
                    UsePriors usePriors = HangingProtocolSettingsPanel.this.usePriorsEnumerationElements[n];
                    HangingProtocolSettingsPanel.this.ensureEnabledSpinner(usePriors);
                    UsePriors usePriors2 = HangingProtocolSettingsPanel.this.hangingProtocolDefinition.getUsePriors();
                    if (usePriors != usePriors2) {
                        HangingProtocolSettingsPanel.this.hangingProtocolDefinition.setUsePriors(usePriors);
                        HangingProtocolSettingsPanel.this.hangingProtocolManipulationHandler.hangingChanged();
                    }
                } else {
                    HangingProtocolSettingsPanel.this.spinnerNumberOfPriors.setEnabled(false);
                }
            }
        });
        this.spinnerNumberOfPriors.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JComponent jComponent = HangingProtocolSettingsPanel.this.spinnerNumberOfPriors.getEditor();
                if (jComponent instanceof JSpinner.DefaultEditor) {
                    JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
                    try {
                        defaultEditor.commitEdit();
                    }
                    catch (ParseException parseException) {}
                }
            }
        });
        this.spinnerNumberOfPriors.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Integer n = HangingProtocolSettingsPanel.this.hangingProtocolDefinition.getNumberOfPriors();
                Integer n2 = ((Number)HangingProtocolSettingsPanel.this.spinnerNumberOfPriors.getValue()).intValue();
                if (!n2.equals(n)) {
                    HangingProtocolSettingsPanel.this.hangingProtocolDefinition.setNumberOfPriors(n2);
                    HangingProtocolSettingsPanel.this.hangingProtocolManipulationHandler.hangingChanged();
                }
            }
        });
        this.textFieldName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string = HangingProtocolSettingsPanel.this.hangingProtocolDefinition.getName();
                String string2 = HangingProtocolSettingsPanel.this.textFieldName.getText();
                if (!string2.equals(string)) {
                    if (HPRegistry.getInstance().isNameUnique(string2)) {
                        HangingProtocolSettingsPanel.this.hangingProtocolDefinition.setName(string2);
                        HangingProtocolSettingsPanel.this.hangingProtocolManipulationHandler.hangingChanged();
                    } else {
                        Message.warning(Messages.getString("HangingProtocolSettingsPanel.ErrorTitleAmbiguousHPName"), Messages.getString("HangingProtocolSettingsPanel.ErrorMessageAmbiguousHPName"));
                        HangingProtocolSettingsPanel.this.textFieldName.setText(string);
                    }
                }
            }
        });
        this.checkBoxFitToBreast.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Boolean bl = HangingProtocolSettingsPanel.this.hangingProtocolDefinition.getFitToBreast();
                Boolean bl2 = HangingProtocolSettingsPanel.this.checkBoxFitToBreast.isSelected();
                if (!bl2.equals(bl)) {
                    HangingProtocolSettingsPanel.this.hangingProtocolDefinition.setFitToBreast(bl2);
                    HangingProtocolSettingsPanel.this.hangingProtocolManipulationHandler.hangingChanged();
                }
            }
        });
        this.checkBoxActive.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Boolean bl = HangingProtocolSettingsPanel.this.hangingProtocolDefinition.getActive();
                Boolean bl2 = HangingProtocolSettingsPanel.this.checkBoxActive.isSelected();
                if (!bl2.equals(bl)) {
                    HangingProtocolSettingsPanel.this.hangingProtocolDefinition.setActive(bl2);
                    HangingProtocolSettingsPanel.this.hangingProtocolManipulationHandler.hangingChanged();
                    HPRegistry.getInstance().resetCurrentActiveHPs();
                }
            }
        });
        this.cmbAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = HangingProtocolSettingsPanel.this.hangingProtocolDefinition.getActionID();
                PAction pAction = (PAction)HangingProtocolSettingsPanel.this.cmbAction.getSelectedItem();
                if (!pAction.getID().equals(string)) {
                    HangingProtocolSettingsPanel.this.hangingProtocolDefinition.setActionID(pAction.getID());
                    HangingProtocolSettingsPanel.this.hangingProtocolManipulationHandler.hangingChanged();
                    HPRegistry.getInstance().resetCurrentActiveHPs();
                }
            }
        });
    }

    protected void ensureEnabledSpinner(UsePriors usePriors) {
        if (usePriors == UsePriors.FIRST_X_PRIORS || usePriors == UsePriors.FIRST_X_PRIORS_WITH_LAST || usePriors == UsePriors.ALL_PRIORS) {
            this.spinnerNumberOfPriors.setEnabled(true);
        } else {
            this.spinnerNumberOfPriors.setEnabled(false);
        }
        if (usePriors == UsePriors.ALL_PRIORS) {
            this.labelNumberOfPriors.setText(String.valueOf(Messages.getString("HangingProtocolSettingsPanel.MaxNumberOfPriors")) + ": ");
        } else {
            this.labelNumberOfPriors.setText(String.valueOf(Messages.getString("HangingProtocolSettingsPanel.NumberOfPriors")) + ": ");
        }
    }

    private void getAllowedRoles(List<String> list, List<String> list2) {
        if (this.treeRootNode != null) {
            this.getAllowedRoles(this.treeRootNode, list, list2);
        }
    }

    private void saveHangingAccessAuthorization() {
        ReferencedRole referencedRole;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.getAllowedRoles(arrayList, arrayList2);
        HangingAccessAuthorization hangingAccessAuthorization = this.hangingProtocolDefinition.getHangingAccessAuthorization();
        hangingAccessAuthorization.clear();
        for (String string : arrayList) {
            referencedRole = new ReferencedRole();
            referencedRole.setName(string);
            referencedRole.setForbidden(false);
            hangingAccessAuthorization.addReferencedRole(referencedRole);
        }
        for (String string : arrayList2) {
            referencedRole = new ReferencedRole();
            referencedRole.setName(string);
            referencedRole.setForbidden(true);
            hangingAccessAuthorization.addReferencedRole(referencedRole);
        }
        this.hangingProtocolManipulationHandler.hangingChanged();
        HPRegistry.getInstance().resetCurrentActiveHPs();
    }

    private void getAllowedRoles(RoleTreeNode roleTreeNode, List<String> list, List<String> list2) {
        if (roleTreeNode.getUserObject() != null && !roleTreeNode.isInherited()) {
            if (roleTreeNode.isHpAllowed()) {
                list.add(((IRole)roleTreeNode.getUserObject()).getFullPath());
            } else {
                list2.add(((IRole)roleTreeNode.getUserObject()).getFullPath());
            }
        }
        int n = 0;
        while (n < roleTreeNode.getChildCount()) {
            TreeNode treeNode = roleTreeNode.getChildAt(n);
            if (treeNode instanceof RoleTreeNode) {
                this.getAllowedRoles((RoleTreeNode)treeNode, list, list2);
            }
            ++n;
        }
    }

    private static class AccessRule {
        String role;
        boolean forbidden;

        AccessRule(ReferencedRole referencedRole) {
            this.role = referencedRole.getName();
            this.forbidden = referencedRole.getForbidden();
        }
    }

    private class AllowAction
    extends AbstractAction {
        private RoleTreeNode roleTreeNode;

        AllowAction(RoleTreeNode roleTreeNode) {
            super(Messages.getString("HangingProtocolSettingsPanel.Allow"), iconAllowed);
            this.roleTreeNode = roleTreeNode;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.roleTreeNode.setHpAllowed(true);
            this.roleTreeNode.setInherited(false);
            HangingProtocolSettingsPanel.this.saveHangingAccessAuthorization();
            HangingProtocolSettingsPanel.this.roleTree.invalidate();
            HangingProtocolSettingsPanel.this.roleTree.repaint();
        }
    }

    private class DenyAction
    extends AbstractAction {
        private RoleTreeNode roleTreeNode;

        DenyAction(RoleTreeNode roleTreeNode) {
            super(Messages.getString("HangingProtocolSettingsPanel.Permit"), iconForbidden);
            this.roleTreeNode = roleTreeNode;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.roleTreeNode.setHpAllowed(false);
            this.roleTreeNode.setInherited(false);
            HangingProtocolSettingsPanel.this.saveHangingAccessAuthorization();
            HangingProtocolSettingsPanel.this.roleTree.invalidate();
            HangingProtocolSettingsPanel.this.roleTree.repaint();
        }
    }

    private class InheriteAction
    extends AbstractAction {
        private RoleTreeNode roleTreeNode;

        InheriteAction(RoleTreeNode roleTreeNode) {
            super(Messages.getString("HangingProtocolSettingsPanel.Inherite"), iconInherited);
            this.roleTreeNode = roleTreeNode;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.roleTreeNode.setHpAllowed(true);
            this.roleTreeNode.setInherited(true);
            HangingProtocolSettingsPanel.this.saveHangingAccessAuthorization();
            HangingProtocolSettingsPanel.this.roleTree.invalidate();
            HangingProtocolSettingsPanel.this.roleTree.repaint();
        }
    }

    private class MyHangingProtocolManipulationListener
    implements IHangingProtocolManipulationListener {
        private MyHangingProtocolManipulationListener() {
        }

        @Override
        public void hangingChanged() {
            HangingProtocolSettingsPanel.this.labelLastModifiedBy.setText(HangingProtocolSettingsPanel.this.hangingProtocolDefinition.getLastModifiedBy());
        }
    }

    private class RoleTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public JLabel getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (object instanceof RoleTreeNode) {
                RoleTreeNode roleTreeNode = (RoleTreeNode)object;
                Object object2 = roleTreeNode.getUserObject();
                JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (object2 instanceof IRole) {
                    IRole iRole = (IRole)object2;
                    jLabel.setText(iRole.getName());
                    if (roleTreeNode.isInherited()) {
                        jLabel.setIcon(HangingProtocolSettingsPanel.this.scaledIconInherited);
                    } else if (roleTreeNode.isHpAllowed()) {
                        jLabel.setIcon(HangingProtocolSettingsPanel.this.scaledIconAllowed);
                    } else {
                        jLabel.setIcon(HangingProtocolSettingsPanel.this.scaledIconForbidden);
                    }
                    return jLabel;
                }
            }
            return (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
    }

    private static class RoleTreeNode
    extends DefaultMutableTreeNode {
        boolean hpAllowed;
        boolean inherited;

        public RoleTreeNode(IRole iRole) {
            super(iRole);
        }

        public void setHpAllowed(boolean bl) {
            this.hpAllowed = bl;
        }

        public boolean isHpAllowed() {
            return this.hpAllowed;
        }

        public boolean isInherited() {
            return this.inherited;
        }

        public void setInherited(boolean bl) {
            this.inherited = bl;
        }
    }

    private class TreeContextMenuMouseListener
    extends MouseAdapter {
        private TreeContextMenuMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TreePath treePath;
            if (mouseEvent.getButton() == 3 && (treePath = HangingProtocolSettingsPanel.this.roleTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && treePath.getPathCount() > 0 && treePath.getLastPathComponent() instanceof RoleTreeNode) {
                HangingProtocolSettingsPanel.this.roleTree.setSelectionPath(treePath);
                RoleTreeNode roleTreeNode = (RoleTreeNode)treePath.getLastPathComponent();
                JPopupMenu jPopupMenu = new JPopupMenu();
                if (roleTreeNode.isInherited()) {
                    jPopupMenu.add(HangingProtocolSettingsPanel.this.componentFactory.createMenuItem((Action)new AllowAction(roleTreeNode)));
                    jPopupMenu.add(HangingProtocolSettingsPanel.this.componentFactory.createMenuItem((Action)new DenyAction(roleTreeNode)));
                } else if (roleTreeNode.isHpAllowed()) {
                    if (treePath.getPathCount() > 1) {
                        jPopupMenu.add(HangingProtocolSettingsPanel.this.componentFactory.createMenuItem((Action)new InheriteAction(roleTreeNode)));
                    }
                    jPopupMenu.add(HangingProtocolSettingsPanel.this.componentFactory.createMenuItem((Action)new DenyAction(roleTreeNode)));
                } else {
                    if (treePath.getPathCount() > 1) {
                        jPopupMenu.add(HangingProtocolSettingsPanel.this.componentFactory.createMenuItem((Action)new InheriteAction(roleTreeNode)));
                    }
                    jPopupMenu.add(HangingProtocolSettingsPanel.this.componentFactory.createMenuItem((Action)new AllowAction(roleTreeNode)));
                }
                jPopupMenu.show(HangingProtocolSettingsPanel.this.roleTree, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

