/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.gui.advanced;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.descriptors.Descriptor;
import com.agfa.pacs.impaxee.hanging.model.IHangingProtocolDefinition;
import com.agfa.pacs.impaxee.hanging.model.IScreenLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.xml.Condition;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetConditionRule;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingCondition;
import com.agfa.pacs.impaxee.hanging.model.xml.ReferencedDescriptor;
import com.agfa.pacs.impaxee.hanging.model.xml.ReferencedRole;
import com.agfa.pacs.impaxee.hanging.runtime.ISnapshotDefinition;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.agfa.pacs.logging.ALogger;
import com.tiani.util.expressions.OperatorEnum;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class HangingProtocolWarningUtil {
    private static final ALogger LOGGER = ALogger.getLogger(HangingProtocolWarningUtil.class);
    private static final int MAX_STUDIES = 64;

    private HangingProtocolWarningUtil() {
    }

    public static List<String> getWarnings(IHangingProtocolDefinition iHangingProtocolDefinition) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!iHangingProtocolDefinition.getActive().booleanValue()) {
            arrayList.add(Messages.getString("HangingProtocolTreeNode.WarningNotInUse"));
        }
        if (!HangingProtocolWarningUtil.isAllowedForAtLeastOneRole(iHangingProtocolDefinition)) {
            arrayList.add(Messages.getString("HangingProtocolTreeNode.WarningNoRoleSelected"));
        }
        if (iHangingProtocolDefinition.getHangingApplicability().hangingConditions().isEmpty()) {
            arrayList.add(Messages.getString("HangingProtocolTreeNode.WarningNoRoles"));
        } else {
            for (HangingCondition hangingCondition2 : iHangingProtocolDefinition.getHangingApplicability().hangingConditions()) {
                if (hangingCondition2.referencedDescriptorList().size() != 0) continue;
                arrayList.add(String.valueOf(Messages.getString("HangingProtocolTreeNode.WarningEmptyRole1")) + " \"" + hangingCondition2.getName() + "\" " + Messages.getString("HangingProtocolTreeNode.WarningEmptyRole2"));
            }
            if (HangingProtocolWarningUtil.hasOnlyOneStudyContradictions(iHangingProtocolDefinition)) {
                arrayList.add(Messages.getString("ScreenSettinsPanel.OnlyOneStudyContradictionWarning.Msg"));
            }
        }
        return arrayList;
    }

    public static String createToolTipText(Collection<String> collection, Collection<String> collection2) {
        if (collection.size() == 0 && collection2.size() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        if (collection.size() > 0) {
            stringBuilder.append("<b>");
            stringBuilder.append(Messages.getString("ActivationStateTreeCellRenderer.Errors"));
            stringBuilder.append("</b>");
            for (String string : collection) {
                stringBuilder.append("<br> - ");
                stringBuilder.append(string);
            }
            if (!collection2.isEmpty()) {
                stringBuilder.append("<br>");
            }
        }
        if (collection2.size() > 0) {
            stringBuilder.append("<b>");
            stringBuilder.append(Messages.getString("ActivationStateTreeCellRenderer.Warnings"));
            stringBuilder.append("</b>");
            for (String string : collection2) {
                stringBuilder.append("<br> - ");
                stringBuilder.append(string);
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public static boolean hasOnlyOneStudyContradictions(IHangingProtocolDefinition iHangingProtocolDefinition) {
        ISnapshotDefinition[] iSnapshotDefinitionArray = iHangingProtocolDefinition.getHangingDefinition().snapshots();
        int n = iSnapshotDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISnapshotDefinition iSnapshotDefinition = iSnapshotDefinitionArray[n2];
            ConditionalHanging conditionalHanging = iSnapshotDefinition.getConditionalHanging();
            if (conditionalHanging != null) {
                IScreenLayoutDefinition[] iScreenLayoutDefinitionArray = iSnapshotDefinition.getLayout().screenLayouts();
                int n3 = 0;
                while (n3 < iScreenLayoutDefinitionArray.length) {
                    if (BooleanUtils.isTrue((Boolean)iScreenLayoutDefinitionArray[n3].getOnlyOneStudyEnabled()) && HangingProtocolWarningUtil.hasOnlyOneStudyContradictions(conditionalHanging.getConditionalHangingScreen(n3).displaySetConditions())) {
                        return true;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasOnlyOneStudyContradictions(List<DisplaySetCondition> list) {
        BitSet bitSet = new BitSet(64);
        boolean bl = false;
        for (DisplaySetCondition displaySetCondition2 : list) {
            for (DisplaySetConditionRule displaySetConditionRule : displaySetCondition2.rules()) {
                Condition condition = HangingProtocolWarningUtil.getStudyLoadOrderCondition(displaySetConditionRule);
                if (condition != null) {
                    HangingProtocolWarningUtil.handleStudyLoadOrderCondition(condition, bitSet);
                    continue;
                }
                bl = true;
            }
        }
        return bitSet.cardinality() > 1 || bitSet.nextSetBit(0) > 0 && bl;
    }

    private static void handleStudyLoadOrderCondition(Condition condition, BitSet bitSet) {
        int n = HangingProtocolWarningUtil.parseInteger(condition.getValue());
        OperatorEnum operatorEnum = condition.getOperator();
        switch (operatorEnum) {
            case EQUAL: 
            case HASPOSITIONFROMMIN: {
                bitSet.set(n < 64 ? n : 64);
                break;
            }
            case NOT_EQUAL: {
                int n2 = n < 64 ? n : 64;
                boolean bl = bitSet.get(n2);
                bitSet.set(0, 64);
                if (bl) break;
                bitSet.clear(n2);
                break;
            }
            case LESS_THAN: {
                if (n <= 0) break;
                bitSet.set(0, n <= 64 ? n - 1 : 64);
                break;
            }
            case LESS_EQUAL: {
                if (n < 0) break;
                bitSet.set(0, n < 64 ? n : 64);
                break;
            }
            case GREATER_THAN: {
                bitSet.set(n < 64 ? n + 1 : 64, 64);
                break;
            }
            case GREATER_EQUAL: {
                bitSet.set(n <= 64 ? n : 64, 64);
                break;
            }
            case ISMININ: {
                bitSet.set(0);
                break;
            }
            case ISMAXIN: 
            case HASPOSITIONFROMMAX: {
                bitSet.set(0, 64);
                break;
            }
            default: {
                LOGGER.warn("Unsupported operator for study load order condition: {}", (Object)operatorEnum);
            }
        }
    }

    private static int parseInteger(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.error("Illegal format for study load order: {}", (Object)string, (Object)numberFormatException);
            return 0;
        }
    }

    private static boolean isAllowedForAtLeastOneRole(IHangingProtocolDefinition iHangingProtocolDefinition) {
        if (iHangingProtocolDefinition.getHangingAccessAuthorization() != null) {
            int n = 0;
            while (true) {
                ReferencedRole referencedRole;
                if ((referencedRole = iHangingProtocolDefinition.getHangingAccessAuthorization().getReferencedRole(n)) == null) {
                    return false;
                }
                if (Boolean.FALSE.equals(referencedRole.getForbidden())) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private static Condition getStudyLoadOrderCondition(DisplaySetConditionRule displaySetConditionRule) {
        for (ReferencedDescriptor referencedDescriptor : displaySetConditionRule.referencedDescriptorList()) {
            Descriptor descriptor = referencedDescriptor.referencedDescriptor();
            if (descriptor == null || descriptor.conditionCount() <= 0) continue;
            for (Condition condition : descriptor.conditions()) {
                if (condition.getTag() == null || condition.getTag() != PrivateTagDictionary.studyLoadOrderTag) continue;
                return condition;
            }
        }
        return null;
    }
}

