/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.impl;

import com.agfa.hap.pacs.data.valuemapping.ISUVData;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.Dcm4cheUtils;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.instanceinfo.impl.IMPAXEELossyInstanceInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.util.SliceDistanceChecker;
import com.agfa.pacs.impaxee.data.fetcher.IFetchable;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IDisplaySetStatusIcon;
import com.agfa.pacs.impaxee.hanging.IFrameContainer;
import com.agfa.pacs.impaxee.hanging.impl.RelativeFrameLocationCalculator;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.base.data.Orientation;
import com.tiani.jvision.main.DisplaySetProperties;
import com.tiani.jvision.main.DisplaySetType;
import com.tiani.jvision.main.ISecondaryCapture;
import com.tiani.jvision.util.TwoDArrayIterator;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.util.expressions.IEvaluableData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConstantInitializer;
import org.dcm4che3.data.Attributes;

public abstract class AbstractDisplaySet
implements IDisplaySet {
    protected static final IFetcher fetcher = DataManager.getInstance().getFetcher();
    private static final IDicomCache cache = DicomCacheFactory.getInstance().getDicomCache();
    private int id;
    private final ISplitAndSortRuntime decompositionRuntime;
    private AtomicInteger loaded = new AtomicInteger(0);
    private byte currentPriority = (byte)5;
    private boolean loadBySeries = false;
    private List<IFetchable> fetchables;
    private final List<IDisplaySet.ILoadCountListener> listeners = new CopyOnWriteArrayList<IDisplaySet.ILoadCountListener>();
    protected ConcurrentInitializer<IFrameObjectData[][]> frameObjects;
    private double[][] relativeFrameLocations = null;
    private Set<ISeriesData> allSeriesCached = null;
    private String frameOfReferenceUID;
    private String studyIUID;
    private DisplaySetType type;
    private EnumSet<DisplaySetProperties> properties;
    private Orientation orientation;
    private boolean isPrimaryNavigationInSpace = true;
    private int totalNumberOfFrames = -1;
    private boolean isRegular4D;
    private ISUVData suvData;
    private IDisplaySetStatusIcon statusIcon;

    protected AbstractDisplaySet(ISplitAndSortRuntime iSplitAndSortRuntime) {
        this.decompositionRuntime = iSplitAndSortRuntime;
    }

    @Override
    public DisplaySetType getDisplaySetType() {
        if (this.type == null) {
            this.type = this.determineDisplaySetType();
        }
        return this.type;
    }

    @Override
    public EnumSet<DisplaySetProperties> getDisplaySetProperties() {
        if (this.properties == null) {
            this.properties = this.determineDisplaySetProperties();
        }
        return this.properties;
    }

    @Override
    public Orientation getDisplaySetOrientation() {
        if (this.orientation == null) {
            IImageInformation iImageInformation = this.getOneObject().getImageInformation();
            this.orientation = Orientation.getOrientation(iImageInformation);
        }
        return this.orientation;
    }

    private EnumSet<DisplaySetProperties> determineDisplaySetProperties() {
        List<IDisplaySet> list = this.decompositionRuntime.getDisplaySetsOfStudy(this.getStudyUID());
        return DisplaySetProperties.getDisplaySetProperties(this, list);
    }

    private DisplaySetType determineDisplaySetType() {
        IImageInformation iImageInformation = this.getOneObject().getImageInformation();
        return DisplaySetType.getDisplaySetType(iImageInformation);
    }

    @Override
    public String getFrameOfReferenceUID() {
        this.ensureInitialization();
        return this.frameOfReferenceUID;
    }

    private static boolean isSeriesLoadable(IInstanceInfo iInstanceInfo) {
        if (iInstanceInfo == null) {
            return false;
        }
        String string = iInstanceInfo.getType();
        return string.equals("CGET") || string.equals("DICOM");
    }

    @Override
    public synchronized List<IFetchable> getLoadable() {
        if (this.fetchables == null) {
            return Collections.emptyList();
        }
        this.actualizeFetchables();
        return this.fetchables;
    }

    @Override
    public IStudyData getStudy() {
        IFrameObjectData iFrameObjectData = this.getOneObject();
        if (iFrameObjectData != null) {
            return iFrameObjectData.getParent().getParent();
        }
        return null;
    }

    @Override
    public boolean isLoadedBySeries() {
        return this.loadBySeries;
    }

    protected final void init(IFrameContainer iFrameContainer) {
        Object object;
        ArrayList<ISeriesData> arrayList;
        this.isPrimaryNavigationInSpace = iFrameContainer.isPrimaryNavigationInSpace();
        IFrameObjectData[] iFrameObjectDataArray = iFrameContainer.getFirstRun();
        if (iFrameObjectDataArray.length > 50) {
            String string;
            IInstanceInfo iInstanceInfo;
            int n;
            Object object2;
            int n2;
            arrayList = iFrameContainer.getOneObject();
            object = arrayList.getMainFrame();
            IEvaluableData iEvaluableData = arrayList.getImageInformation();
            if (object.getFrameCount() == 1 && iEvaluableData.getRows() <= 512 && iEvaluableData.getColumns() <= 512 && (n2 = (object2 = object.getParent()).getNumberOfFrames()) == iFrameContainer.size() && (n = object2.getDicomObject().getInt(2101769, -1)) > 0 && iFrameContainer.size() == n && AbstractDisplaySet.isSeriesLoadable(iInstanceInfo = object.getLoadableDataInfo().getInstanceInfo()) && !cache.hasDataset(string = arrayList.getLoadableDataInfo().getStudyUID(), iFrameObjectDataArray[40].getSOPInstanceUID())) {
                this.loadBySeries = true;
            }
        }
        if (this.loadBySeries) {
            arrayList = new ArrayList(2);
            arrayList.add(iFrameContainer.getOneObject().getMainFrame().getParent());
        } else {
            object = new LinkedHashSet(iFrameContainer.size());
            for (IEvaluableData iEvaluableData : iFrameContainer) {
                IObjectInfo iObjectInfo;
                IImageObjectData iImageObjectData = iEvaluableData.getMainFrame();
                if (fetcher.isIgnoredSOPClass(iImageObjectData.getSOPClassUID())) continue;
                if (iImageObjectData.isPrefetchingLossyImageEnabled() && ((iObjectInfo = (IObjectInfo)iImageObjectData.getQueryObject()).getInstanceInfo().getType().contains("WADO") || IMPAXEELossyInstanceInfo.singleton.equals(iObjectInfo.getInstanceInfo())) && iEvaluableData.setLossyFetching()) {
                    iObjectInfo.setInstanceInfo((IInstanceInfo)IMPAXEELossyInstanceInfo.singleton);
                }
                ((HashSet)object).add(iImageObjectData);
            }
            arrayList = new ArrayList<ISeriesData>((Collection<ISeriesData>)object);
        }
        this.init(iFrameContainer, (List<IFetchable>)arrayList);
    }

    protected final void init(IFrameContainer iFrameContainer, List<IFetchable> list) {
        this.isPrimaryNavigationInSpace = iFrameContainer.isPrimaryNavigationInSpace();
        if (this.frameObjects == null) {
            this.frameObjects = new ConstantInitializer((Object)iFrameContainer.getFrames());
        }
        this.fetchables = list;
        if (iFrameContainer.isNotEmpty()) {
            this.frameOfReferenceUID = iFrameContainer.getOneObject().getImageInformation().getFrameOfReferenceUID();
            this.studyIUID = iFrameContainer.getOneObject().getImageInformation().getStudyInstanceUID();
            this.relativeFrameLocations = RelativeFrameLocationCalculator.calculateRelativeFrameLocations(iFrameContainer);
            IFrameObjectData[][] iFrameObjectDataArray = iFrameContainer.getFrames();
            HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
            int n = 0;
            while (n < iFrameObjectDataArray.length) {
                int n2 = 0;
                while (n2 < iFrameObjectDataArray[n].length) {
                    hashCodeBuilder.append((Object)iFrameObjectDataArray[n][n2].getKey());
                    ++n2;
                }
                ++n;
            }
            this.id = Math.abs(hashCodeBuilder.toHashCode());
        }
    }

    @Override
    public boolean hasLocationInformation() {
        this.ensureInitialization();
        return this.relativeFrameLocations != null;
    }

    @Override
    public SliceDistanceChecker.SliceDistanceType getUniqueSliceDistances(double[] dArray, double d) {
        this.ensureInitialization();
        return SliceDistanceChecker.getUniqueSliceDistances((double[])this.relativeFrameLocations[0], (double[])dArray, (Double)d);
    }

    @Override
    public double getRelativeSliceLocation(int n, int n2) {
        if (this.isRegular4D()) {
            n = 0;
        }
        if (this.relativeFrameLocations != null) {
            if (n2 >= this.relativeFrameLocations[0].length) {
                return 0.0;
            }
            return this.relativeFrameLocations[n][n2];
        }
        return -1.0;
    }

    private void actualizeFetchables() {
        if (!this.fetchables.isEmpty()) {
            Iterator<IFetchable> iterator = this.fetchables.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isStartedBeingLoaded()) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public IFrameObjectData getOneObject() {
        IFrameObjectData[] iFrameObjectDataArray = this.getObjects();
        if (iFrameObjectDataArray != null && iFrameObjectDataArray.length > 0) {
            int n = iFrameObjectDataArray.length;
            return iFrameObjectDataArray[n > 2 ? 2 : 0];
        }
        return null;
    }

    @Override
    public int getTotalFrameCount() {
        if (this.totalNumberOfFrames < 0) {
            IFrameObjectData[][] iFrameObjectDataArray = this.getFrames();
            this.totalNumberOfFrames = IFrameContainer.getTotalFrameCount(iFrameObjectDataArray);
            this.isRegular4D = this.totalNumberOfFrames == iFrameObjectDataArray.length * iFrameObjectDataArray[0].length;
        }
        return this.totalNumberOfFrames;
    }

    @Override
    public int getRunFrameCount() {
        return this.getObjects().length;
    }

    @Override
    public boolean isEmpty() {
        return this.getTotalFrameCount() == 0;
    }

    @Override
    public boolean isNotEmpty() {
        return this.getTotalFrameCount() > 0;
    }

    @Override
    public boolean isLossyData() {
        IFrameObjectData[][] iFrameObjectDataArray = this.getFrames();
        if (iFrameObjectDataArray != null) {
            for (IFrameObjectData iFrameObjectData : new TwoDArrayIterator<IFrameObjectData>(iFrameObjectDataArray)) {
                if (!iFrameObjectData.isLossyData()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getID() {
        this.ensureInitialization();
        return this.id;
    }

    @Override
    public String getStudyUID() {
        this.ensureInitialization();
        return this.studyIUID;
    }

    @Override
    public void decrementLoadCount() {
        this.loaded.decrementAndGet();
        this.notifyListeners();
    }

    @Override
    public boolean isBeingLoaded() {
        return true;
    }

    @Override
    public boolean isBeingLossyPrefetched() {
        for (IFrameObjectData iFrameObjectData : new TwoDArrayIterator<IFrameObjectData>(this.getFrames())) {
            if (!iFrameObjectData.isBeingLossyPrefetched()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void cancelRetrieve() {
        this.actualizeFetchables();
        if (!this.fetchables.isEmpty()) {
            fetcher.removeDatas(this.fetchables);
        }
        for (ISeriesData iSeriesData : this.getSeriesData()) {
            if (!iSeriesData.isSecondaryCapture() || iSeriesData.isSecondaryCaptureSaved()) continue;
            iSeriesData.setSecondaryCaptureSaved(true);
        }
    }

    @Override
    public void incrementLoadCount() {
        if (this.loaded.incrementAndGet() == 1) {
            this.higherPriorize();
        }
        this.notifyListeners();
    }

    @Override
    public synchronized void setIsActive(boolean bl, boolean bl2) {
        byte by;
        byte by2 = by = bl ? (byte)2 : 4;
        if (bl && bl2) {
            by = 1;
        }
        if (this.currentPriority == by) {
            return;
        }
        this.currentPriority = by;
        if (this.loadBySeries || bl2) {
            this.actualizeFetchables();
            if (this.fetchables.isEmpty()) {
                return;
            }
            List<IFetchable> list = this.fetchables;
            if (bl2) {
                list = new ArrayList<IFetchable>(this.fetchables);
                Collections.reverse(list);
            }
            fetcher.changePriorityIfExists(list, this.currentPriority);
        }
    }

    private synchronized void higherPriorize() {
        this.actualizeFetchables();
        int n = this.fetchables.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        ArrayList<IFetchable> arrayList = new ArrayList<IFetchable>(16);
        ArrayList<IFetchable> arrayList2 = new ArrayList<IFetchable>(64);
        boolean bl = !this.loadBySeries && n > 300;
        int n3 = VisDisplayData.getKeyFrameDistance(n);
        int n4 = n - 1;
        while (n4 >= 0) {
            if (bl) {
                if (n2 % n3 == 0) {
                    arrayList.add(this.fetchables.get(n4));
                } else {
                    arrayList2.add(this.fetchables.get(n4));
                }
            } else {
                arrayList2.add(this.fetchables.get(n4));
            }
            ++n2;
            --n4;
        }
        if (!arrayList.isEmpty()) {
            fetcher.changeToHigherPriorityIfExists(arrayList, (byte)3);
        }
        if (!arrayList2.isEmpty()) {
            fetcher.changeToHigherPriorityIfExists(arrayList2, (byte)4);
        }
    }

    @Override
    public boolean isDisplayedInImageArea() {
        return this.loaded.get() > 0;
    }

    @Override
    public void addLoadCountListener(IDisplaySet.ILoadCountListener iLoadCountListener) {
        this.listeners.add(iLoadCountListener);
    }

    @Override
    public void removeLoadCountListener(IDisplaySet.ILoadCountListener iLoadCountListener) {
        this.listeners.remove(iLoadCountListener);
    }

    private void notifyListeners() {
        for (IDisplaySet.ILoadCountListener iLoadCountListener : this.listeners) {
            iLoadCountListener.notifyLoadCountChange();
        }
    }

    @Override
    public ISplitAndSortRuntime getSplitAndSortRuntime() {
        return this.decompositionRuntime;
    }

    private Collection<ISeriesData> getSeriesData() {
        if (this.allSeriesCached != null) {
            return this.allSeriesCached;
        }
        this.allSeriesCached = new HashSet<ISeriesData>();
        IFrameObjectData[][] iFrameObjectDataArray = this.getFrames();
        if (iFrameObjectDataArray != null) {
            for (IFrameObjectData iFrameObjectData : new TwoDArrayIterator<IFrameObjectData>(iFrameObjectDataArray)) {
                this.allSeriesCached.add(iFrameObjectData.getParent());
            }
        }
        return this.allSeriesCached;
    }

    @Override
    public boolean isSecondaryCaptureSaved() {
        for (ISeriesData iSeriesData : this.getSeriesData()) {
            if (iSeriesData.isSecondaryCaptureSaved()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSecondaryCapture() {
        for (ISeriesData iSeriesData : this.getSeriesData()) {
            if (!iSeriesData.isSecondaryCapture()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSetLiveSecondaryCapture() {
        for (ISeriesData iSeriesData : this.getSeriesData()) {
            if (!iSeriesData.isSetLiveSecondaryCapture()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSecondaryCaptureSaved(boolean bl) {
        for (ISeriesData iSeriesData : this.getSeriesData()) {
            iSeriesData.setSecondaryCaptureSaved(bl);
        }
    }

    @Override
    public void setSecondaryCapture(ISecondaryCapture.SecondaryCaptureType secondaryCaptureType) {
    }

    @Override
    public ISecondaryCapture.SecondaryCaptureType getSecondaryCaptureType() {
        for (ISeriesData iSeriesData : this.getSeriesData()) {
            ISecondaryCapture.SecondaryCaptureType secondaryCaptureType = iSeriesData.getSecondaryCaptureType();
            if (secondaryCaptureType == null) continue;
            return secondaryCaptureType;
        }
        return null;
    }

    @Override
    public void setSUVData(ISUVData iSUVData) {
        this.suvData = iSUVData;
    }

    @Override
    public ISUVData getSUVData() {
        return this.suvData;
    }

    @Override
    public final IFrameObjectData[] getObjects() {
        try {
            return ((IFrameObjectData[][])this.frameObjects.get())[0];
        }
        catch (ConcurrentException concurrentException) {
            return null;
        }
    }

    @Override
    public IFrameObjectData[][] getFrames() {
        try {
            return (IFrameObjectData[][])this.frameObjects.get();
        }
        catch (ConcurrentException concurrentException) {
            return null;
        }
    }

    @Override
    public boolean is4D() {
        try {
            IFrameObjectData[][] iFrameObjectDataArray = (IFrameObjectData[][])this.frameObjects.get();
            return iFrameObjectDataArray.length > 1;
        }
        catch (ConcurrentException concurrentException) {
            return false;
        }
    }

    @Override
    public boolean isRegular4D() {
        this.ensureInitialization();
        return this.isRegular4D;
    }

    @Override
    public boolean isPrimaryNavigationInSpace() {
        this.ensureInitialization();
        return this.isPrimaryNavigationInSpace;
    }

    @Override
    public void setStatusIcon(IDisplaySetStatusIcon iDisplaySetStatusIcon) {
        this.statusIcon = iDisplaySetStatusIcon;
    }

    @Override
    public IDisplaySetStatusIcon getStatusIcon() {
        return this.statusIcon;
    }

    private void ensureInitialization() {
        this.getTotalFrameCount();
    }

    public String toString() {
        Date date;
        String string;
        Attributes attributes = this.getOneObject().getDicomObject();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DisplaySet:");
        stringBuilder.append(this.getID());
        String string2 = attributes.getString(0x200011);
        if (string2 != null) {
            stringBuilder.append(" with series no. ");
            stringBuilder.append(string2);
        }
        if ((string = attributes.getString(528446)) != null) {
            stringBuilder.append(" \"");
            stringBuilder.append(string);
            stringBuilder.append('\"');
        }
        if ((date = Dcm4cheUtils.getDate((int)524321, (Attributes)attributes)) != null) {
            stringBuilder.append(" (");
            stringBuilder.append(DateTimeUtils.date2String((Date)date));
            Date date2 = Dcm4cheUtils.getDate((int)524337, (Attributes)attributes);
            if (date2 != null) {
                stringBuilder.append(' ');
                stringBuilder.append(DateTimeUtils.time2String((Date)date2));
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }
}

