/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.impl;

import com.agfa.pacs.impaxee.hanging.HangingUtil;
import com.agfa.pacs.impaxee.hanging.model.enums.DefaultHangingProtocolType;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.ConditionalHangingScreen;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingDefinition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.model.xml.Layout;
import com.agfa.pacs.impaxee.hanging.model.xml.OrderHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.OrderHangingScreen;
import com.agfa.pacs.impaxee.hanging.model.xml.Snapshot;

public class DefaultHangingProtocol
extends HangingProtocol {
    private DefaultHangingProtocolType type;

    public DefaultHangingProtocol() {
    }

    public DefaultHangingProtocol(DefaultHangingProtocolType defaultHangingProtocolType) {
        this.setType(defaultHangingProtocolType);
        this.checkAndCorrectHP();
    }

    public final void setType(DefaultHangingProtocolType defaultHangingProtocolType) {
        this.type = defaultHangingProtocolType;
    }

    public DefaultHangingProtocolType getType() {
        return this.type;
    }

    public final void checkAndCorrectHP() {
        this.hangingApplicability = null;
        switch (this.type) {
            case BLANK: {
                this.hangingDefinition = null;
                break;
            }
            case USER_DEFINED: {
                Layout layout;
                Snapshot snapshot;
                if (this.hangingDefinition == null) {
                    this.hangingDefinition = new HangingDefinition();
                }
                if ((snapshot = this.hangingDefinition.getSnapshot(0)) == null) {
                    snapshot = HangingUtil.createSnapshot("1");
                }
                this.hangingDefinition.clearSnapshots();
                this.hangingDefinition.addSnapshot(snapshot);
                snapshot.setName("1");
                if (snapshot.getLayout() == null) {
                    snapshot.setLayout(new Layout());
                }
                if ((layout = snapshot.getLayout()) == null) {
                    layout = new Layout();
                    snapshot.setLayout(layout);
                }
                ConditionalHanging conditionalHanging = snapshot.getConditionalHanging();
                OrderHanging orderHanging = snapshot.getOrderHanging();
                if (conditionalHanging != null) {
                    int n;
                    snapshot.setOrderHanging(null);
                    int n2 = layout.screenLayoutCount();
                    int n3 = n = conditionalHanging.screenCount();
                    while (n3 < n2) {
                        conditionalHanging.addConditionalHangingScreen(new ConditionalHangingScreen());
                        ++n3;
                    }
                    n3 = n2;
                    while (n3 < n) {
                        conditionalHanging.addConditionalHangingScreen(null);
                        ++n3;
                    }
                } else if (orderHanging != null) {
                    int n;
                    int n4 = layout.screenLayoutCount();
                    int n5 = n = orderHanging.orderHangingScreenCount();
                    while (n5 < n4) {
                        orderHanging.addOrderHangingScreen(new OrderHangingScreen());
                        ++n5;
                    }
                    n5 = n4;
                    while (n5 < n) {
                        orderHanging.addOrderHangingScreen(null);
                        ++n5;
                    }
                } else {
                    conditionalHanging = new ConditionalHanging();
                    snapshot.setConditionalHanging(new ConditionalHanging());
                    int n = 0;
                    while (n < layout.screenLayoutCount()) {
                        conditionalHanging.addConditionalHangingScreen(new ConditionalHangingScreen());
                        ++n;
                    }
                }
                break;
            }
            case ORDERHANGING_WITHOUT_LAYOUT: {
                Snapshot snapshot;
                if (this.hangingDefinition == null) {
                    this.hangingDefinition = new HangingDefinition();
                }
                if ((snapshot = this.hangingDefinition.getSnapshot(0)) == null) {
                    snapshot = new Snapshot();
                    this.hangingDefinition.addSnapshot(snapshot);
                }
                this.hangingDefinition.clearSnapshots();
                this.hangingDefinition.addSnapshot(snapshot);
                snapshot.setLayout(null);
                snapshot.setName("1");
                snapshot.setConditionalHanging(null);
                OrderHanging orderHanging = snapshot.getOrderHanging();
                if (orderHanging == null) {
                    orderHanging = new OrderHanging();
                    snapshot.setOrderHanging(orderHanging);
                }
                orderHanging.clear();
                orderHanging.setIsReverseDisplayOrder(false);
            }
        }
    }
}

