/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.impl;

import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.config.ConfigUtils;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.model.DisplayState;
import com.agfa.pacs.impaxee.hanging.model.RelativeInteger;
import com.agfa.pacs.impaxee.hanging.model.enums.PrimaryDimension;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.agfa.pacs.impaxee.hanging.runtime.DisplayLayoutRuntime;
import com.agfa.pacs.impaxee.plugin.IAnim2DControl;
import com.agfa.pacs.impaxee.plugin.IDisplayPlugin;
import com.agfa.pacs.impaxee.presentationstate.IPresStateApplicationFinishedListener;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.WindowValue;
import com.tiani.jvision.image.fithandler.ViewportDefinition;
import com.tiani.jvision.main.DisplaySetEvaluable;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.Localizer;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.toptoolbar.FilterActions;
import com.tiani.jvision.toptoolbar.ZoomUtils;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.util.expressions.IEvaluationContext;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;

public class HangingCaseDisplay
implements IPresStateApplicationFinishedListener {
    private static final ALogger LOG = ALogger.getLogger(HangingCaseDisplay.class);
    private static final Object DUMMY_HANGING_SOURCE = new Object();
    private DisplayLayoutRuntime layout;
    private VisDisplay2 display;
    private static final boolean autoStartAnimation = Config.impaxee.jvision.ANIMATION.AutoStart.get();
    private static AtomicInteger counter;
    private static CountDownLatch hpWaiting;

    public HangingCaseDisplay(VisDisplay2 visDisplay2, DisplayLayoutRuntime displayLayoutRuntime) {
        this.layout = displayLayoutRuntime;
        this.display = visDisplay2;
    }

    public DisplayLayoutRuntime getLayoutRuntime() {
        return this.layout;
    }

    public VisDisplay2 getDisplay() {
        return this.display;
    }

    public void hangup(IDisplaySet iDisplaySet, Integer n, RelativeInteger relativeInteger, PrimaryDimension primaryDimension, boolean bl) {
        if (this.layout != null && counter != null) {
            counter.incrementAndGet();
        }
        this.display.initVisDisplay(iDisplaySet, n, relativeInteger, primaryDimension, bl, ActivationMode.HANGUP, this.layout == null ? null : this);
    }

    @Override
    public void notifyPresStateApplied(IPresStateApplicationFinishedListener.ImageModificationFlag ... imageModificationFlagArray) {
        this.applyHangingDisplayState(imageModificationFlagArray);
    }

    public static void prepareWaitForHP() {
        counter = new AtomicInteger();
        hpWaiting = new CountDownLatch(2);
    }

    public static void abortWaitForHP() {
        if (hpWaiting != null) {
            hpWaiting.countDown();
            hpWaiting.countDown();
        }
    }

    public static void setHPPrepareFinished() {
        if (hpWaiting != null) {
            hpWaiting.countDown();
            if (counter.get() == 0) {
                hpWaiting.countDown();
            }
        }
        if (autoStartAnimation) {
            IDisplayPlugin iDisplayPlugin = null;
            IAnim2DControl iAnim2DControl = null;
            for (VisScreen2 visScreen2 : JVision2.getMainFrame().getScreens()) {
                for (VisDisplay2 visDisplay2 : visScreen2.getDisplays()) {
                    if (!visDisplay2.getData().hasData() || !((iDisplayPlugin = visDisplay2.getData().getDisplayPlugin()) instanceof IAnim2DControl)) continue;
                    iAnim2DControl = (IAnim2DControl)((Object)iDisplayPlugin);
                    break;
                }
                if (iAnim2DControl != null) break;
            }
            if (iAnim2DControl != null) {
                LOG.info("Auto-start animation");
                iAnim2DControl.animate(true);
            }
        }
    }

    public static final void waitForHP(long l) {
        if (hpWaiting == null) {
            LOG.error("Waiter not correctly initialised");
            return;
        }
        try {
            if (!hpWaiting.await(l, TimeUnit.MILLISECONDS)) {
                LOG.warn("Time-out elapsed on HP waiting");
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void applyHorizonalFlip(VisDisplay2 visDisplay2) {
        TEvent tEvent = new TEvent(8);
        TEventDispatch.sendEventToVis(visDisplay2, tEvent, DUMMY_HANGING_SOURCE, 16);
    }

    public static void applyImageInvert(VisDisplay2 visDisplay2) {
        TEvent tEvent = new TEvent(6);
        TEventDispatch.sendEventToVis(visDisplay2, tEvent, null, 16);
    }

    public static void applyZoomMode(VisDisplay2 visDisplay2, ZoomMode zoomMode, double d) {
        ZoomUtils.setZoomMode(visDisplay2, zoomMode);
        TEvent tEvent = new TEvent(2);
        if (!(zoomMode != ZoomMode.NORMAL && zoomMode != ZoomMode.PIXELIDENTITY || DoubleEquals.equals((double)d, (double)0.0))) {
            TEventDispatch.sendEventToVis(visDisplay2, tEvent, ZoomParameter.absolute(d), 16);
        }
    }

    private void applyHangingDisplayState(IPresStateApplicationFinishedListener.ImageModificationFlag ... imageModificationFlagArray) {
        Object object;
        Object object2;
        Object object3;
        if (this.layout == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        ZoomMode zoomMode = null;
        boolean bl3 = false;
        IFrameObjectData iFrameObjectData = this.display.getData().getFirstVis().getFrameData();
        if (iFrameObjectData != null && (object3 = ConfigUtils.getFirstMatchOfList((IEvaluationContext)(object2 = new DisplaySetEvaluable(iFrameObjectData, this.display.getData().getDisplaySet())), Config.impaxee.jvision.PLUGINS.autoUsePlugin.getList(), null, "conditionText")) != null) {
            object = object3.getString("pluginName");
            PluginName pluginName = PluginName.getItemWithName((String)object);
            if (pluginName == PluginName.INVERT) {
                bl = true;
            } else if (pluginName == PluginName.TRUESIZE_ZOOM) {
                zoomMode = ZoomMode.TRUESIZE;
            } else if (pluginName == PluginName.PIXELIDENTITY_ZOOM) {
                zoomMode = ZoomMode.PIXELIDENTITY;
            } else if (pluginName == PluginName.FLIP) {
                bl2 = true;
            } else if (pluginName == PluginName.LOCALIZER) {
                bl3 = true;
            }
        }
        object2 = null;
        if (this.display.getData() != null && this.display.getData().getFirstVis() != null) {
            object2 = new DisplayState();
            this.display.getData().getFirstVis().saveDisplayState((DisplayState)object2);
        }
        if (!ArrayUtils.contains((Object[])imageModificationFlagArray, (Object)((Object)IPresStateApplicationFinishedListener.ImageModificationFlag.SPATIAL_TRANSFORMATION))) {
            Object object4;
            int n = 0;
            if (object2 != null && ((DisplayState)object2).getImageRotation() != null) {
                n = ((DisplayState)object2).getImageRotation();
            }
            this.rotate(n, 0);
            object = this.layout.getDisplayState().getImageRotation();
            if (object != null && (Integer)object != 0) {
                this.rotate(0, (Integer)object);
            }
            if ((bl2 |= Boolean.TRUE.equals(this.layout.getDisplayState().getImageHorizontalFlip())) && object2 != null) {
                boolean bl4 = Boolean.TRUE.equals(((DisplayState)object2).getImageHorizontalFlip());
                if (bl4 != bl2) {
                    HangingCaseDisplay.applyHorizonalFlip(this.display);
                }
            } else if (bl2) {
                HangingCaseDisplay.applyHorizonalFlip(this.display);
            }
            TEvent tEvent = new TEvent(17);
            Double d = this.layout.getDisplayState().getViewPortCenterX();
            Double d2 = this.layout.getDisplayState().getViewPortCenterY();
            if (DoubleEquals.equals((double)d, (double)0.0) && DoubleEquals.equals((double)d2, (double)0.0)) {
                d = 0.5;
                d2 = 0.5;
            }
            d = this.roundViewPortCenter(d);
            d2 = this.roundViewPortCenter(d2);
            if (!DoubleEquals.equals((double)d, (double)0.5) || !DoubleEquals.equals((double)d2, (double)0.5)) {
                object4 = ViewportDefinition.getImageAbsoluteNormalized(d, d2);
                TEventDispatch.sendEventToVis(this.display, tEvent, object4, 16);
            }
            if ((object4 = this.layout.getDisplayState().getViewPortCenterAlignmentX()) != null) {
                TEventDispatch.sendEventToVis(this.display, new TEvent(132), object4, 16);
            }
            if (object == null || (Integer)object == 0) {
                this.rotate(0, n);
            }
        }
        if ((object3 = this.layout.getDisplayState().getZoomMode()) == ZoomMode.NORMAL && zoomMode != null) {
            object3 = zoomMode;
        }
        double d = this.layout.getDisplayState().getMagnificationRatio();
        if (object3 != ZoomMode.NORMAL || !DoubleEquals.equals((double)d, (double)0.0)) {
            HangingCaseDisplay.applyZoomMode(this.display, (ZoomMode)((Object)object3), d);
        }
        if ((bl |= Boolean.TRUE.equals(this.layout.getDisplayState().getImageInvert())) && object2 != null) {
            boolean bl5;
            boolean bl6 = bl5 = Boolean.TRUE.equals(((DisplayState)object2).getImageInvert()) || ArrayUtils.contains((Object[])imageModificationFlagArray, (Object)((Object)IPresStateApplicationFinishedListener.ImageModificationFlag.IMAGE_INVERSION));
            if (bl5 != bl) {
                HangingCaseDisplay.applyImageInvert(this.display);
            }
        } else if (bl) {
            HangingCaseDisplay.applyImageInvert(this.display);
        }
        this.enableLocalizer(bl3);
        this.applyWindowLevel();
        boolean bl7 = this.layout.getDisplayState().getSynced();
        if (bl7) {
            this.display.getSynchronizationManager().enableSynchronizationWithCurrentNavigationPositionAsReferencePosition();
        }
        this.applyFilter();
        if (counter != null && counter.decrementAndGet() == 0 && hpWaiting.getCount() < 2L) {
            hpWaiting.countDown();
        }
    }

    private void enableLocalizer(boolean bl) {
        boolean bl2;
        TEvent tEvent;
        View view;
        if (bl && this.display.hasData() && (view = this.display.getVis(0).getView()) instanceof ImgView2 && ((ImgView2)view).canHaveLocalizer()) {
            tEvent = new TEvent(116);
            TEventDispatch.sendEventToVis(this.display, tEvent, (Object)Localizer.LocalizerState.UserForcedOn, 16);
        }
        if (bl2 = Boolean.TRUE.equals(this.layout.getDisplayState().getLocalizerEnabled())) {
            tEvent = new TEvent(116);
            TEventDispatch.sendEventToVis(this.display, tEvent, (Object)Localizer.LocalizerState.UserForcedOn, 16);
        }
    }

    private void applyWindowLevel() {
        Double d = this.layout.getDisplayState().getWindowCenter();
        Double d2 = this.layout.getDisplayState().getWindowWidth();
        Boolean bl = this.layout.getDisplayState().getUseWindowLevel();
        if (bl.booleanValue() && d != null && d2 != null) {
            this.display.onWindowingValueChange(new WindowValue(d, d2), 16, this);
        }
    }

    private void applyFilter() {
        FilterActions.FilterType filterType = FilterActions.FilterType.parse(this.layout.getDisplayState().getFilterName());
        if (filterType != FilterActions.FilterType.None) {
            TEvent tEvent = new TEvent(12);
            TEventDispatch.sendEventToVis(this.display, tEvent, (Object)filterType, 16);
            FilterActions.updateSelectionState(this.display, filterType);
        }
    }

    private Double roundViewPortCenter(Double d) {
        if (d != null && Math.abs(d - 0.5) < 0.005) {
            return 0.5;
        }
        return d;
    }

    private void rotate(int n, int n2) {
        int n3 = n2 - n;
        if (n3 > 0) {
            this.sendRotateEvent(n3, 10);
        } else if (n3 < 0) {
            this.sendRotateEvent(-n3, 9);
        }
    }

    private void sendRotateEvent(int n, int n2) {
        TEvent tEvent = new TEvent(n2);
        int n3 = 0;
        while (n3 < n / 90) {
            TEventDispatch.sendEventToVis(this.display, tEvent, null, 16);
            ++n3;
        }
    }
}

