/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.impl;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.impaxee.data.fetcher.IFetchable;
import com.agfa.pacs.impaxee.data.fetcher.IFetcher;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.IDataManagerListener;
import com.agfa.pacs.impaxee.hanging.HPEvaluationThread;
import com.agfa.pacs.impaxee.hanging.HangingType;
import com.agfa.pacs.impaxee.hanging.HangingUtil;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.impl.HangingFactory;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.registry.HPRegistry;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.UserDefinedHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortManager;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.impaxee.sync.StudyLinkageInfo;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.vecmath.Vector3d;
import org.dcm4che3.data.Attributes;

class ImpaxEEPatientRepresentation
implements IPatientRepresentation {
    private static final ALogger log = ALogger.getLogger(ImpaxEEPatientRepresentation.class);
    private static final IFetcher fetcher = DataManager.getInstance().getFetcher();
    private IPatientData patientData;
    private volatile boolean isLoading = false;
    private List<IHanging> hangings = new CopyOnWriteArrayList<IHanging>();
    private List<IStudyContainer> studyContainers;
    private Set<String> checkedContainers = new HashSet<String>();
    private ISplitAndSortRuntime defaultDecompositionRuntime;
    private IHanging activeHanging = null;
    private int loadedInstances = 0;
    private Session temporarySession;
    private Lock loadingLock = new ReentrantLock();
    private Cancelable hpEvaluationThread;
    private Map<String, StudyLinkageInfo> frameReferenceLinkages = new HashMap<String, StudyLinkageInfo>();
    private String loggingKey;

    ImpaxEEPatientRepresentation(IPatientData iPatientData) {
        this.patientData = iPatientData;
        this.studyContainers = new CopyOnWriteArrayList<IStudyContainer>();
        this.loggingKey = PatientKeyUtils.generatePatientKey((String)iPatientData.getDicomObject().getString(0x100020), null, (String)iPatientData.getDicomObject().getString(0x100021));
    }

    public void init() {
        this.defaultDecompositionRuntime = SplitAndSortManager.getInstance().getAppropriateSplitAndSortRuntime(this);
    }

    @Override
    public synchronized IHanging applyHangingProtocol(HangingProtocol hangingProtocol, IStudyContainer iStudyContainer) {
        HangingProtocolRuntime hangingProtocolRuntime = HangingFactory.getInstance().newHangingCase(iStudyContainer, hangingProtocol);
        if (!this.isSameHangingInAlready(hangingProtocol, iStudyContainer)) {
            this.sortIntoHangingList(hangingProtocolRuntime);
            return hangingProtocolRuntime;
        }
        return null;
    }

    @Override
    public IPatientData getPatientData() {
        return this.patientData;
    }

    @Override
    public String getPatientKey() {
        return this.patientData.getKey();
    }

    @Override
    public int countHangings() {
        return this.hangings.size();
    }

    @Override
    public List<IHangingSession> getSessions() {
        ArrayList<IHangingSession> arrayList = new ArrayList<IHangingSession>();
        for (IHanging iHanging : this.hangings) {
            if (!(iHanging instanceof IHangingSession)) continue;
            arrayList.add((IHangingSession)iHanging);
        }
        return arrayList;
    }

    @Override
    public synchronized void addLinkageInformation(IDisplaySet iDisplaySet, IDisplaySet iDisplaySet2, Vector3d vector3d) {
        StudyLinkageInfo studyLinkageInfo = this.frameReferenceLinkages.get(StudyLinkageInfo.getFrameOfReference(iDisplaySet));
        if (studyLinkageInfo == null) {
            studyLinkageInfo = new StudyLinkageInfo();
            this.frameReferenceLinkages.put(StudyLinkageInfo.getFrameOfReference(iDisplaySet), studyLinkageInfo);
        }
        studyLinkageInfo.addLinkage(iDisplaySet2, vector3d);
        studyLinkageInfo = this.frameReferenceLinkages.get(StudyLinkageInfo.getFrameOfReference(iDisplaySet2));
        if (studyLinkageInfo == null) {
            studyLinkageInfo = new StudyLinkageInfo();
            this.frameReferenceLinkages.put(StudyLinkageInfo.getFrameOfReference(iDisplaySet2), studyLinkageInfo);
        }
        Vector3d vector3d2 = new Vector3d(vector3d);
        vector3d2.negate();
        studyLinkageInfo.addLinkage(iDisplaySet, vector3d2);
    }

    @Override
    public synchronized void removeLinkageInformation(IDisplaySet iDisplaySet) {
        StudyLinkageInfo studyLinkageInfo = this.frameReferenceLinkages.get(StudyLinkageInfo.getFrameOfReference(iDisplaySet));
        if (studyLinkageInfo != null) {
            List<String> list = studyLinkageInfo.removeLinkage(iDisplaySet);
            for (String string : list) {
                this.frameReferenceLinkages.get(string).removeLinkage(iDisplaySet);
            }
        }
    }

    @Override
    public synchronized StudyLinkageInfo getLinkage(IDisplaySet iDisplaySet) {
        return this.frameReferenceLinkages.get(StudyLinkageInfo.getFrameOfReference(iDisplaySet));
    }

    @Override
    public void setLoadPriority(final Byte by) {
        Object object;
        if (!this.isLoading && by == null) {
            return;
        }
        if (this.getDecompositionRuntime() == null) {
            return;
        }
        final ArrayList<IFetchable> arrayList = new ArrayList<IFetchable>(64);
        IDisplaySet[] iDisplaySetArray = this.getDecompositionRuntime().getDisplaySets();
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iDisplaySetArray[n2];
            arrayList.addAll(object.getLoadable());
            ++n2;
        }
        if (arrayList.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.info("Repriorize " + arrayList.size() + " objects from queue belonging to patient " + this.loggingKey + " to " + by);
        }
        object = new Runnable(){

            @Override
            public void run() {
                if (by == null) {
                    ImpaxEEPatientRepresentation.this.isLoading = false;
                    fetcher.removeDatas(arrayList);
                } else if (!ImpaxEEPatientRepresentation.this.isLoading) {
                    ImpaxEEPatientRepresentation.this.isLoading = true;
                    fetcher.appendData(arrayList, by);
                } else {
                    fetcher.changePriorityIfExists(arrayList, by);
                }
            }
        };
        if (!this.isLoading && by == 5) {
            object.run();
        } else {
            new Thread((Runnable)object, "LoadingPrioritize").start();
        }
    }

    @Override
    public List<IStudyContainer> getStudyContainers() {
        return Collections.unmodifiableList(this.studyContainers);
    }

    @Override
    public IHanging getDefaultHanging() {
        if (this.hangings.isEmpty()) {
            return null;
        }
        for (IHanging iHanging : this.hangings) {
            if (!(iHanging instanceof IHangingSession)) continue;
            return iHanging;
        }
        return this.hangings.get(0);
    }

    @Override
    public IHanging getHanging(int n) {
        return this.hangings.get(n);
    }

    @Override
    public IHanging getHanging(String string) {
        for (IHanging iHanging : this.hangings) {
            if (!iHanging.getIdentifier().equals(string)) continue;
            return iHanging;
        }
        return null;
    }

    @Override
    public boolean containsHanging(IHanging iHanging) {
        return this.hangings.indexOf(iHanging) >= 0;
    }

    @Override
    public IHanging getActiveHanging() {
        return this.activeHanging;
    }

    @Override
    public boolean setActiveHanging(IHanging iHanging) {
        if (iHanging == null) {
            this.activeHanging = null;
            return true;
        }
        if (!this.hangings.contains(iHanging)) {
            return false;
        }
        this.activeHanging = iHanging;
        return true;
    }

    private IHanging getHangingState(String string) {
        IHanging iHanging = null;
        for (IHanging iHanging2 : this.hangings) {
            if (iHanging2.getIdentifier() == null || !string.equals(iHanging2.getIdentifier())) continue;
            iHanging = iHanging2;
            break;
        }
        return iHanging;
    }

    private boolean isSameHangingInAlready(HangingProtocol hangingProtocol, IStudyContainer iStudyContainer) {
        for (IHanging iHanging : this.hangings) {
            UserDefinedHangingProtocolRuntime userDefinedHangingProtocolRuntime;
            if (!(iHanging instanceof UserDefinedHangingProtocolRuntime) || (userDefinedHangingProtocolRuntime = (UserDefinedHangingProtocolRuntime)iHanging).getHangingProtocol() != hangingProtocol) continue;
            return userDefinedHangingProtocolRuntime.getStudyContainer() == iStudyContainer;
        }
        return false;
    }

    @Override
    public IHanging removeHanging(String string) {
        IHanging iHanging = this.getHangingState(string);
        if (iHanging != null) {
            if (this.activeHanging != null && string.equals(this.activeHanging.getIdentifier())) {
                this.activeHanging = null;
            }
            return this.hangings.remove(iHanging) ? iHanging : null;
        }
        return null;
    }

    @Override
    public void addHanging(IHanging iHanging) {
        if (iHanging instanceof IHangingSession) {
            String string = iHanging.getIdentifier();
            for (IHanging iHanging2 : this.hangings) {
                if (!iHanging2.getIdentifier().equals(string)) continue;
                return;
            }
        }
        this.sortIntoHangingList(iHanging);
    }

    @Override
    public String toLoggingString() {
        return this.loggingKey;
    }

    public String toString() {
        return this.getPatientKey();
    }

    @Override
    public void cleanUp() {
        this.activeHanging = null;
        this.hangings.clear();
        if (this.hpEvaluationThread != null) {
            this.hpEvaluationThread.cancel();
        }
        if (this.patientData != null) {
            this.patientData.cleanUp();
        }
        for (IStudyContainer iStudyContainer : this.studyContainers) {
            iStudyContainer.cleanUp();
        }
        this.studyContainers.clear();
        this.isLoading = false;
        this.defaultDecompositionRuntime = null;
        this.temporarySession = null;
        this.frameReferenceLinkages.clear();
    }

    @Override
    public synchronized void startHPEvaluation(List<HangingProtocol> list, IStudyContainer iStudyContainer) {
        if (this.hpEvaluationThread != null) {
            this.hpEvaluationThread.cancel();
        }
        if (list == null) {
            list = HPRegistry.getInstance().getActiveHangingProtocolsForCurrentRole();
        }
        HPEvaluationThread hPEvaluationThread = new HPEvaluationThread(list, this, iStudyContainer != null);
        if (iStudyContainer != null) {
            hPEvaluationThread.setStudyContainer(iStudyContainer);
        }
        hPEvaluationThread.start();
        this.hpEvaluationThread = hPEvaluationThread;
    }

    @Override
    public boolean hasRunningHPEvaluation() {
        return this.hpEvaluationThread != null && this.hpEvaluationThread.isRunning();
    }

    @Override
    public ISplitAndSortRuntime getDecompositionRuntime() {
        return this.defaultDecompositionRuntime;
    }

    @Override
    public synchronized void addStudyContainer(IStudyContainer iStudyContainer) {
        this.studyContainers.add(iStudyContainer);
        iStudyContainer.setPatientRepresentation(this);
    }

    @Override
    public void updateStudyContainers() {
        Object object;
        Iterator<IStudyContainer> iterator = this.studyContainers.iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (this.patientData.getStudy(object.getBaseStudy().getKey()) != null) continue;
            arrayList.add(object);
        }
        this.studyContainers.removeAll(arrayList);
        object = new HashSet();
        for (IStudyData object2 : this.patientData.getStudies()) {
            object.add(object2.getKey());
        }
        for (IStudyContainer iStudyContainer : this.studyContainers) {
            iStudyContainer.updateLoadedPriors((Set<String>)object);
        }
        if (!arrayList.isEmpty()) {
            Iterator<IHanging> iterator2 = this.hangings.iterator();
            ArrayList arrayList2 = new ArrayList();
            while (iterator2.hasNext()) {
                IHanging iHanging = iterator2.next();
                if (!arrayList.contains(iHanging.getStudyContainer())) continue;
                arrayList2.add(iHanging);
            }
            HangingUtil.dismissHangings(this, arrayList2);
        }
    }

    @Override
    public IStudyContainer getStudyContainerForStudyKey(String string) {
        for (IStudyContainer iStudyContainer : this.studyContainers) {
            if (!iStudyContainer.hasStudy(string)) continue;
            return iStudyContainer;
        }
        return null;
    }

    @Override
    public boolean hasContainerForStudy(String string) {
        for (IStudyContainer iStudyContainer : this.studyContainers) {
            if (!iStudyContainer.getBaseStudy().getKey().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized List<IStudyContainer> getUncheckedStudyContainers() {
        ArrayList<IStudyContainer> arrayList = new ArrayList<IStudyContainer>();
        for (IStudyContainer iStudyContainer : this.studyContainers) {
            if (this.checkedContainers.contains(iStudyContainer.getId())) continue;
            arrayList.add(iStudyContainer);
            this.checkedContainers.add(iStudyContainer.getId());
        }
        return arrayList;
    }

    @Override
    public synchronized IStudyContainer getFirstUncheckedStudyContainer() {
        IStudyContainer iStudyContainer = this.peekFirstUncheckedStudyContainer();
        if (iStudyContainer != null) {
            this.checkedContainers.add(iStudyContainer.getId());
        }
        return iStudyContainer;
    }

    @Override
    public IStudyContainer peekFirstUncheckedStudyContainer() {
        for (IStudyContainer iStudyContainer : this.studyContainers) {
            if (this.checkedContainers.contains(iStudyContainer.getId())) continue;
            return iStudyContainer;
        }
        return null;
    }

    @Override
    public synchronized boolean hasUncheckedStudyContainers() {
        for (IStudyContainer iStudyContainer : this.studyContainers) {
            if (this.checkedContainers.contains(iStudyContainer.getId())) continue;
            return true;
        }
        return false;
    }

    private void sortIntoHangingList(IHanging iHanging) {
        try {
            int n = Collections.binarySearch(this.hangings, iHanging, HangingComparator.instance);
            n = n < 0 ? -n - 1 : n;
            this.hangings.add(n, iHanging);
        }
        catch (Exception exception) {
            log.warn("Sorting hanging into hanging list failed, adding at end of list: " + iHanging, (Throwable)exception);
            this.hangings.add(iHanging);
        }
        if (iHanging instanceof IDataManagerListener) {
            DataManager.getInstance().addListener((IDataManagerListener)((Object)iHanging));
        }
    }

    @Override
    public synchronized void updateObjectCount() {
        this.loadedInstances = 0;
        for (IStudyData iStudyData : this.patientData.getStudies()) {
            for (ISeriesData iSeriesData : iStudyData.getSeries()) {
                this.loadedInstances += iSeriesData.getNumberOfFrames();
            }
        }
    }

    @Override
    public int getNumberOfInstances() {
        return this.loadedInstances;
    }

    @Override
    public int getNumberOfStudieContainers() {
        return this.studyContainers.size();
    }

    @Override
    public void createTemporarySession() {
        Session session = new Session(HangingUtil.createSessionName(), this, new Date(), false);
        AbstractSnapshotRuntime abstractSnapshotRuntime = session.getSnapshotModel().newInstance();
        session.getSnapshotModel().insertAt(0, abstractSnapshotRuntime);
        this.temporarySession = session;
    }

    @Override
    public Session removeTemporarySession() {
        Session session = this.temporarySession;
        this.temporarySession = null;
        return session;
    }

    @Override
    public Lock getPatientModificationLock() {
        return this.loadingLock;
    }

    private static class HangingComparator
    implements Comparator<IHanging> {
        private static final HangingComparator instance = new HangingComparator();

        private HangingComparator() {
        }

        @Override
        public int compare(IHanging iHanging, IHanging iHanging2) {
            HangingType hangingType;
            HangingType hangingType2 = iHanging.getHangingType();
            if (hangingType2 == (hangingType = iHanging2.getHangingType())) {
                if (hangingType2 == HangingType.SESSION) {
                    Date date = ((Session)iHanging).getDateTime();
                    Date date2 = ((Session)iHanging2).getDateTime();
                    int n = CompareUtils.compareAdvanced((Comparable)date2, (Comparable)date);
                    if (n == 0) {
                        n = this.compareSessionNames(iHanging, iHanging2);
                    }
                    return n;
                }
                if (hangingType2 == HangingType.USER_HP) {
                    UserDefinedHangingProtocolRuntime userDefinedHangingProtocolRuntime = (UserDefinedHangingProtocolRuntime)iHanging;
                    UserDefinedHangingProtocolRuntime userDefinedHangingProtocolRuntime2 = (UserDefinedHangingProtocolRuntime)iHanging2;
                    IStudyData iStudyData = userDefinedHangingProtocolRuntime.getBaseStudyData();
                    IStudyData iStudyData2 = userDefinedHangingProtocolRuntime2.getBaseStudyData();
                    Date date = DateTimeUtils.getStudyDateTime((Attributes)iStudyData.getDicomObject());
                    Date date3 = DateTimeUtils.getStudyDateTime((Attributes)iStudyData2.getDicomObject());
                    int n = CompareUtils.compareAdvanced((Comparable)date3, (Comparable)date);
                    if (n != 0) {
                        return n;
                    }
                    n = iStudyData.getKey().compareTo(iStudyData2.getKey());
                    if (n != 0) {
                        return n;
                    }
                    n = CompareUtils.compareAdvanced((Comparable)userDefinedHangingProtocolRuntime.getPriority(), (Comparable)userDefinedHangingProtocolRuntime2.getPriority());
                    if (n != 0) {
                        return n;
                    }
                    return this.compareSessionNames(iHanging, iHanging2);
                }
            }
            return Integer.compare(hangingType2.getPriority(), hangingType.getPriority());
        }

        private int compareSessionNames(IHanging iHanging, IHanging iHanging2) {
            String string = iHanging.getVisibleName();
            String string2 = iHanging2.getVisibleName();
            if (string == null) {
                if (string2 == null) {
                    return 0;
                }
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            Collator collator = Collator.getInstance();
            collator.setStrength(0);
            return collator.compare(string, string2);
        }
    }
}

