/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.impl;

import com.agfa.pacs.impaxee.hanging.IFrameContainer;
import com.agfa.pacs.listtext.dicomobject.type.ImageType;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;

class RelativeFrameLocationCalculator {
    private static final ALogger LOGGER = ALogger.getLogger(RelativeFrameLocationCalculator.class);
    private final double[][] relativeFrameLocations;

    private RelativeFrameLocationCalculator(double[][] dArray) {
        this.relativeFrameLocations = dArray;
    }

    static double[][] calculateRelativeFrameLocations(IFrameContainer iFrameContainer) {
        IFrameObjectData[][] iFrameObjectDataArray = iFrameContainer.getFrames();
        int n = IFrameContainer.getTotalFrameCount(iFrameObjectDataArray);
        if (n == 0) {
            return null;
        }
        boolean bl = n == iFrameObjectDataArray.length * iFrameObjectDataArray[0].length;
        double[][] dArray = RelativeFrameLocationCalculator.calculateAbsoluteDistances(iFrameObjectDataArray, bl);
        if (dArray != null && iFrameContainer.getOneObject().getImageInformation().getSliceThickness() == null) {
            RelativeFrameLocationCalculator relativeFrameLocationCalculator = new RelativeFrameLocationCalculator(dArray);
            int n2 = 0;
            while (n2 < iFrameObjectDataArray[0].length - 1) {
                int n3 = 0;
                while (n3 < iFrameObjectDataArray.length) {
                    iFrameObjectDataArray[n3][n2].getImageInformation().setSliceThickness(relativeFrameLocationCalculator.getSliceDistance(bl ? 0 : n3, n2));
                    ++n3;
                }
                ++n2;
            }
        }
        return dArray;
    }

    private double getSliceDistance(int n, int n2) {
        if (n2 == 0) {
            return Math.abs(this.relativeFrameLocations[n][0] - this.relativeFrameLocations[n][1]);
        }
        if (n2 == this.relativeFrameLocations[n].length - 1) {
            return Math.abs(this.relativeFrameLocations[n][n2 - 1] - this.relativeFrameLocations[n][n2]);
        }
        return (Math.abs(this.relativeFrameLocations[n][n2] - this.relativeFrameLocations[n][n2 - 1]) + Math.abs(this.relativeFrameLocations[n][n2] - this.relativeFrameLocations[n][n2 + 1])) / 2.0;
    }

    private static double[][] calculateAbsoluteDistances(IFrameObjectData[][] iFrameObjectDataArray, boolean bl) {
        double[] dArray;
        Object object = iFrameObjectDataArray.length == 1 || bl ? (Object)((dArray = RelativeFrameLocationCalculator.calculateAbsoluteDistances(iFrameObjectDataArray[0])) == null ? null : (Object)new double[][]{dArray}) : RelativeFrameLocationCalculator.calculateAbsoluteDistances4D(iFrameObjectDataArray);
        return object;
    }

    private static double[] calculateAbsoluteDistances(IFrameObjectData[] iFrameObjectDataArray) {
        int n;
        boolean bl = true;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < iFrameObjectDataArray.length) {
            IImageInformation iImageInformation = iFrameObjectDataArray[n2].getImageInformation();
            if (iImageInformation == null) {
                return null;
            }
            double[] dArray = iImageInformation.getImagePosition();
            if (dArray == null || dArray.length != 3) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (!bl) {
            bl2 = true;
            n2 = 0;
            while (n2 < iFrameObjectDataArray.length) {
                if (!iFrameObjectDataArray[n2].getDicomObject().containsValue(2101313)) {
                    bl2 = false;
                    break;
                }
                ++n2;
            }
        }
        double[] dArray = new double[iFrameObjectDataArray.length];
        double d = Double.MAX_VALUE;
        if (bl) {
            boolean bl3 = true;
            int n3 = 0;
            while (n3 < iFrameObjectDataArray.length) {
                if (!iFrameObjectDataArray[n3].getImageInformation().isLocalizer() && !iFrameObjectDataArray[n3].getImageInformation().getImageType().contains(ImageType.SCOUT)) break;
                ++n3;
            }
            if (n3 == iFrameObjectDataArray.length) {
                return null;
            }
            double[] dArray2 = iFrameObjectDataArray[n3].getImageInformation().getImagePosition();
            int n4 = 0;
            while (n4 < iFrameObjectDataArray.length) {
                IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n4];
                double[] dArray3 = iFrameObjectData.getImageInformation().getImagePosition();
                dArray[n4] = Math.sqrt((dArray3[0] - dArray2[0]) * (dArray3[0] - dArray2[0]) + (dArray3[1] - dArray2[1]) * (dArray3[1] - dArray2[1]) + (dArray3[2] - dArray2[2]) * (dArray3[2] - dArray2[2]));
                if (!DoubleEquals.equals((double)dArray[n4], (double)0.0)) {
                    bl3 = false;
                }
                ++n4;
            }
            if (bl3) {
                dArray = null;
            }
            return dArray;
        }
        if (bl2) {
            try {
                n = 0;
                while (n < iFrameObjectDataArray.length) {
                    IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n];
                    dArray[n] = iFrameObjectData.getImageInformation().getSliceLocation();
                    if (dArray[n] < d) {
                        d = dArray[n];
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Slice location not available.", (Throwable)exception);
                return null;
            }
        }
        if (bl2) {
            n = 0;
            while (n < iFrameObjectDataArray.length) {
                int n5 = n++;
                dArray[n5] = dArray[n5] - d;
            }
            return dArray;
        }
        return null;
    }

    private static double[][] calculateAbsoluteDistances4D(IFrameObjectData[][] iFrameObjectDataArray) {
        double[][] dArrayArray = new double[iFrameObjectDataArray.length][];
        int n = 0;
        IFrameObjectData[][] iFrameObjectDataArray2 = iFrameObjectDataArray;
        int n2 = iFrameObjectDataArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IFrameObjectData[] iFrameObjectDataArray3 = iFrameObjectDataArray2[n3];
            dArrayArray[n] = RelativeFrameLocationCalculator.calculateAbsoluteDistances(iFrameObjectDataArray3);
            if (dArrayArray[n] == null) {
                return null;
            }
            ++n3;
        }
        return dArrayArray;
    }
}

