/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.model.xml;

import com.agfa.pacs.impaxee.hanging.gui.ConditionListEntry;
import com.agfa.pacs.impaxee.hanging.model.AbstractTag;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.ISeriesData;
import com.tiani.jvision.main.DisplaySetEvaluable;
import com.tiani.util.expressions.BooleanNode;
import com.tiani.util.expressions.DataEvaluationContext;
import com.tiani.util.expressions.IEvaluationContext;
import com.tiani.util.expressions.OperatorEnum;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public final class Condition
extends AbstractTag {
    private static final String xmlName = Condition.classBaseName(Condition.class);
    private static final Map<Condition, BooleanNode> conditionCache = new ConcurrentHashMap<Condition, BooleanNode>(256, 0.75f, 4);
    private OperatorEnum operator = OperatorEnum.EQUAL;
    private String value = "";

    public Condition() {
    }

    public Condition(Integer n, OperatorEnum operatorEnum, String string) {
        this.setTag(n);
        this.setOperator(operatorEnum);
        this.setValue(string);
    }

    @Override
    public final void setTag(Integer n) {
        conditionCache.remove((Object)this);
        super.setTag(n);
    }

    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operatorEnum) {
        conditionCache.remove((Object)this);
        this.operator = operatorEnum;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        conditionCache.remove((Object)this);
        this.value = string == null ? "" : string;
    }

    private static String getTag(IDataObject iDataObject, int n) {
        if (n == 524384) {
            return iDataObject.getModality();
        }
        if (n == 528446) {
            return iDataObject.getSeriesDescription();
        }
        if (n == 528432) {
            return iDataObject.getDicomObject().getString(528432);
        }
        if (n == 524296) {
            if (iDataObject instanceof ISeriesData) {
                iDataObject = ((ISeriesData)iDataObject).getFirstObject();
            }
            return Arrays.toString(iDataObject.getDicomObject().getStrings(n));
        }
        if (n == 524310) {
            if (iDataObject instanceof ISeriesData) {
                iDataObject = ((ISeriesData)iDataObject).getFirstObject();
            }
            return iDataObject.getDicomObject().getString(n);
        }
        return null;
    }

    public static boolean evaluate(Condition condition, IEvaluationContext iEvaluationContext) {
        Object object;
        IDataObject iDataObject = null;
        if (iEvaluationContext instanceof DataEvaluationContext) {
            iDataObject = ((DataEvaluationContext)iEvaluationContext).getDataObject();
        } else if (iEvaluationContext instanceof DisplaySetEvaluable) {
            iDataObject = ((DisplaySetEvaluable)iEvaluationContext).getSeries();
        }
        if (iDataObject != null) {
            String string;
            object = condition.getOperator();
            if (object == OperatorEnum.EQUAL) {
                String string2 = Condition.getTag(iDataObject, condition.getTag());
                if (string2 != null) {
                    return string2.equalsIgnoreCase(condition.value);
                }
            } else if (object == OperatorEnum.CONTAINS) {
                String string3 = Condition.getTag(iDataObject, condition.getTag());
                if (string3 != null) {
                    return StringUtils.containsIgnoreCase((CharSequence)string3, (CharSequence)condition.value);
                }
            } else if (object == OperatorEnum.DOESNOTCONTAIN && (string = Condition.getTag(iDataObject, condition.getTag())) != null) {
                return !StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)condition.value);
            }
        }
        if ((object = conditionCache.get((Object)condition)) == null) {
            object = OperatorEnum.createBooleanNode(condition.getTag(), condition.getOperator(), condition.getValue());
            if (object != null) {
                conditionCache.put(condition, (BooleanNode)object);
            } else {
                return false;
            }
        }
        return object.evaluate(iEvaluationContext);
    }

    public Condition clone() {
        Condition condition = new Condition();
        condition.operator = this.operator;
        condition.value = this.value;
        condition.setTag(this.getTag());
        return condition;
    }

    public String generatedDescription() {
        return ConditionListEntry.getPlainString(this);
    }

    @Override
    public String toString() {
        return this.generatedDescription();
    }

    public String tagName() {
        return xmlName;
    }
}

