/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.model.xml;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplaySetConditionRule;
import com.agfa.pacs.impaxee.hanging.model.xml.ReferencedDescriptor;
import com.tiani.config.xml.minijaxb.AbstractIntermediateXMLElement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DisplaySetCondition
extends AbstractIntermediateXMLElement {
    private static final String CONDITION_SEPARATOR = "|";
    private static final Pattern CONDITION_SEPARATOR_PATTERN = Pattern.compile(Pattern.quote("|"));
    private IDisplaySet baseDisplaySet;
    private final List<DisplaySetConditionRule> rules = new ArrayList<DisplaySetConditionRule>();

    public DisplaySetCondition() {
        this.rules.add(new DisplaySetConditionRule());
    }

    public void runtimeSetBaseDisplaySet(IDisplaySet iDisplaySet) {
        this.baseDisplaySet = iDisplaySet;
    }

    public IDisplaySet baseDisplaySet() {
        return this.baseDisplaySet;
    }

    public String getName() {
        if (this.rules.isEmpty()) {
            return null;
        }
        return this.rules.get(0).getName();
    }

    public void setName(String string) {
        if (!this.rules.isEmpty()) {
            this.rules.get(0).setName(string);
        }
    }

    public final ReferencedDescriptor getReferencedDescriptor(int n) {
        if (this.rules.isEmpty()) {
            return null;
        }
        return this.rules.get(0).getReferencedDescriptor(n);
    }

    public void addReferencedDescriptor(ReferencedDescriptor referencedDescriptor) {
        if (!this.rules.isEmpty()) {
            this.rules.get(0).addReferencedDescriptor(referencedDescriptor);
        }
    }

    public List<DisplaySetConditionRule> rules() {
        return this.rules;
    }

    public DisplaySetConditionRule createRule(String string) {
        DisplaySetConditionRule displaySetConditionRule = new DisplaySetConditionRule();
        displaySetConditionRule.setName(string);
        this.rules.add(displaySetConditionRule);
        return displaySetConditionRule;
    }

    public void removeRule(int n) {
        this.rules.remove(n);
    }

    public boolean hasNoConditions() {
        return this.rules.isEmpty() || this.rules.stream().allMatch(displaySetConditionRule -> displaySetConditionRule.referencedDescriptorList().isEmpty());
    }

    public String getAdditionalDescriptors() {
        return this.rules.stream().skip(1L).map(DisplaySetConditionRule::toXMLAttribute).collect(Collectors.joining(CONDITION_SEPARATOR));
    }

    public void setAdditionalDescriptors(String string) {
        String[] stringArray = CONDITION_SEPARATOR_PATTERN.split(string);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            this.rules.add(new DisplaySetConditionRule(string2));
            ++n2;
        }
    }

    public DisplaySetCondition clone() {
        DisplaySetCondition displaySetCondition2 = new DisplaySetCondition();
        displaySetCondition2.rules.clear();
        for (DisplaySetConditionRule displaySetConditionRule : this.rules) {
            displaySetCondition2.rules.add(displaySetConditionRule.clone());
        }
        return displaySetCondition2;
    }
}

