/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.model.xml;

import com.agfa.pacs.impaxee.hanging.model.IDisplayLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.IScreenLayoutDefinition;
import com.agfa.pacs.impaxee.hanging.model.xml.AbstractLayoutable;
import com.agfa.pacs.impaxee.hanging.model.xml.DisplayLayout;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;

public class ScreenLayout
extends AbstractLayoutable
implements IScreenLayoutDefinition {
    private static final ALogger log = ALogger.getLogger(ScreenLayout.class);
    private List<DisplayLayout> displayLayouts = new ArrayList<DisplayLayout>();
    private Boolean onlyOneStudyEnabled = Boolean.FALSE;

    public ScreenLayout() {
    }

    public ScreenLayout(IScreenLayoutDefinition iScreenLayoutDefinition) {
        this.initFrom(iScreenLayoutDefinition);
    }

    @Override
    public Boolean getOnlyOneStudyEnabled() {
        return this.onlyOneStudyEnabled;
    }

    @Override
    public void setOnlyOneStudyEnabled(Boolean bl) {
        this.onlyOneStudyEnabled = bl != null ? bl : Boolean.FALSE;
    }

    @Override
    public DisplayLayout getDisplayLayout(int n) {
        if (n < 0 || n >= this.displayLayouts.size()) {
            return null;
        }
        return this.displayLayouts.get(n);
    }

    public void addDisplayLayout(DisplayLayout displayLayout) {
        this.displayLayouts.add(displayLayout);
    }

    public DisplayLayout[] displayLayouts() {
        return this.displayLayouts.toArray(new DisplayLayout[this.displayLayouts.size()]);
    }

    @Override
    public void clear() {
        this.displayLayouts.clear();
    }

    @Override
    public int displayLayoutCount() {
        return this.displayLayouts.size();
    }

    public ScreenLayout clone() {
        ScreenLayout screenLayout = new ScreenLayout();
        screenLayout.initFrom(this);
        return screenLayout;
    }

    private void initFrom(IScreenLayoutDefinition iScreenLayoutDefinition) {
        this.setHorizontalXVertical(iScreenLayoutDefinition.getHorizontalXVertical());
        IDisplayLayoutDefinition[] iDisplayLayoutDefinitionArray = iScreenLayoutDefinition.displayLayouts();
        int n = iDisplayLayoutDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplayLayoutDefinition iDisplayLayoutDefinition = iDisplayLayoutDefinitionArray[n2];
            this.displayLayouts.add(new DisplayLayout(iDisplayLayoutDefinition));
            ++n2;
        }
        this.onlyOneStudyEnabled = iScreenLayoutDefinition.getOnlyOneStudyEnabled();
    }

    @Override
    public boolean removeDisplayLayout(IDisplayLayoutDefinition iDisplayLayoutDefinition) {
        return this.displayLayouts.remove(iDisplayLayoutDefinition);
    }

    @Override
    public IDisplayLayoutDefinition appendDisplayLayout(String string) {
        DisplayLayout displayLayout = new DisplayLayout(string);
        this.addDisplayLayout(displayLayout);
        return displayLayout;
    }

    @Override
    public void appendDisplayLayout(IDisplayLayoutDefinition iDisplayLayoutDefinition) {
        if (iDisplayLayoutDefinition instanceof DisplayLayout) {
            this.addDisplayLayout((DisplayLayout)iDisplayLayoutDefinition);
        } else {
            log.error("Cannot add a display layout definition that is not of type DisplayLayout.");
        }
    }
}

