/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.registry;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.AbstractRegistry;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.impl.DefaultHangingProtocol;
import com.agfa.pacs.impaxee.hanging.model.IHangingProtocolDefinition;
import com.agfa.pacs.impaxee.hanging.model.enums.DefaultHangingProtocolType;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingDefinition;
import com.agfa.pacs.impaxee.hanging.model.xml.HangingProtocol;
import com.agfa.pacs.impaxee.hanging.model.xml.OrderHanging;
import com.agfa.pacs.impaxee.hanging.model.xml.ReferencedRole;
import com.agfa.pacs.impaxee.hanging.model.xml.Snapshot;
import com.agfa.pacs.impaxee.utils.Checksumm;
import com.agfa.pacs.impaxee.utils.StorageStamp;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.URLProviderFactory;
import com.tiani.config.xml.minijaxb.MarshalException;
import com.tiani.config.xml.minijaxb.XmlLoader;
import com.tiani.config.xml.minijaxb.XmlSaveable;
import com.tiani.config.xml.minijaxb.XmlSaver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class HPRegistry
extends AbstractRegistry<HangingProtocol> {
    private static final ALogger log = ALogger.getLogger(HPRegistry.class);
    private DefaultHangingProtocol defaultHangingProtocol = null;
    private static HPRegistry instance = new HPRegistry();
    private boolean hpCouldBeEdited = false;
    private List<HangingProtocol> currentActiveHP = null;

    public void couldBeEdited() {
        this.hpCouldBeEdited = true;
    }

    public static HPRegistry getInstance() {
        return instance;
    }

    private HPRegistry() {
        super(new ArrayList(), null);
        this.loadFromConfig();
    }

    public void addHangingProtocol(HangingProtocol hangingProtocol) {
        this.currentActiveHP = null;
        int n = this.addElement(hangingProtocol);
        this.setPriority(n);
    }

    protected int addElementInternal(int n, HangingProtocol hangingProtocol) {
        this.currentActiveHP = null;
        n = super.addElementInternal(n, (Object)hangingProtocol);
        this.setPriority(0);
        return n;
    }

    public void addAll(Collection<HangingProtocol> collection) {
        this.currentActiveHP = null;
        super.addAll(collection);
        this.setPriority(0);
    }

    public boolean removeElement(HangingProtocol hangingProtocol) {
        this.currentActiveHP = null;
        return super.removeElement((Object)hangingProtocol);
    }

    protected HangingProtocol removeElementAtInternal(int n) {
        this.currentActiveHP = null;
        return (HangingProtocol)super.removeElementAtInternal(n);
    }

    public void deleteHangingProtocol(HangingProtocol hangingProtocol) {
        this.removeElement(hangingProtocol);
    }

    protected void fireListChanged() {
        super.fireListChanged();
        this.currentActiveHP = null;
    }

    public synchronized List<HangingProtocol> getActiveHangingProtocolsForCurrentRole() {
        if (this.currentActiveHP == null) {
            this.currentActiveHP = Collections.unmodifiableList(this.getActiveHangingProtocolsForRole(URLProviderFactory.getProvider().getLoginInformation().getRole()));
        }
        return this.currentActiveHP;
    }

    private List<HangingProtocol> getActiveHangingProtocolsForRole(String string) {
        ArrayList<HangingProtocol> arrayList = new ArrayList<HangingProtocol>();
        for (HangingProtocol hangingProtocol : this.getAll()) {
            int n = 0;
            boolean bl = true;
            if (!hangingProtocol.getActive().booleanValue()) continue;
            if (string == null || string.length() == 0) {
                arrayList.add(hangingProtocol);
                continue;
            }
            ReferencedRole[] referencedRoleArray = hangingProtocol.getHangingAccessAuthorization().roles();
            int n2 = referencedRoleArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ReferencedRole referencedRole = referencedRoleArray[n3];
                if (string.startsWith(referencedRole.getName())) {
                    int n4 = referencedRole.getName().length();
                    if (string.length() == n4) {
                        bl = referencedRole.getForbidden();
                        break;
                    }
                    if (n4 > n) {
                        n = n4;
                        bl = referencedRole.getForbidden();
                    }
                }
                ++n3;
            }
            if (bl) continue;
            arrayList.add(hangingProtocol);
        }
        return arrayList;
    }

    public void importHangingProtocol(HangingProtocol hangingProtocol) {
        hangingProtocol.setName(this.createUniqueName(hangingProtocol.getName()));
        this.addHangingProtocol(hangingProtocol);
    }

    private void loadFromConfig() {
        this.removeAll();
        this.storageStamps.clear();
        IConfigurationList iConfigurationList = Config.impaxee.jvision.HANGMAN.hangingProtocols.getList();
        XmlLoader xmlLoader = new XmlLoader();
        ArrayList<HangingProtocol> arrayList = new ArrayList<HangingProtocol>();
        boolean bl = ConfigurationProviderFactory.getConfig().isSupportingRoles();
        for (Map.Entry entry : iConfigurationList.getChildrenItems().entrySet()) {
            IConfigurationProvider iConfigurationProvider = (IConfigurationProvider)entry.getValue();
            if (!iConfigurationProvider.exists("content")) continue;
            String string = iConfigurationProvider.getText("content");
            try {
                HangingProtocol hangingProtocol = (HangingProtocol)xmlLoader.load(string, HangingProtocol.class);
                if (hangingProtocol != null) {
                    this.storageStamps.put(hangingProtocol, new StorageStamp((String)entry.getKey(), Checksumm.getChecksumm(string)));
                    arrayList.add(hangingProtocol);
                    if (!bl) continue;
                    hangingProtocol.getHangingAccessAuthorization().forceNonInheritedStateForEnterpriseRoles();
                    continue;
                }
                log.error("Cannot parse hanging protocol: " + string);
            }
            catch (MarshalException marshalException) {
                log.error("Cannot parse hanging protocol: " + string, (Throwable)marshalException);
            }
        }
        Collections.sort(arrayList, new PriorityComparator());
        this.addAll(arrayList);
    }

    public void save() {
        if (this.hpCouldBeEdited) {
            this.writeToConfig(Config.impaxee.jvision.HANGMAN.hangingProtocols.getKey());
        }
        XmlSaver xmlSaver = new XmlSaver((XmlSaveable)this.getDefaultHangingProtocol());
        try {
            String string = xmlSaver.toXmlString();
            if (!Config.impaxee.jvision.HANGMAN.defaultHangingProtocol.get().equals(string)) {
                IConfigurationProvider iConfigurationProvider = this.getConfigurationProviderForEnterpriseLevel();
                iConfigurationProvider.exists("xyz");
                iConfigurationProvider.setText(Config.impaxee.jvision.HANGMAN.defaultHangingProtocol.getKey(), string);
            }
        }
        catch (Exception exception) {
            log.error("Cannot save default HP to config...", (Throwable)exception);
        }
    }

    private void setPriority(int n) {
        int n2 = n;
        while (n2 < this.getSize()) {
            ((HangingProtocol)this.getElementAt(n2)).setPriority(n2);
            ++n2;
        }
    }

    @Override
    protected HangingProtocol parseXML(String string) {
        XmlLoader xmlLoader = new XmlLoader();
        try {
            return (HangingProtocol)xmlLoader.load(string, HangingProtocol.class);
        }
        catch (MarshalException marshalException) {
            log.error("Cannot parse hanging protocol XML: " + string, (Throwable)marshalException);
            return null;
        }
    }

    public DefaultHangingProtocol getDefaultHangingProtocol() {
        if (this.defaultHangingProtocol == null) {
            this.defaultHangingProtocol = this.createDefaultHangingProtocol();
        }
        return this.defaultHangingProtocol;
    }

    private DefaultHangingProtocol createDefaultHangingProtocol() {
        XmlLoader xmlLoader = new XmlLoader();
        DefaultHangingProtocol defaultHangingProtocol2 = null;
        String string = Config.impaxee.jvision.HANGMAN.defaultHangingProtocol.get();
        try {
            defaultHangingProtocol2 = (DefaultHangingProtocol)xmlLoader.load(string, DefaultHangingProtocol.class);
            if (defaultHangingProtocol2 == null) {
                log.error("Cannot parse default hanging protocol: " + string);
                defaultHangingProtocol2 = HPRegistry.createEmptyHangingProtocol();
            }
            if (defaultHangingProtocol2.getHangingDefinition().snapshots().length == 0) {
                log.info("Found no snapshot in default hanging... add a new");
                defaultHangingProtocol2.getHangingDefinition().addSnapshot(new Snapshot("1"));
            }
            if (defaultHangingProtocol2.getType() == null) {
                log.info("Found missing type");
                defaultHangingProtocol2.setType(DefaultHangingProtocolType.BLANK);
            }
            defaultHangingProtocol2.checkAndCorrectHP();
        }
        catch (MarshalException marshalException) {
            log.error("Cannot parse default hanging protocol: " + string, (Throwable)marshalException);
            defaultHangingProtocol2 = HPRegistry.createEmptyHangingProtocol();
        }
        return defaultHangingProtocol2;
    }

    public static DefaultHangingProtocol createEmptyHangingProtocol() {
        DefaultHangingProtocol defaultHangingProtocol2 = new DefaultHangingProtocol();
        defaultHangingProtocol2.getHangingDefinition().addSnapshot(new Snapshot());
        defaultHangingProtocol2.setCreatedBy("Agfa HealthCare GmbH");
        defaultHangingProtocol2.setLastModifiedBy("Agfa HealthCare GmbH");
        defaultHangingProtocol2.setHangingDefinition(new HangingDefinition());
        return defaultHangingProtocol2;
    }

    public static DefaultHangingProtocol createDefaultOrderHanging() {
        DefaultHangingProtocol defaultHangingProtocol2 = HPRegistry.createEmptyHangingProtocol();
        Snapshot snapshot = new Snapshot();
        snapshot.setLayout(null);
        snapshot.setOrderHanging(new OrderHanging());
        defaultHangingProtocol2.getHangingDefinition().addSnapshot(snapshot);
        return defaultHangingProtocol2;
    }

    public synchronized void resetCurrentActiveHPs() {
        this.currentActiveHP = null;
    }

    private static class PriorityComparator
    implements Comparator<IHangingProtocolDefinition> {
        private PriorityComparator() {
        }

        @Override
        public int compare(IHangingProtocolDefinition iHangingProtocolDefinition, IHangingProtocolDefinition iHangingProtocolDefinition2) {
            if (iHangingProtocolDefinition != null && iHangingProtocolDefinition.getPriority() != null) {
                if (iHangingProtocolDefinition2 != null && iHangingProtocolDefinition2.getPriority() != null) {
                    return iHangingProtocolDefinition.getPriority().compareTo(iHangingProtocolDefinition2.getPriority());
                }
                return -1;
            }
            if (iHangingProtocolDefinition2 == null || iHangingProtocolDefinition2.getPriority() == null) {
                return 0;
            }
            return 1;
        }
    }
}

