/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.runtime;

import com.agfa.pacs.data.shared.primitives.IntHashSet;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.impl.AbstractHangingSnapshotModel;
import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.AbstractHangingRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.DisplayLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingDefinitionRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.ScreenLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.SnapshotUtil;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import java.util.List;

public abstract class HangingProtocolRuntime
extends AbstractHangingRuntime {
    private IntHashSet usedDisplaySets = null;
    protected Boolean active = Boolean.TRUE;
    protected Integer priority;
    protected IHanging.SnapshotModel snapshotModel;
    private HangingDefinitionRuntime hangingDefinition;

    protected HangingProtocolRuntime() {
    }

    public HangingProtocolRuntime(String string) {
        super(string);
    }

    public abstract void ensurePriorsLoaded();

    public HangingDefinitionRuntime getHangingDefinition() {
        return this.hangingDefinition;
    }

    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public IHanging.SnapshotModel getSnapshotModel() {
        if (this.snapshotModel == null) {
            this.snapshotModel = new MySnapshotModel();
        }
        return this.snapshotModel;
    }

    public Boolean getActive() {
        return this.active;
    }

    abstract boolean save();

    public void setActive(Boolean bl) {
        this.active = bl;
    }

    public final void setHangingDefinition(HangingDefinitionRuntime hangingDefinitionRuntime) {
        this.hangingDefinition = hangingDefinitionRuntime;
    }

    public final void setPriority(Integer n) {
        this.priority = n;
    }

    public String toString() {
        return this.getVisibleName();
    }

    @Override
    public void displaySetAdded(IPatientRepresentation iPatientRepresentation, List<IDisplaySet> list, SplitAndSortChangeType splitAndSortChangeType) {
    }

    @Override
    public void displaySetsRemoved(IDisplaySet[] iDisplaySetArray, SplitAndSortChangeType splitAndSortChangeType) {
        HangingProtocolSnapshotRuntime[] hangingProtocolSnapshotRuntimeArray = this.hangingDefinition.snapshots();
        int n = hangingProtocolSnapshotRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime = hangingProtocolSnapshotRuntimeArray[n2];
            if (hangingProtocolSnapshotRuntime.getLayout() != null) {
                ScreenLayoutRuntime[] screenLayoutRuntimeArray = hangingProtocolSnapshotRuntime.getLayout().screenLayouts();
                int n3 = screenLayoutRuntimeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ScreenLayoutRuntime screenLayoutRuntime = screenLayoutRuntimeArray[n4];
                    DisplayLayoutRuntime[] displayLayoutRuntimeArray = screenLayoutRuntime.displayLayouts();
                    int n5 = displayLayoutRuntimeArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        DisplayLayoutRuntime displayLayoutRuntime = displayLayoutRuntimeArray[n6];
                        IDisplaySet[] iDisplaySetArray2 = iDisplaySetArray;
                        int n7 = iDisplaySetArray.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            IDisplaySet iDisplaySet = iDisplaySetArray2[n8];
                            if (displayLayoutRuntime.getDisplaySet() == iDisplaySet) {
                                displayLayoutRuntime.setDisplaySet(null);
                            }
                            ++n8;
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public boolean isDisplaySetAlreadyUsed(IDisplaySet iDisplaySet) {
        if (this.usedDisplaySets == null) {
            return false;
        }
        return this.usedDisplaySets.contains(iDisplaySet.getID());
    }

    protected boolean afterUpdate(HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime) {
        this.save();
        return true;
    }

    public void markDisplaySetAsLoaded(IDisplaySet iDisplaySet) {
        if (this.usedDisplaySets == null) {
            this.usedDisplaySets = new IntHashSet(32);
        }
        this.usedDisplaySets.add(iDisplaySet.getID());
    }

    private class MySnapshotModel
    extends AbstractHangingSnapshotModel {
        @Override
        public void add(AbstractSnapshotRuntime abstractSnapshotRuntime) {
            if (abstractSnapshotRuntime instanceof HangingProtocolSnapshotRuntime) {
                ((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime).setUseRuntimeForSave(true);
                HangingProtocolRuntime.this.hangingDefinition.addSnapshot((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime);
                if (!HangingProtocolRuntime.this.afterUpdate((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime)) {
                    HangingProtocolRuntime.this.hangingDefinition.removeSnapshot((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime);
                }
            }
        }

        @Override
        public void delete(int n) {
            if (n >= 0 && n < HangingProtocolRuntime.this.hangingDefinition.getSnapshotCount()) {
                HangingProtocolRuntime.this.hangingDefinition.deleteSnapshot(n);
            }
            HangingProtocolRuntime.this.save();
            this.fireRemoveEvent(n);
        }

        @Override
        public int indexOf(AbstractSnapshotRuntime abstractSnapshotRuntime) {
            return HangingProtocolRuntime.this.hangingDefinition.indexOf(abstractSnapshotRuntime);
        }

        @Override
        public AbstractSnapshotRuntime get(int n) {
            return HangingProtocolRuntime.this.hangingDefinition.getSnapshot(n);
        }

        @Override
        public AbstractSnapshotRuntime get(String string) {
            return HangingProtocolRuntime.this.hangingDefinition.snapshotForName(string);
        }

        @Override
        public void insertAt(int n, AbstractSnapshotRuntime abstractSnapshotRuntime) {
            if (abstractSnapshotRuntime instanceof HangingProtocolSnapshotRuntime) {
                HangingProtocolRuntime.this.hangingDefinition.insertSnapshotAt(n, (HangingProtocolSnapshotRuntime)abstractSnapshotRuntime);
                HangingProtocolRuntime.this.save();
                this.fireAddEvent(n, abstractSnapshotRuntime);
            }
        }

        @Override
        public HangingProtocolSnapshotRuntime newInstance() {
            HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime = new HangingProtocolSnapshotRuntime(SnapshotUtil.findNextSnapshotName(HangingProtocolRuntime.this), HangingProtocolRuntime.this.getHangingDefinition());
            hangingProtocolSnapshotRuntime.capture();
            hangingProtocolSnapshotRuntime.setHangingApplied(true);
            return hangingProtocolSnapshotRuntime;
        }

        @Override
        public AbstractSnapshotRuntime remove(int n) {
            AbstractSnapshotRuntime abstractSnapshotRuntime = this.get(n);
            this.delete(n);
            HangingProtocolRuntime.this.save();
            return abstractSnapshotRuntime;
        }

        @Override
        public int size() {
            return HangingProtocolRuntime.this.hangingDefinition.getSnapshotCount();
        }

        @Override
        public void update(int n) {
            HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime = (HangingProtocolSnapshotRuntime)this.get(n);
            hangingProtocolSnapshotRuntime.capture();
            if (!HangingProtocolRuntime.this.afterUpdate(hangingProtocolSnapshotRuntime)) {
                hangingProtocolSnapshotRuntime.setClearCachedDSAfterFirstUse(true);
            }
            this.fireUpdateEvent(n);
        }
    }
}

