/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.hanging.runtime;

import com.agfa.pacs.impaxee.data.manager.IDataManagerListener;
import com.agfa.pacs.impaxee.hanging.HangingType;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IMultiplePatientHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.impl.DefaultHangingProtocol;
import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.model.enums.DefaultHangingProtocolType;
import com.agfa.pacs.impaxee.hanging.runtime.DisplayLayoutRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingDefinitionRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.ScreenLayoutRuntime;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.tiani.base.data.IPatientData;
import com.tiani.gui.dialog.IHideableDialogStateProvider;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;

public class MultiPatientHangingProtocolRuntime
extends HangingProtocolRuntime
implements IMultiplePatientHanging,
IDataManagerListener {
    private static final Icon ICON = IAIconFactory.DEFAULT_FACTORY.loadIcon("hangingcase_multiple_patient.svg");
    private List<IPatientRepresentation> patients = new ArrayList<IPatientRepresentation>(2);
    private IHideableDialogStateProvider hideableDialogStateProvider;

    public MultiPatientHangingProtocolRuntime(String string) {
        super(string);
        DefaultHangingProtocol defaultHangingProtocol2 = new DefaultHangingProtocol(DefaultHangingProtocolType.USER_DEFINED);
        this.setHangingDefinition(new HangingDefinitionRuntime(defaultHangingProtocol2.getHangingDefinition(), (HangingProtocolRuntime)this));
    }

    public void addPatient(IPatientRepresentation iPatientRepresentation) {
        if (!this.patients.contains(iPatientRepresentation)) {
            this.patients.add(iPatientRepresentation);
        }
    }

    @Override
    public void ensurePriorsLoaded() {
    }

    @Override
    public List<IDisplaySet> getDisplaySets() {
        return Collections.emptyList();
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public HangingType getHangingType() {
        return HangingType.PATIENT_COMPARE_HP;
    }

    @Override
    public Collection<IPatientRepresentation> getPatients() {
        return Collections.unmodifiableCollection(this.patients);
    }

    @Override
    public ISplitAndSortRuntime getSplitAndSortRuntime() {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation != null) {
            return iPatientRepresentation.getDecompositionRuntime();
        }
        return null;
    }

    @Override
    public IStudyContainer getStudyContainer() {
        return null;
    }

    public void removePatient(IPatientRepresentation iPatientRepresentation) {
        this.patients.remove(iPatientRepresentation);
    }

    @Override
    boolean save() {
        return false;
    }

    @Override
    public void patientRemoved(IPatientRepresentation iPatientRepresentation, boolean bl) {
        HangingProtocolSnapshotRuntime[] hangingProtocolSnapshotRuntimeArray = this.getHangingDefinition().snapshots();
        int n = hangingProtocolSnapshotRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HangingProtocolSnapshotRuntime hangingProtocolSnapshotRuntime = hangingProtocolSnapshotRuntimeArray[n2];
            if (hangingProtocolSnapshotRuntime.getLayout() != null) {
                ScreenLayoutRuntime[] screenLayoutRuntimeArray = hangingProtocolSnapshotRuntime.getLayout().screenLayouts();
                int n3 = screenLayoutRuntimeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ScreenLayoutRuntime screenLayoutRuntime = screenLayoutRuntimeArray[n4];
                    DisplayLayoutRuntime[] displayLayoutRuntimeArray = screenLayoutRuntime.displayLayouts();
                    int n5 = displayLayoutRuntimeArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        DisplayLayoutRuntime displayLayoutRuntime = displayLayoutRuntimeArray[n6];
                        IDisplaySet iDisplaySet = displayLayoutRuntime.getDisplaySet();
                        if (iDisplaySet != null && Objects.equals(iDisplaySet.getStudy().getParent().getKey(), iPatientRepresentation.getPatientKey())) {
                            displayLayoutRuntime.setDisplaySet(null);
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @Override
    public String getIdentifier() {
        return this.getVisibleName();
    }

    public IHideableDialogStateProvider getHideableDialogStateProvider() {
        if (this.hideableDialogStateProvider == null) {
            this.hideableDialogStateProvider = new MyHideableDialogStateProvider();
        }
        return this.hideableDialogStateProvider;
    }

    @Override
    public void hangingStateRemoved(IHanging iHanging) {
    }

    @Override
    public void patientAdded(IPatientRepresentation iPatientRepresentation) {
    }

    @Override
    public void patientRepresentationModified(IPatientRepresentation iPatientRepresentation) {
    }

    @Override
    public void patientsSorted(Comparator<IPatientData> comparator) {
    }

    @Override
    public void patientWillBeRemoved(IPatientRepresentation iPatientRepresentation) {
    }

    private static class MyHideableDialogStateProvider
    implements IHideableDialogStateProvider {
        private boolean isVisible = true;

        private MyHideableDialogStateProvider() {
        }

        @Override
        public boolean isVisible() {
            return this.isVisible;
        }

        @Override
        public void setVisible(boolean bl) {
            this.isVisible = bl;
        }
    }
}

